/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.core.def.CtorDef;
import org.aya.core.term.DataCall;
import org.aya.core.term.Term;
import org.aya.generic.util.NormalizeMode;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.tyck.error.UnifyInfo;
import org.aya.util.Arg;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.aya.util.tyck.pat.PatClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClausesProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    private static Doc termToHint(@Nullable Term term, @NotNull PrettierOptions options) {
        return term == null ? Doc.empty() : Doc.sep((Doc[])new Doc[]{Doc.english((String)"(confluence check: this clause is substituted to)"), Doc.code((Doc)term.toDoc(options))});
    }

    public record FMDomination(int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.sub), Doc.english((String)"clause is dominated by the other clauses, hence unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record Domination(int dom, int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc subOrdinal = Doc.ordinal((int)this.sub);
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.dom), Doc.english((String)"clause dominates the"), subOrdinal, Doc.english((String)"clause. The"), subOrdinal, Doc.english((String)"clause will be unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record UnsureCase(@NotNull SourcePos sourcePos, @NotNull CtorDef ctor, @NotNull DataCall dataCall) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"I'm unsure if there should be a case for constructor"), Doc.par((int)1, (Doc)this.ctor.toDoc(options)), Doc.english((String)"because I got stuck on the index unification of type"), Doc.par((int)1, (Doc)this.dataCall.toDoc(options))});
        }
    }

    public record MissingCase(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<PatClass<ImmutableSeq<Arg<Term>>>> errs) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc cases = Doc.vcat((SeqLike)this.errs.map(err -> BasePrettier.argsDoc(options, (SeqLike)err.term())));
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Unhandled case:"), Doc.nest((int)2, (Doc)cases)});
        }
    }

    public record Confluence(@NotNull SourcePos sourcePos, int i, int j, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info, @NotNull SourcePos iPos, @NotNull SourcePos jPos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc line = Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"and the"), Doc.ordinal((int)this.j), Doc.english((String)"clauses are not confluent because we failed to unify")});
            return this.info.describeUnify(options, this.comparison, line, Doc.plain((String)"and"));
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return ClausesProblem.super.level();
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            return Seq.of((Object)new WithPos(this.iPos, (Object)ClausesProblem.termToHint(this.comparison.expected(), options)), (Object)new WithPos(this.jPos, (Object)ClausesProblem.termToHint(this.comparison.actual(), options))).view();
        }
    }

    public record Conditions(@NotNull SourcePos sourcePos, @NotNull SourcePos iPos, int i, int j, @NotNull ImmutableSeq<Arg<Term>> args, @NotNull UnifyInfo info, @NotNull UnifyInfo.Comparison comparison) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc begin = Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"clause matches on a constructor with condition(s). When checking the"), Doc.ordinal((int)this.j), Doc.english((String)"condition, we failed to unify")});
            Doc end = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"for the arguments:"), Doc.par((int)1, (Doc)BasePrettier.argsDoc(options, this.args)), Doc.english((String)"Normalized:"), Doc.par((int)1, (Doc)BasePrettier.argsDoc(options, this.args.map(a -> a.descent(t -> t.normalize(this.info.state(), NormalizeMode.NF)))))});
            return this.info.describeUnify(options, this.comparison, begin, end);
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            Doc data = ClausesProblem.termToHint(this.comparison.actual(), options);
            return Seq.of((Object)new WithPos(this.iPos, (Object)data)).view();
        }
    }
}

