/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import kala.collection.primitive.IntSeqLike;
import kala.control.Result;
import kala.tuple.Tuple2;
import org.aya.concrete.stmt.decl.TeleDecl;
import org.aya.core.def.CtorDef;
import org.aya.core.def.DataDef;
import org.aya.core.def.Def;
import org.aya.core.pat.Pat;
import org.aya.core.term.ConCall;
import org.aya.core.term.ConCallLike;
import org.aya.core.term.DataCall;
import org.aya.core.term.ErrorTerm;
import org.aya.core.term.RefTerm;
import org.aya.core.term.SigmaTerm;
import org.aya.core.term.Term;
import org.aya.core.term.TupTerm;
import org.aya.core.visitor.EndoTerm;
import org.aya.core.visitor.Subst;
import org.aya.pretty.doc.Doc;
import org.aya.ref.AnyVar;
import org.aya.ref.DefVar;
import org.aya.tyck.error.TyckOrderError;
import org.aya.tyck.pat.ClausesProblem;
import org.aya.tyck.pat.PatternTycker;
import org.aya.tyck.tycker.StatedTycker;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.Arg;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.aya.util.tyck.pat.ClassifierUtil;
import org.aya.util.tyck.pat.Indexed;
import org.aya.util.tyck.pat.PatClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PatClassifier
extends StatedTycker
implements ClassifierUtil<Subst, Term, Term.Param, Pat, AnyVar> {
    @NotNull
    public final SourcePos pos;

    public PatClassifier(@NotNull Reporter reporter,  @Nullable Trace.Builder traceBuilder, @NotNull TyckState state, @NotNull SourcePos pos) {
        super(reporter, traceBuilder, state);
        this.pos = pos;
    }

    @NotNull
    public static ImmutableSeq<PatClass<ImmutableSeq<Arg<Term>>>> classify(@NotNull @NotNull SeqLike<? extends @NotNull Pat.Preclause<?>> clauses, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull StatedTycker tycker, @NotNull SourcePos pos) {
        return PatClassifier.classify(clauses, telescope, tycker.state, tycker.reporter, pos, tycker.traceBuilder);
    }

    @VisibleForTesting
    @NotNull
    public static ImmutableSeq<PatClass<ImmutableSeq<Arg<Term>>>> classify(@NotNull @NotNull SeqLike<? extends @NotNull Pat.Preclause<?>> clauses, @NotNull ImmutableSeq<Term.Param> telescope, @NotNull TyckState state, @NotNull Reporter reporter, @NotNull SourcePos pos,  @Nullable Trace.Builder builder) {
        PatClassifier classifier = new PatClassifier(reporter, builder, state, pos);
        ImmutableSeq cl = classifier.classifyN(new Subst(), telescope.view(), clauses.view().mapIndexed((i, clause) -> new Indexed((Object)clause.patterns().view().map(Arg::term), i)).toImmutableSeq(), 2);
        Tuple2 p = cl.partition(c -> c.cls().isEmpty());
        ImmutableSeq missing = (ImmutableSeq)p.component1();
        if (missing.isNotEmpty()) {
            reporter.report((Problem)new ClausesProblem.MissingCase(pos, (ImmutableSeq<PatClass<ImmutableSeq<Arg<Term>>>>)missing));
        }
        return (ImmutableSeq)p.component2();
    }

    public Term.Param subst(Subst subst, Term.Param param) {
        return param.subst(subst);
    }

    public Pat normalize(Pat pat) {
        return pat.inline(null);
    }

    public Subst add(Subst subst, AnyVar anyVar, Term term) {
        return subst.add(anyVar, term);
    }

    public AnyVar ref(Term.Param param) {
        return param.ref();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ImmutableSeq<PatClass<Arg<Term>>> classify1(@NotNull Subst subst, @NotNull Term.Param param, @NotNull ImmutableSeq<Indexed<Pat>> clauses, int fuel) {
        Term whnfTy = this.whnf(param.type());
        boolean explicit = param.explicit();
        Term term = whnfTy;
        Objects.requireNonNull(term);
        Term term2 = term;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SigmaTerm.class, DataCall.class}, (Object)term2, n)) {
            case 0: {
                ImmutableSeq<Term.Param> params;
                SigmaTerm sigmaTerm = (SigmaTerm)term2;
                try {
                    ImmutableSeq<Term.Param> immutableSeq;
                    params = immutableSeq = sigmaTerm.params();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
                if (!clauses.anyMatch(i -> i.pat() instanceof Pat.Tuple)) return ImmutableSeq.of((Object)new PatClass(param.toArg(), Indexed.indices(clauses)));
                ImmutableSeq<Term.Param> params1 = new EndoTerm.Renamer().params((SeqView<Term.Param>)params.view());
                ImmutableSeq matches = clauses.mapIndexedNotNull((i, subPat) -> {
                    Pat pat = (Pat)subPat.pat();
                    Objects.requireNonNull(pat);
                    Pat selector0$temp = pat;
                    int index$1 = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Tuple.class, Pat.Bind.class}, (Object)selector0$temp, index$1)) {
                        case 0 -> {
                            Pat.Tuple tuple = (Pat.Tuple)selector0$temp;
                            yield new Indexed((Object)tuple.pats().view().map(Arg::term), i);
                        }
                        case 1 -> {
                            Pat.Bind bind = (Pat.Bind)selector0$temp;
                            yield new Indexed((Object)params1.view().map(p -> (Pat)p.toPat().term()), i);
                        }
                        default -> null;
                    };
                });
                ImmutableSeq classes = this.classifyN(subst.derive(), params1.view(), matches, fuel);
                return classes.map(args -> new PatClass((Object)new Arg((Object)new TupTerm((ImmutableSeq<Arg<Term>>)((ImmutableSeq)args.term())), explicit), args.cls()));
            }
            case 1: {
                DataCall dataCall = (DataCall)term2;
                if (clauses.isNotEmpty() && clauses.noneMatch(subPat -> subPat.pat() instanceof Pat.Ctor || subPat.pat() instanceof Pat.ShapedInt)) {
                    return ImmutableSeq.of((Object)new PatClass(param.toArg(), Indexed.indices(clauses)));
                }
                AnyVar data = dataCall.ref();
                Seq<CtorDef> body = Def.dataBody((DefVar<? extends DataDef, ? extends TeleDecl.DataDecl>)data);
                if (((DefVar)data).core == null) {
                    this.reporter.report((Problem)new TyckOrderError.NotYetTyckedError(this.pos, data));
                }
                ImmutableSeq lits = clauses.mapNotNull(cl -> {
                    Indexed indexed;
                    Object patt0$temp = cl.pat();
                    if (patt0$temp instanceof Pat.ShapedInt) {
                        Pat.ShapedInt i = (Pat.ShapedInt)patt0$temp;
                        indexed = new Indexed((Object)i, cl.ix());
                    } else {
                        indexed = null;
                    }
                    return indexed;
                });
                ImmutableIntSeq binds = Indexed.indices((Seq)clauses.filter(cl -> cl.pat() instanceof Pat.Bind));
                if (clauses.isNotEmpty() && lits.size() + binds.size() == clauses.size()) {
                    ImmutableSeq classes = Seq.from(((Map)lits.collect(Collectors.groupingBy(i -> ((Pat.ShapedInt)i.pat()).repr()))).values()).map(i -> new PatClass((Object)new Arg((Object)((Pat.ShapedInt)((Indexed)i.get(0)).pat()).toTerm(), explicit), Indexed.indices((Seq)Seq.wrapJava((List)i)).concat((IntSeqLike)binds)));
                    MutableArrayList ml = MutableArrayList.create((int)(classes.size() + 1));
                    ml.appendAll((Iterable)classes);
                    ml.append((Object)new PatClass((Object)new Arg((Object)new RefTerm(param.ref()), explicit), binds));
                    return ml.toImmutableSeq();
                }
                MutableList buffer = MutableList.create();
                Iterator iterator = body.iterator();
                while (iterator.hasNext()) {
                    CtorDef ctor = (CtorDef)iterator.next();
                    int fuel1 = fuel;
                    SeqView<Term.Param> conTeleView = this.conTele(clauses, dataCall, ctor);
                    if (conTeleView == null) continue;
                    ImmutableSeq<Term.Param> conTele = new EndoTerm.Renamer().params(conTeleView);
                    ImmutableSeq matches = clauses.mapIndexedNotNull((ix, subPat) -> PatClassifier.matches(conTele, ctor, ix, (Indexed<Pat>)subPat));
                    ConCallLike.Head conHead = dataCall.conHead(ctor.ref);
                    if (matches.isEmpty() && (conTele.isEmpty() || --fuel1 <= 0)) {
                        ErrorTerm err = new ErrorTerm(Doc.plain((String)"..."), false);
                        buffer.append((Object)new PatClass((Object)new Arg((Object)new ConCall(conHead, (ImmutableSeq<Arg<Term>>)(conTele.isEmpty() ? ImmutableSeq.empty() : ImmutableSeq.of((Object)new Arg((Object)err, true)))), explicit), ImmutableIntSeq.empty()));
                        continue;
                    }
                    ImmutableSeq classes = this.classifyN(subst.derive(), conTele.view(), matches, fuel1);
                    buffer.appendAll((Iterable)classes.map(args -> new PatClass((Object)new Arg((Object)new ConCall(conHead, (ImmutableSeq<Arg<Term>>)((ImmutableSeq)args.term())), explicit), args.cls())));
                }
                return buffer.toImmutableSeq();
            }
        }
        return ImmutableSeq.of((Object)new PatClass(param.toArg(), Indexed.indices(clauses)));
    }

    @Nullable
    private static Indexed<SeqView<Pat>> matches(ImmutableSeq<Term.Param> conTele, CtorDef ctor, int ix, Indexed<Pat> subPat) {
        Indexed indexed;
        Pat pat;
        Object object = subPat.pat();
        if (object instanceof Pat.ShapedInt) {
            Pat.ShapedInt i = (Pat.ShapedInt)object;
            pat = (Pat)i.constructorForm();
        } else {
            pat = (Pat)subPat.pat();
        }
        Objects.requireNonNull(pat);
        Pat pat2 = pat;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Ctor.class, Pat.Bind.class}, (Object)pat2, n)) {
                case 0: {
                    Pat.Ctor c = (Pat.Ctor)pat2;
                    if (c.ref() != ctor.ref()) {
                        n = 1;
                        continue block4;
                    }
                    indexed = new Indexed((Object)c.params().view().map(Arg::term), ix);
                    break block4;
                }
                case 1: {
                    Pat.Bind b = (Pat.Bind)pat2;
                    indexed = new Indexed((Object)conTele.view().map(p -> (Pat)p.toPat().term()), ix);
                    break block4;
                }
                default: {
                    indexed = null;
                    break block4;
                }
            }
            break;
        }
        return indexed;
    }

    public static int[] firstMatchDomination(@NotNull ImmutableSeq<? extends SourceNode> clauses, @NotNull Reporter reporter, @NotNull ImmutableSeq<? extends PatClass<?>> classes) {
        return ClassifierUtil.firstMatchDomination(clauses, (T pos, int i) -> reporter.report((Problem)new ClausesProblem.FMDomination(i, (SourcePos)pos)), classes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private SeqView<Term.Param> conTele(@NotNull ImmutableSeq<? extends Indexed<?>> clauses, DataCall dataCall, CtorDef ctor) {
        SeqView conTele = ctor.selfTele.view();
        Result<Subst, Boolean> matchy = PatternTycker.mischa(dataCall, ctor, this.state);
        if (!matchy.isErr()) return conTele.map(param -> param.subst((Subst)matchy.get()));
        if ((Boolean)matchy.getErr() == false) return null;
        if (!clauses.isNotEmpty()) return conTele;
        if (!clauses.noneMatch(seq -> seq.pat() instanceof Pat.Bind)) return conTele;
        this.reporter.report((Problem)new ClausesProblem.UnsureCase(this.pos, ctor, dataCall));
        return null;
    }
}

