/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.util.function.Supplier;
import org.aya.concrete.Expr;
import org.aya.core.term.AppTerm;
import org.aya.core.term.PiTerm;
import org.aya.core.term.Term;
import org.aya.ref.LocalVar;
import org.aya.tyck.Result;
import org.aya.tyck.env.LocalCtx;
import org.aya.tyck.trace.Trace;
import org.aya.tyck.tycker.StatedTycker;
import org.aya.tyck.tycker.TyckState;
import org.aya.tyck.unify.Synthesizer;
import org.aya.tyck.unify.Unifier;
import org.aya.util.Arg;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MockTycker
extends StatedTycker {
    @NotNull
    public LocalCtx ctx;

    protected MockTycker(@NotNull Reporter reporter, @Nullable Trace.Builder traceBuilder, @NotNull TyckState state, @NotNull LocalCtx ctx) {
        super(reporter, traceBuilder, state);
        this.ctx = ctx;
    }

    @NotNull
    public Unifier unifier(@NotNull SourcePos pos, @NotNull Ordering ord) {
        return this.unifier(pos, ord, this.ctx);
    }

    @NotNull
    public Synthesizer synthesizer() {
        return new Synthesizer(this.state, this.ctx);
    }

    @NotNull
    protected final Term mockTerm(Term.Param param, SourcePos pos) {
        String genName = param.ref().name().concat("'");
        return (Term)this.ctx.freshHole(param.type(), genName, pos).component2();
    }

    @NotNull
    protected final Arg<Term> mockArg(Term.Param param, SourcePos pos) {
        return new Arg((Object)this.mockTerm(param, pos), param.explicit());
    }

    @NotNull
    protected final Term generatePi(@NotNull Expr.Lambda expr) {
        Expr.Param param = expr.param();
        return this.generatePi(expr.sourcePos(), param.ref().name(), param.explicit());
    }

    @NotNull
    private Term generatePi(@NotNull SourcePos pos, @NotNull String name, boolean explicit) {
        String genName = name + "'";
        Term domain = (Term)this.ctx.freshTyHole(genName + "ty", pos).component2();
        Term codomain = (Term)this.ctx.freshTyHole(genName + "ret", pos).component2();
        return new PiTerm(new Term.Param(new LocalVar(genName, pos), domain, explicit), codomain);
    }

    protected final Result instImplicits(@NotNull Result result, @NotNull SourcePos pos) {
        PiTerm pi;
        Term type = this.whnf(result.type());
        Term term = result.wellTyped();
        while (type instanceof PiTerm && !(pi = (PiTerm)type).param().explicit()) {
            Arg<Term> holeApp = this.mockArg(pi.param(), pos);
            term = AppTerm.make(term, holeApp);
            type = this.whnf(pi.substBody((Term)holeApp.term()));
        }
        return new Result.Default(term, type);
    }

    public <R> R subscoped(@NotNull Supplier<R> action) {
        LocalCtx parentCtx = this.ctx;
        this.ctx = parentCtx.deriveMap();
        R result = action.get();
        this.ctx = parentCtx;
        return result;
    }
}

