/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.nio.file.Path;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.control.Result;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.ModuleSymbol;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.UseHide;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.GenerateKind;
import org.aya.syntax.ref.LocalVar;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ModuleContext
extends Context
permits NoExportContext, PhysicalModuleContext {
    @Override
    @NotNull
    public Context parent();

    @Override
    @NotNull
    default public Reporter reporter() {
        return this.parent().reporter();
    }

    @Override
    @NotNull
    default public Path underlyingFile() {
        return this.parent().underlyingFile();
    }

    @NotNull
    public ModuleSymbol<AnyVar> symbols();

    @NotNull
    public MutableMap<ModuleName.Qualified, ModuleExport> modules();

    @NotNull
    public ModuleExport exports();

    @Override
    @Nullable
    default public ModuleExport getModuleLocalMaybe(@NotNull ModuleName.Qualified modName) {
        return (ModuleExport)this.modules().getOrNull((Object)modName);
    }

    @Override
    @Nullable
    default public AnyVar getUnqualifiedLocalMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        Result<AnyVar, ModuleSymbol.Error> symbol = this.symbols().getUnqualifiedMaybe(name);
        if (symbol.isOk()) {
            return (AnyVar)symbol.get();
        }
        switch ((ModuleSymbol.Error)((Object)symbol.getErr())) {
            case NotFound: {
                break;
            }
            case Ambiguous: {
                this.reportAndThrow(new NameProblem.AmbiguousNameError(name, this.symbols().resolveUnqualified(name).moduleNames(), sourcePos));
            }
        }
        return null;
    }

    @Override
    @Nullable
    default public AnyVar getQualifiedLocalMaybe(@NotNull ModuleName.Qualified modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        ModuleExport mod = (ModuleExport)this.modules().getOrNull((Object)modName);
        if (mod == null) {
            return null;
        }
        Result<AnyDefVar, ModuleSymbol.Error> ref = mod.symbols().getUnqualifiedMaybe(name);
        if (ref.isOk()) {
            return (AnyVar)ref.get();
        }
        return switch ((ModuleSymbol.Error)((Object)ref.getErr())) {
            default -> throw new MatchException(null, null);
            case ModuleSymbol.Error.NotFound -> (AnyVar)this.reportAndThrow(new NameProblem.QualifiedNameNotFoundError((ModuleName)modName, name, sourcePos));
            case ModuleSymbol.Error.Ambiguous -> (AnyVar)this.reportAndThrow(new NameProblem.AmbiguousNameError(name, mod.symbols().resolveUnqualified(name).moduleNames(), sourcePos));
        };
    }

    default public void importModule(@NotNull ModuleName.Qualified modName, @NotNull ModuleContext module, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        ModuleExport export = module.exports();
        this.importModule(modName, export, accessibility, sourcePos);
        export.modules().forEach((name, mod) -> this.importModule(modName.concat((ModuleName)name), (ModuleExport)mod, accessibility, sourcePos));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void importModule(@NotNull ModuleName.Qualified modName, @NotNull ModuleExport moduleExport, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        MutableMap<ModuleName.Qualified, ModuleExport> modules = this.modules();
        ModuleExport exists = (ModuleExport)modules.getOrNull((Object)modName);
        if (exists != null) {
            if (exists == moduleExport) return;
            this.reportAndThrow(new NameProblem.DuplicateModNameError((ModuleName)modName, sourcePos));
        } else if (this.getModuleMaybe(modName) != null) {
            this.fail(new NameProblem.ModShadowingWarn((ModuleName)modName, sourcePos));
        }
        modules.set((Object)modName, (Object)moduleExport);
    }

    default public void openModule(@NotNull ModuleName.Qualified modName, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos, @NotNull UseHide useHide) {
        this.openModule(modName, accessibility, (ImmutableSeq<QualifiedID>)useHide.list().map(UseHide.Name::id), (ImmutableSeq<WithPos<UseHide.Rename>>)useHide.renaming(), sourcePos, useHide.strategy());
    }

    default public void openModule(@NotNull ModuleName.Qualified modName, @NotNull Stmt.Accessibility accessibility, @NotNull ImmutableSeq<QualifiedID> filter, @NotNull ImmutableSeq<WithPos<UseHide.Rename>> rename, @NotNull SourcePos sourcePos, UseHide.Strategy strategy) {
        ModuleExport filtered;
        ModuleExport.ExportResult mapRes;
        ModuleExport.ExportResult filterRes;
        ModuleExport modExport = this.getModuleMaybe(modName);
        if (modExport == null) {
            this.reportAndThrow(new NameProblem.ModNameNotFoundError((ModuleName)modName, sourcePos));
        }
        if ((filterRes = modExport.filter(filter, strategy)).anyError()) {
            this.reportAllAndThrow((SeqLike<Problem>)filterRes.problems((ModuleName)modName));
        }
        if ((mapRes = (filtered = filterRes.result()).map((Seq<WithPos<UseHide.Rename>>)rename)).anyError()) {
            this.reportAllAndThrow((SeqLike<Problem>)mapRes.problems((ModuleName)modName));
        }
        this.reportAll((SeqLike<Problem>)filterRes.problems((ModuleName)modName).concat(mapRes.problems((ModuleName)modName)));
        ModuleExport renamed = mapRes.result();
        renamed.symbols().forEach((name, candidates) -> candidates.forEach((componentName, ref) -> {
            ModuleName.Qualified fullComponentName = modName.concat(componentName);
            this.importSymbol(true, (AnyVar)ref, (ModuleName)fullComponentName, (String)name, accessibility, sourcePos);
        }));
        renamed.modules().forEach((qname, mod) -> this.importModule((ModuleName.Qualified)qname, (ModuleExport)mod, accessibility, sourcePos));
    }

    default public void importSymbol(boolean imported, @NotNull AnyVar ref, @NotNull ModuleName modName, @NotNull String name, @NotNull Stmt.Accessibility acc, @NotNull SourcePos sourcePos) {
        if (!2.$assertionsDisabled && !imported && modName != ModuleName.This) {
            throw new AssertionError((Object)"Sanity check");
        }
        ModuleSymbol<AnyVar> symbols = this.symbols();
        ModuleSymbol.UnqualifiedResolve<AnyVar> candidates = symbols.resolveUnqualified(name);
        if (candidates.map().isEmpty()) {
            LocalVar local;
            if (!(this.getUnqualifiedMaybe(name, sourcePos) == null || ref instanceof LocalVar && (local = (LocalVar)ref).generateKind() == GenerateKind.Basic.Anonymous)) {
                this.fail(new NameProblem.ShadowingWarn(name, sourcePos));
            }
        } else if (candidates.map().containsKey((Object)modName)) {
            this.reportAndThrow(new NameProblem.DuplicateNameError(name, ref, sourcePos));
        } else {
            ImmutableSeq<AnyVar> uniqueCandidates = candidates.uniqueCandidates();
            if (uniqueCandidates.size() != 1 || uniqueCandidates.iterator().next() != ref) {
                this.reporter().report((Problem)new NameProblem.AmbiguousNameWarn(name, sourcePos));
                if (candidates.map().containsKey((Object)ModuleName.This)) {
                    if (!2.$assertionsDisabled && candidates.map().size() != 1) {
                        throw new AssertionError();
                    }
                    return;
                }
                if (modName == ModuleName.This) {
                    ((MutableMap)candidates.asMut().get()).clear();
                }
            } else {
                if (!2.$assertionsDisabled && modName == ModuleName.This) {
                    throw new AssertionError((Object)"Sanity check");
                }
                if (!2.$assertionsDisabled && !candidates.moduleNames().allMatch(x -> x instanceof ModuleName.Qualified)) {
                    throw new AssertionError();
                }
            }
        }
        Option<AnyVar> result = symbols.add(modName, name, ref);
        if (!2.$assertionsDisabled && !result.isEmpty()) {
            throw new AssertionError((Object)"Sanity check");
        }
        if (ref instanceof DefVar) {
            boolean success;
            DefVar defVar = (DefVar)ref;
            if (acc == Stmt.Accessibility.Public && !(success = this.exportSymbol(modName, name, (AnyDefVar)defVar))) {
                this.reportAndThrow(new NameProblem.DuplicateExportError(name, sourcePos));
            }
        }
    }

    default public boolean exportSymbol(@NotNull ModuleName modName, @NotNull String name, @NotNull AnyDefVar ref) {
        return true;
    }

    default public void defineSymbol(@NotNull AnyVar ref, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        this.importSymbol(false, ref, (ModuleName)ModuleName.This, ref.name(), accessibility, sourcePos);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

