/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import kala.collection.Map;
import kala.collection.MapLike;
import kala.collection.MapView;
import kala.collection.SetView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import kala.control.Result;
import kala.tuple.Tuple2;
import kala.value.LazyValue;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.jetbrains.annotations.NotNull;

public record ModuleSymbol<T>(@NotNull MutableMap<String, MutableMap<ModuleName, T>> table) {
    public ModuleSymbol() {
        this(MutableMap.create());
    }

    public ModuleSymbol(@NotNull ModuleSymbol<T> other) {
        this((MutableMap)other.table.toImmutableSeq().collect(MutableMap.collector(Tuple2::component1, x -> MutableMap.from((MapLike)((MapLike)x.component2())))));
    }

    @NotNull
    public UnqualifiedResolve<T> resolveUnqualified(@NotNull String unqualifiedName) {
        MutableMap names = (MutableMap)this.table.getOrNull((Object)unqualifiedName);
        return new UnqualifiedResolve(names != null ? names.view() : MapView.empty(), LazyValue.of(() -> (MutableMap)this.table.getOrPut((Object)unqualifiedName, MutableMap::create)));
    }

    @NotNull
    public Option<T> getQualifiedMaybe(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        return this.resolveUnqualified((String)unqualifiedName).map.getOption((Object)component);
    }

    @NotNull
    public Result<T, Error> getUnqualifiedMaybe(@NotNull String unqualifiedName) {
        UnqualifiedResolve<T> candidates = this.resolveUnqualified(unqualifiedName);
        if (candidates.map.isEmpty()) {
            return Result.err((Object)((Object)Error.NotFound));
        }
        ImmutableSeq<T> uniqueCandidates = candidates.uniqueCandidates();
        if (uniqueCandidates.size() != 1) {
            return Result.err((Object)((Object)Error.Ambiguous));
        }
        return Result.ok(uniqueCandidates.iterator().next());
    }

    @NotNull
    public Result<T, Error> getMaybe(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        ModuleName moduleName = component;
        Objects.requireNonNull(moduleName);
        ModuleName moduleName2 = moduleName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleName.Qualified.class, ModuleName.ThisRef.class}, (Object)moduleName2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ModuleName.Qualified qualified = (ModuleName.Qualified)moduleName2;
                yield this.getQualifiedMaybe(component, unqualifiedName).toResult((Object)Error.NotFound);
            }
            case 1 -> {
                ModuleName.ThisRef aThis = (ModuleName.ThisRef)moduleName2;
                yield this.getUnqualifiedMaybe(unqualifiedName);
            }
        };
    }

    public boolean contains(@NotNull String unqualified) {
        return this.resolveUnqualified((String)unqualified).map.isNotEmpty();
    }

    public boolean contains(@NotNull ModuleName component, @NotNull String unqualified) {
        return this.resolveUnqualified((String)unqualified).map.containsKey((Object)component);
    }

    public Option<T> add(@NotNull ModuleName componentName, @NotNull String name, @NotNull T ref) {
        MutableMap candidates = (MutableMap)this.resolveUnqualified((String)name).asMut.get();
        return candidates.put((Object)componentName, ref);
    }

    public Option<T> remove(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        return this.table().getOption((Object)unqualifiedName).flatMap(x -> x.remove((Object)component));
    }

    public Result<T, Error> removeDefinitely(@NotNull String unqualifiedName) {
        UnqualifiedResolve<T> candidates = this.resolveUnqualified(unqualifiedName);
        if (candidates.map.isEmpty()) {
            return Result.err((Object)((Object)Error.NotFound));
        }
        ImmutableSeq<T> uniqueCandidates = candidates.uniqueCandidates();
        if (uniqueCandidates.size() != 1) {
            return Result.err((Object)((Object)Error.Ambiguous));
        }
        Object result = uniqueCandidates.iterator().next();
        ((MutableMap)candidates.asMut.get()).clear();
        return Result.ok(result);
    }

    public Result<T, Error> removeDefinitely(@NotNull ModuleName component, @NotNull String unqualifiedName) {
        ModuleName moduleName = component;
        Objects.requireNonNull(moduleName);
        ModuleName moduleName2 = moduleName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleName.Qualified.class, ModuleName.ThisRef.class}, (Object)moduleName2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ModuleName.Qualified qualified = (ModuleName.Qualified)moduleName2;
                Option<T> result = this.remove(component, unqualifiedName);
                if (result.isEmpty()) {
                    yield Result.err((Object)((Object)Error.NotFound));
                }
                yield Result.ok((Object)result.get());
            }
            case 1 -> {
                ModuleName.ThisRef aThis = (ModuleName.ThisRef)moduleName2;
                yield this.removeDefinitely(unqualifiedName);
            }
        };
    }

    @NotNull
    public SetView<String> keysView() {
        return this.table.keysView();
    }

    @NotNull
    public MapView<String, Map<ModuleName, T>> view() {
        return this.table.view().mapValues((k, v) -> v);
    }

    public void forEach(@NotNull BiConsumer<String, Map<ModuleName, T>> action) {
        this.table.forEach(action);
    }

    public record UnqualifiedResolve<T>(@NotNull MapView<ModuleName, T> map, @NotNull LazyValue<MutableMap<ModuleName, T>> asMut) {
        @NotNull
        public ImmutableSeq<T> uniqueCandidates() {
            return this.map.valuesView().distinct().toImmutableSeq();
        }

        @NotNull
        public ImmutableSeq<ModuleName> moduleNames() {
            return this.map.keysView().toImmutableSeq();
        }
    }

    public static enum Error {
        NotFound,
        Ambiguous;

    }
}

