/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableStack;
import kala.control.Either;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.generic.stmt.TyckOrder;
import org.aya.generic.stmt.TyckUnit;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.error.GeneralizedNotAvailableError;
import org.aya.resolve.visitor.PatternResolver;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.concrete.stmt.Generalize;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.GeneralizedVar;
import org.aya.syntax.ref.LocalVar;
import org.aya.util.error.Panic;
import org.aya.util.error.PosedUnaryOperator;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record ExprResolver(@NotNull Context ctx, @NotNull Options options, @NotNull MutableMap<GeneralizedVar, Expr.Param> allowedGeneralizes, @NotNull MutableList<TyckOrder> reference, @NotNull MutableStack<Where> where) implements PosedUnaryOperator<Expr>
{
    @NotNull
    public static final Options RESTRICTIVE = new Options(false);
    @NotNull
    public static final Options LAX = new Options(true);

    public ExprResolver(@NotNull Context ctx, @NotNull Options options) {
        this(ctx, options, (MutableMap<GeneralizedVar, Expr.Param>)MutableLinkedHashMap.of(), (MutableList<TyckOrder>)MutableList.create(), (MutableStack<Where>)MutableStack.create());
    }

    @Contract(pure=true)
    public static WithPos<Expr> resolveLax(@NotNull ModuleContext context, @NotNull WithPos<Expr> expr) {
        ExprResolver resolver = new ExprResolver(context, LAX);
        resolver.enter(Where.FnBody);
        WithPos inner = expr.descent((PosedUnaryOperator)resolver);
        SeqView view = resolver.allowedGeneralizes().valuesView().toImmutableSeq().view();
        return Expr.buildLam((SourcePos)expr.sourcePos(), (SeqView)view, (WithPos)inner);
    }

    public void resetRefs() {
        this.reference.clear();
    }

    public void enter(Where loc) {
        this.where.push((Object)loc);
    }

    public void exit() {
        this.where.pop();
    }

    @NotNull
    public ExprResolver enter(Context ctx) {
        return ctx == this.ctx() ? this : new ExprResolver(ctx, this.options, this.allowedGeneralizes, this.reference, this.where);
    }

    @NotNull
    public ExprResolver deriveRestrictive() {
        return new ExprResolver(this.ctx, RESTRICTIVE, this.allowedGeneralizes, this.reference, this.where);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Expr pre(@NotNull Expr expr) {
        Expr expr2;
        Expr expr3 = expr;
        Objects.requireNonNull(expr3);
        Expr expr32 = expr3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Proj.class, Expr.Hole.class}, (Object)expr32, n)) {
            case 0: {
                WithPos theCore;
                WithPos ix;
                WithPos tup;
                Expr.Proj proj = (Expr.Proj)expr32;
                try {
                    WithPos withPos;
                    tup = withPos = proj.tup();
                    ix = withPos = proj.ix();
                    withPos = proj.resolvedVar();
                    theCore = withPos = proj.theCoreType();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (ix.isLeft()) {
                    expr2 = expr;
                    return expr2;
                }
                QualifiedID projName = (QualifiedID)ix.getRightValue();
                AnyVar resolvedIx = this.ctx.getMaybe(projName);
                expr2 = new Expr.Proj(tup, (Either)ix, resolvedIx, (MutableValue)theCore);
                return expr2;
            }
            case 1: {
                WithPos local;
                WithPos fill;
                boolean expl;
                Expr.Hole hole = (Expr.Hole)expr32;
                {
                    WithPos withPos;
                    boolean bl;
                    expl = bl = hole.explicit();
                    fill = withPos = hole.filling();
                    local = withPos = hole.accessibleLocal();
                }
                assert (local.isEmpty());
                expr2 = new Expr.Hole(expl, fill, this.ctx.collect((MutableList<LocalVar>)MutableList.create()).toImmutableSeq());
                return expr2;
            }
        }
        expr2 = expr;
        return expr2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Expr apply(@NotNull SourcePos pos, @NotNull Expr expr) {
        Expr expr2;
        Expr expr3 = this.pre(expr);
        Objects.requireNonNull(expr3);
        Expr expr32 = expr3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Do.class, Expr.Lambda.class, Expr.Pi.class, Expr.Sigma.class, Expr.Array.class, Expr.Unresolved.class, Expr.Let.class, Expr.LetOpen.class, Expr.class}, (Object)expr32, n)) {
            case 0: {
                Expr.Do doExpr = (Expr.Do)expr32;
                expr2 = doExpr.update(this.apply(SourcePos.NONE, doExpr.bindName()), this.bind((ImmutableSeq<Expr.DoBind>)doExpr.binds(), (MutableValue<Context>)MutableValue.create((Object)this.ctx)));
                return expr2;
            }
            case 1: {
                Expr.Lambda lam = (Expr.Lambda)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                mCtx.update(ctx -> ExprResolver.bindAs(lam.ref(), ctx));
                expr2 = lam.update(lam.body().descent((PosedUnaryOperator)this.enter((Context)mCtx.get())));
                return expr2;
            }
            case 2: {
                Expr.Pi pi = (Expr.Pi)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                Expr.Param param2 = this.bind(pi.param(), (MutableValue<Context>)mCtx);
                expr2 = pi.update(param2, pi.last().descent((PosedUnaryOperator)this.enter((Context)mCtx.get())));
                return expr2;
            }
            case 3: {
                Expr.Sigma sigma = (Expr.Sigma)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                ImmutableSeq params = sigma.params().map(param -> this.bind((Expr.Param)param, (MutableValue<Context>)mCtx));
                expr2 = sigma.update(params);
                return expr2;
            }
            case 4: {
                Expr.Array array = (Expr.Array)expr32;
                expr2 = array.update(array.arrayBlock().map(left -> {
                    MutableValue mCtx = MutableValue.create((Object)this.ctx);
                    ImmutableSeq<Expr.DoBind> binds = this.bind((ImmutableSeq<Expr.DoBind>)left.binds(), (MutableValue<Context>)mCtx);
                    WithPos generator = left.generator().descent((PosedUnaryOperator)this.enter((Context)mCtx.get()));
                    return left.update(generator, binds, left.names().fmap(arg_0 -> ((ExprResolver)this).forceApply(arg_0)));
                }, right -> right.descent((PosedUnaryOperator)this)));
                return expr2;
            }
            case 5: {
                AnyVar anyVar;
                QualifiedID qualifiedID;
                Expr.Unresolved unresolved = (Expr.Unresolved)expr32;
                try {
                    QualifiedID name = qualifiedID = unresolved.name();
                    anyVar = this.ctx.get(name);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Objects.requireNonNull(anyVar);
                qualifiedID = anyVar;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, AnyVar.class}, (Object)qualifiedID, n2)) {
                    case 0: {
                        GeneralizedVar generalized = (GeneralizedVar)qualifiedID;
                        if (!this.allowedGeneralizes.containsKey((Object)generalized)) {
                            if (this.options.allowIntroduceGeneralized) {
                                Generalize owner = generalized.owner;
                                assert (owner != null) : "Sanity check";
                                this.allowedGeneralizes.put((Object)generalized, (Object)owner.toExpr(false, generalized.toLocal()));
                                this.addReference((TyckUnit)owner);
                            } else {
                                this.ctx.reportAndThrow(new GeneralizedNotAvailableError(pos, (AnyVar)generalized));
                            }
                        }
                        expr2 = new Expr.Ref((AnyVar)((Expr.Param)this.allowedGeneralizes.get((Object)generalized)).ref());
                        return expr2;
                    }
                    case 1: {
                        DefVar def = (DefVar)qualifiedID;
                        this.addReference(def);
                        expr2 = new Expr.Ref((AnyVar)def);
                        return expr2;
                    }
                }
                QualifiedID var = qualifiedID;
                expr2 = new Expr.Ref((AnyVar)var);
                return expr2;
            }
            case 6: {
                Expr.Let let = (Expr.Let)expr32;
                Expr.LetBind letBind = let.bind();
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                ImmutableSeq telescope = letBind.telescope().map(param -> this.bind((Expr.Param)param, (MutableValue<Context>)mCtx));
                ExprResolver resolver = this.enter((Context)mCtx.get());
                WithPos result = letBind.result().descent((PosedUnaryOperator)resolver);
                WithPos definedAs = letBind.definedAs().descent((PosedUnaryOperator)resolver);
                WithPos newBody = let.body().descent((PosedUnaryOperator)this.enter(this.ctx.bind(letBind.bindName())));
                expr2 = let.update(letBind.update(telescope, result, definedAs), newBody);
                return expr2;
            }
            case 7: {
                Expr.LetOpen letOpen = (Expr.LetOpen)expr32;
                NoExportContext context = new NoExportContext(this.ctx);
                context.openModule(letOpen.componentName(), Stmt.Accessibility.Private, letOpen.sourcePos(), letOpen.useHide());
                expr2 = letOpen.update(letOpen.body().descent((PosedUnaryOperator)this.enter(context)));
                return expr2;
            }
        }
        Expr newExpr = expr32;
        expr2 = newExpr.descent((PosedUnaryOperator)this);
        return expr2;
    }

    private void addReference(@NotNull TyckUnit unit) {
        if (this.where.isEmpty()) {
            throw new Panic("where am I?");
        }
        switch (((Where)((Object)this.where.peek())).ordinal()) {
            default: {
                this.reference.append((Object)new TyckOrder.Head(unit));
                break;
            }
            case 3: {
                this.reference.append((Object)new TyckOrder.Body(unit));
                if (!(unit instanceof DataCon)) break;
                DataCon con = (DataCon)unit;
                this.reference.append((Object)new TyckOrder.Body((TyckUnit)con.dataRef.concrete));
            }
        }
    }

    private void addReference(@NotNull DefVar<?, ?> defVar) {
        this.addReference((TyckUnit)defVar.concrete);
    }

    @NotNull
    public Pattern.Clause clause(@NotNull Pattern.Clause clause) {
        MutableValue mCtx = MutableValue.create((Object)this.ctx);
        this.enter(Where.FnPattern);
        ImmutableSeq pats = clause.patterns.map(pa -> pa.descent(pat -> this.resolvePattern((WithPos<Pattern>)pat, (MutableValue<Context>)mCtx)));
        this.exit();
        this.enter(Where.FnBody);
        Option body = clause.expr.map(x -> x.descent((PosedUnaryOperator)this.enter((Context)mCtx.get())));
        this.exit();
        return clause.update(pats, body);
    }

    @NotNull
    public WithPos<Pattern> resolvePattern(@NotNull WithPos<Pattern> pattern, MutableValue<Context> ctx) {
        PatternResolver resolver = new PatternResolver((Context)ctx.get(), this::addReference);
        WithPos result = pattern.descent((PosedUnaryOperator)resolver);
        ctx.set((Object)resolver.context());
        return result;
    }

    private static Context bindAs(@NotNull LocalVar as, @NotNull Context ctx) {
        return ctx.bind(as);
    }

    @NotNull
    public Expr.Param bind(@NotNull Expr.Param param, @NotNull MutableValue<Context> ctx) {
        Expr.Param p = param.descent((PosedUnaryOperator)this.enter((Context)ctx.get()));
        ctx.set((Object)((Context)ctx.get()).bind(param.ref()));
        return p;
    }

    @NotNull
    public ImmutableSeq<Expr.DoBind> bind(@NotNull ImmutableSeq<Expr.DoBind> binds, @NotNull MutableValue<Context> ctx) {
        return binds.map(bind -> {
            Expr.DoBind b = bind.descent((PosedUnaryOperator)this.enter((Context)ctx.get()));
            ctx.set((Object)((Context)ctx.get()).bind(bind.var()));
            return b;
        });
    }

    public record Options(boolean allowIntroduceGeneralized) {
    }

    public static enum Where {
        Head,
        ConPattern,
        FnSimple,
        FnPattern,
        FnBody;

    }
}

