/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import org.aya.generic.stmt.TyckUnit;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.concrete.stmt.decl.PrimDecl;
import org.aya.syntax.core.def.ConDef;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.util.error.Panic;
import org.aya.util.error.PosedUnaryOperator;
import org.aya.util.error.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternResolver
implements PosedUnaryOperator<Pattern> {
    @NotNull
    private Context context;
    @NotNull
    private final Consumer<TyckUnit> parentAdd;

    public PatternResolver(@NotNull Context context, @NotNull Consumer<TyckUnit> parentAdd) {
        this.context = context;
        this.parentAdd = parentAdd;
    }

    @NotNull
    public Context context() {
        return this.context;
    }

    @NotNull
    public Pattern apply(@NotNull SourcePos pos, @NotNull Pattern pat) {
        return this.post(pos, pat.descent((PosedUnaryOperator)this));
    }

    @NotNull
    public Pattern post(@NotNull SourcePos pos, @NotNull Pattern pat) {
        Pattern pattern = pat;
        Objects.requireNonNull(pattern);
        Pattern pattern2 = pattern;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Bind.class, Pattern.QualifiedRef.class, Pattern.As.class}, (Object)pattern2, n)) {
            case 0 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern2;
                DefVar conMaybe = this.context.iterate(ctx -> PatternResolver.isCon(ctx.getUnqualifiedLocalMaybe(bind.bind().name(), pos)));
                if (conMaybe != null) {
                    DefVar<ConDef, DataCon> cast = PatternResolver.castConVar(conMaybe);
                    this.addReference(conMaybe);
                    yield new Pattern.Con(pos, cast);
                }
                this.context = this.context.bind(bind.bind());
                yield bind;
            }
            case 1 -> {
                Pattern.QualifiedRef qref = (Pattern.QualifiedRef)pattern2;
                QualifiedID qid = qref.qualifiedID();
                ModuleName var9_11 = qid.component();
                if (!(var9_11 instanceof ModuleName.Qualified)) {
                    throw new Panic("QualifiedRef#qualifiedID should be qualified");
                }
                ModuleName.Qualified mod = (ModuleName.Qualified)var9_11;
                DefVar conMaybe = this.context.iterate(ctx -> PatternResolver.isCon(ctx.getQualifiedLocalMaybe(mod, qid.name(), pos)));
                if (conMaybe != null) {
                    DefVar<ConDef, DataCon> cast = PatternResolver.castConVar(conMaybe);
                    this.addReference(cast);
                    yield new Pattern.Con(pos, cast);
                }
                yield (Pattern)this.context.reportAndThrow(new NameProblem.QualifiedNameNotFoundError(qid.component(), qid.name(), pos));
            }
            case 2 -> {
                Pattern.As as = (Pattern.As)pattern2;
                this.context = this.context.bind(as.as());
                yield as;
            }
            default -> pat;
        };
    }

    @NotNull
    private static DefVar<ConDef, DataCon> castConVar(DefVar<?, ?> conMaybe) {
        assert (conMaybe.concrete instanceof DataCon);
        return conMaybe;
    }

    private void addReference(@NotNull DefVar<?, ?> defVar) {
        this.parentAdd.accept((TyckUnit)defVar.concrete);
    }

    @Nullable
    private static DefVar<?, ?> isCon(@Nullable AnyVar myMaybe) {
        if (myMaybe == null) {
            return null;
        }
        if (myMaybe instanceof DefVar) {
            DefVar def = (DefVar)myMaybe;
            if (def.concrete instanceof DataCon || def.concrete instanceof PrimDecl) {
                return def;
            }
        }
        return null;
    }
}

