/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import org.aya.generic.AyaDocile;
import org.aya.prettier.FindUsage;
import org.aya.pretty.doc.Doc;
import org.aya.primitive.PrimFactory;
import org.aya.primitive.ShapeFactory;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.MetaCall;
import org.aya.syntax.ref.LocalCtx;
import org.aya.syntax.ref.MetaVar;
import org.aya.tyck.error.HoleProblem;
import org.aya.unify.Unifier;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public record TyckState(@NotNull MutableList<Eqn> eqns, @NotNull MutableList<WithPos<MetaVar>> activeMetas, @NotNull MutableMap<MetaVar, Term> solutions, @NotNull ShapeFactory shapeFactory, @NotNull PrimFactory primFactory) {
    public TyckState(@NotNull ShapeFactory shapeFactory, @NotNull PrimFactory primFactory) {
        this((MutableList<Eqn>)MutableList.create(), (MutableList<WithPos<MetaVar>>)MutableList.create(), (MutableMap<MetaVar, Term>)MutableMap.create(), shapeFactory, primFactory);
    }

    @ApiStatus.Internal
    public void solve(MetaVar meta, Term candidate) {
        this.solutions.put((Object)meta, (Object)candidate);
    }

    private void solveEqn(@NotNull Reporter reporter, @NotNull Eqn eqn, boolean allowDelay) {
        Unifier unifier = new Unifier(this, eqn.localCtx, reporter, eqn.pos, eqn.cmp, allowDelay);
        if (!allowDelay) {
            unifier.allowVague = true;
        }
        unifier.checkEqn(eqn);
    }

    public void solveMetas(@NotNull Reporter reporter) {
        while (this.eqns.isNotEmpty()) {
            while (this.simplify(reporter)) {
            }
            ImmutableSeq eqns = this.eqns.toImmutableSeq();
            if (!eqns.isNotEmpty()) continue;
            for (Eqn eqn : eqns) {
                this.solveEqn(reporter, eqn, false);
            }
            reporter.report((Problem)new HoleProblem.CannotFindGeneralSolution((ImmutableSeq<Eqn>)eqns));
        }
    }

    @NotNull
    public Term computeSolution(@NotNull MetaCall meta, @NotNull UnaryOperator<Term> f) {
        return (Term)this.solutions.getOption((Object)meta.ref()).map(sol -> (Term)f.apply(MetaCall.app((MetaVar)meta.ref(), (Term)sol, (ImmutableSeq)meta.args()))).getOrDefault((Object)meta);
    }

    private boolean simplify(@NotNull Reporter reporter) {
        MutableList removingMetas = MutableList.create();
        for (WithPos activeMeta : this.activeMetas) {
            MetaVar v = (MetaVar)activeMeta.data();
            if (!this.solutions.containsKey((Object)v)) continue;
            this.eqns.retainIf(eqn -> {
                if (FindUsage.meta((Term)eqn.lhs, (MetaVar)v) + FindUsage.meta((Term)eqn.rhs, (MetaVar)v) > 0) {
                    this.solveEqn(reporter, (Eqn)eqn, true);
                    return false;
                }
                return true;
            });
            removingMetas.append((Object)activeMeta);
        }
        this.activeMetas.removeIf(arg_0 -> ((MutableList)removingMetas).contains(arg_0));
        return removingMetas.isNotEmpty();
    }

    public void addEqn(final Eqn eqn) {
        this.eqns.append((Object)eqn);
        int currentActiveMetas = this.activeMetas.size();
        var consumer = new Consumer<Term>(){

            @Override
            public void accept(Term term) {
                MetaCall hole;
                if (term instanceof MetaCall && !TyckState.this.solutions.containsKey((Object)(hole = (MetaCall)term).ref())) {
                    TyckState.this.activeMetas.append((Object)new WithPos(eqn.pos, (Object)hole.ref()));
                }
                term.descent(tm -> {
                    this.accept((Term)tm);
                    return tm;
                });
            }
        };
        consumer.accept(eqn.lhs);
        consumer.accept(eqn.rhs);
        assert (this.activeMetas.sizeGreaterThan(currentActiveMetas)) : "Adding a bad equation";
    }

    public record Eqn(@NotNull Term lhs, @NotNull Term rhs, @NotNull Ordering cmp, @NotNull SourcePos pos, @NotNull LocalCtx localCtx) implements AyaDocile
    {
        @NotNull
        public Doc toDoc(@NotNull PrettierOptions options) {
            return Doc.stickySep((Doc[])new Doc[]{this.lhs.toDoc(options), Doc.symbol((String)this.cmp.symbol), this.rhs.toDoc(options)});
        }
    }
}

