/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.concrete.Expr;
import org.aya.tyck.error.SourceNodeProblem;
import org.aya.tyck.error.TyckError;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public sealed interface LicitError
extends TyckError,
SourceNodeProblem {

    public static final class ImplicitLam
    extends Record
    implements LicitError {
        @NotNull
        private final WithPos<Expr> expr;

        public ImplicitLam(@NotNull WithPos<Expr> expr) {
            this.expr = expr;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Implicit lambda is not allowed in Aya")});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ImplicitLam.class, "expr", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ImplicitLam.class, "expr", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ImplicitLam.class, "expr", "expr"}, this, o);
        }

        @NotNull
        public WithPos<Expr> expr() {
            return this.expr;
        }
    }

    public static final class BadNamedArg
    extends Record
    implements LicitError {
        @NotNull
        private final Expr.NamedArg expr;

        public BadNamedArg(@NotNull Expr.NamedArg expr) {
            this.expr = expr;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"Named argument unwanted here:"), Doc.code((Doc)this.expr.toDoc(options))}), Doc.english((String)"Named applications are only allowed in direct application to definitions.")});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BadNamedArg.class, "expr", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BadNamedArg.class, "expr", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BadNamedArg.class, "expr", "expr"}, this, o);
        }

        @NotNull
        public Expr.NamedArg expr() {
            return this.expr;
        }
    }

    public static final class BadImplicitArg
    extends Record
    implements LicitError {
        @NotNull
        private final Expr.NamedArg expr;

        public BadImplicitArg(@NotNull Expr.NamedArg expr) {
            this.expr = expr;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unexpected implicit argument"), Doc.code((Doc)this.expr.toDoc(options))});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BadImplicitArg.class, "expr", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BadImplicitArg.class, "expr", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BadImplicitArg.class, "expr", "expr"}, this, o);
        }

        @NotNull
        public Expr.NamedArg expr() {
            return this.expr;
        }
    }
}

