/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.stmt.TyckUnit;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.ref.DefVar;
import org.aya.tyck.error.TyckError;
import org.aya.util.error.Panic;
import org.aya.util.error.SourceNode;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TyckOrderError
extends TyckError {
    @NotNull
    default public String nameOf(@NotNull TyckUnit stmt) {
        TyckUnit tyckUnit = stmt;
        Objects.requireNonNull(tyckUnit);
        TyckUnit tyckUnit2 = tyckUnit;
        int n = 0;
        return (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class}, (Object)tyckUnit2, n)) {
            case 0 -> (Decl)tyckUnit2;
            default -> throw new Panic("Unexpected stmt seen in SCCTycker: " + String.valueOf(stmt));
        }).ref().name();
    }

    @Contract(pure=true)
    @NotNull
    public static Panic notYetTycked(@NotNull DefVar<?, ?> var) {
        Doc msg = Doc.sep((Doc[])new Doc[]{Doc.english((String)"Attempting to use a definition"), Doc.code((Doc)BasePrettier.refVar(var)), Doc.english((String)"which is not yet typechecked")});
        return new Panic(msg.debugRender());
    }

    public record SelfReference(@NotNull TyckUnit unit) implements TyckOrderError
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.unit.sourcePos();
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Self-reference found in the signature of"), Doc.plain((String)this.nameOf(this.unit))});
        }
    }

    public record CircularSignature(@NotNull ImmutableSeq<TyckUnit> cycles) implements TyckOrderError
    {
        @NotNull
        public SourcePos sourcePos() {
            return (SourcePos)this.cycles.view().map(SourceNode::sourcePos).max(Comparator.comparingInt(SourcePos::endLine));
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Circular signature dependency found between"), Doc.commaList((SeqLike)this.cycles.view().map(this::nameOf).toImmutableSeq().sorted().view().map(Doc::plain))});
        }
    }
}

