/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.util.Objects;
import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.core.term.Term;
import org.aya.tyck.TyckState;
import org.aya.tyck.tycker.Stateful;
import org.aya.unify.TermComparator;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public record UnifyInfo(@NotNull TyckState state) implements Stateful
{
    private static void compareExprs(@NotNull Doc mid, Doc actualDoc, Doc expectedDoc, Doc actualNFDoc, Doc expectedNFDoc, MutableList<@NotNull Doc> buf) {
        UnifyInfo.exprInfo(actualDoc, actualNFDoc, buf);
        buf.append((Object)mid);
        UnifyInfo.exprInfo(expectedDoc, expectedNFDoc, buf);
    }

    public static void exprInfo(Doc actualDoc, Doc actualNFDoc, MutableList<@NotNull Doc> buf) {
        buf.append((Object)Doc.par((int)1, (Doc)actualDoc));
        if (!actualNFDoc.equals((Object)actualDoc)) {
            buf.append((Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), actualNFDoc}))));
        }
    }

    public static void exprInfo(Term term, PrettierOptions options, Stateful state, MutableList<@NotNull Doc> buf) {
        UnifyInfo.exprInfo(term.toDoc(options), state.whnf(term).toDoc(options), buf);
    }

    @NotNull
    public Doc describeUnify(@NotNull PrettierOptions options, @NotNull Comparison comparison, @NotNull Doc prologue, @NotNull Doc epilogue) {
        Doc actualDoc = comparison.actual.toDoc(options);
        Doc expectedDoc = comparison.expected.toDoc(options);
        Doc actualNFDoc = this.whnf(comparison.actual).toDoc(options);
        Doc expectedNFDoc = this.whnf(comparison.expected).toDoc(options);
        MutableList buf = MutableList.of((Object)prologue);
        UnifyInfo.compareExprs(epilogue, actualDoc, expectedDoc, actualNFDoc, expectedNFDoc, (MutableList<Doc>)buf);
        Term failureTermL = comparison.failureData.lhs();
        Term failureTermR = comparison.failureData.rhs();
        Doc failureLhs = failureTermL.toDoc(options);
        if (!(Objects.equals(failureLhs, actualDoc) || Objects.equals(failureLhs, expectedDoc) || Objects.equals(failureLhs, actualNFDoc) || Objects.equals(failureLhs, expectedNFDoc))) {
            buf.append((Object)Doc.english((String)"In particular, we failed to unify"));
            UnifyInfo.compareExprs(Doc.plain((String)"with"), failureLhs, failureTermR.toDoc(options), this.whnf(failureTermL).toDoc(options), this.whnf(failureTermR).toDoc(options), (MutableList<Doc>)buf);
        }
        return Doc.vcat((SeqLike)buf);
    }

    public record Comparison(@NotNull Term actual, @NotNull Term expected, @NotNull TermComparator.FailureData failureData) {
    }
}

