/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSeq;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.core.def.Signature;
import org.aya.syntax.core.term.Param;
import org.aya.syntax.core.term.SortTerm;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.ref.LocalCtx;
import org.aya.syntax.ref.LocalVar;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.tycker.Contextful;
import org.aya.unify.Synthesizer;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface TeleTycker
extends Contextful {
    @NotNull
    public Term checkType(@NotNull WithPos<Expr> var1);

    @Contract(pure=true)
    @NotNull
    default public Signature checkSignature(@NotNull ImmutableSeq<Expr.Param> cTele, @NotNull WithPos<Expr> result) {
        ImmutableSeq locals = cTele.view().map(Expr.Param::ref).toImmutableSeq();
        ImmutableSeq<WithPos<Param>> checkedParam = this.checkTele(cTele);
        Term checkedResult = this.checkType(result).bindTele(locals.view());
        return new Signature(checkedParam, checkedResult);
    }

    @NotNull
    default public ImmutableSeq<WithPos<Param>> checkTele(@NotNull ImmutableSeq<Expr.Param> cTele) {
        MutableSeq<Param> tele = this.checkTeleFree(cTele);
        ImmutableSeq locals = cTele.view().map(Expr.Param::ref).toImmutableSeq();
        TeleTycker.bindTele((ImmutableSeq<LocalVar>)locals, tele);
        return tele.zip(cTele, (param, sp) -> new WithPos(sp.sourcePos(), param)).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public MutableSeq<Param> checkTeleFree(ImmutableSeq<Expr.Param> cTele) {
        return MutableSeq.from((Iterable)cTele.view().map(p -> {
            Term pTy = this.checkType((WithPos<Expr>)p.typeExpr());
            this.localCtx().put((Object)p.ref(), (Object)pTy);
            return new Param(p.ref().name(), pTy, p.explicit());
        }));
    }

    @Contract(mutates="param2")
    public static void bindTele(ImmutableSeq<LocalVar> binds, MutableSeq<Param> tele) {
        int lastIndex = tele.size() - 1;
        for (int i = lastIndex - 1; i >= 0; --i) {
            LocalVar p = (LocalVar)binds.get(i);
            for (int j = i + 1; j < tele.size(); ++j) {
                Param og = (Param)tele.get(j);
                int ii = i;
                int jj = j;
                tele.set(j, (Object)og.descent(x -> x.bindAt(p, jj - ii - 1)));
            }
        }
    }

    @Contract(mutates="param3")
    public static void loadTele(@NotNull SeqView<LocalVar> binds, @NotNull Signature signature, @NotNull ExprTycker tycker) {
        if (!1.$assertionsDisabled && !binds.sizeEquals((Iterable)signature.param())) {
            throw new AssertionError();
        }
        MutableList tele = MutableList.create();
        binds.forEachWith((Iterable)signature.param(), (ref, param) -> {
            tycker.localCtx().put(ref, (Object)((Param)param.data()).type().instantiateTeleVar(tele.view()));
            tele.append(ref);
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record Con(@NotNull ExprTycker tycker, @NotNull SortTerm dataResult) implements Impl
    {
        @Override
        @NotNull
        public Term checkType(@NotNull WithPos<Expr> typeExpr) {
            Term result = this.tycker.ty(typeExpr);
            if (!new Synthesizer(this.tycker).inheritPiDom(result, this.dataResult)) {
                this.tycker.fail(new UnifyError.PiDom((Expr)typeExpr.data(), typeExpr.sourcePos(), result, this.dataResult));
            }
            return result;
        }
    }

    public record Default(@NotNull ExprTycker tycker) implements Impl
    {
        @Override
        @NotNull
        public Term checkType(@NotNull WithPos<Expr> typeExpr) {
            return this.tycker.ty(typeExpr);
        }
    }

    public static sealed interface Impl
    extends TeleTycker
    permits Default, Con {
        @NotNull
        public ExprTycker tycker();

        @Override
        @NotNull
        default public LocalCtx localCtx() {
            return this.tycker().localCtx();
        }

        @Override
        @NotNull
        default public LocalCtx setLocalCtx(@NotNull LocalCtx ctx) {
            return this.tycker().setLocalCtx(ctx);
        }
    }
}

