/*
 * Decompiled with CFR 0.152.
 */
package org.aya.unify;

import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import org.aya.prettier.FindUsage;
import org.aya.syntax.core.term.FreeTerm;
import org.aya.syntax.core.term.LamTerm;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.MetaCall;
import org.aya.syntax.ref.LocalCtx;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.ref.MetaVar;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.HoleProblem;
import org.aya.unify.TermComparator;
import org.aya.util.Ordering;
import org.aya.util.error.SourcePos;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public final class Unifier
extends TermComparator {
    private final boolean allowDelay;
    public boolean allowVague = false;

    public Unifier(@NotNull TyckState state, @NotNull LocalCtx ctx, @NotNull Reporter reporter, @NotNull SourcePos pos, @NotNull Ordering cmp, boolean allowDelay) {
        super(state, ctx, reporter, pos, cmp);
        this.allowDelay = allowDelay;
    }

    @NotNull
    public TyckState.Eqn createEqn(@NotNull Term lhs, @NotNull Term rhs) {
        return new TyckState.Eqn(lhs, rhs, this.cmp, this.pos, this.localCtx().clone());
    }

    @NotNull
    public Unifier derive(@NotNull SourcePos pos, Ordering ordering) {
        return new Unifier(this.state, this.localCtx().derive(), this.reporter, pos, ordering, this.allowDelay);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected Term doSolveMeta(@NotNull MetaCall meta, @NotNull Term rhs, @Nullable Term type) {
        ImmutableSeq spine = meta.args();
        MutableArrayList inverted = MutableArrayList.create((int)spine.size());
        MutableList overlap = MutableList.create();
        for (Term arg : spine) {
            LocalVar var2;
            Term term = this.whnf(arg);
            if (!(term instanceof FreeTerm)) {
                this.reportBadSpine(meta);
                return null;
            }
            FreeTerm freeTerm = (FreeTerm)term;
            try {
                LocalVar localVar;
                var2 = localVar = freeTerm.name();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (inverted.contains((Object)var2)) {
                overlap.append((Object)var2);
            }
            inverted.append((Object)var2);
        }
        Term returnType = this.computeReturnType(meta, rhs, type);
        if (returnType == null) {
            return null;
        }
        if (!this.allowVague && overlap.anyMatch(var -> FindUsage.free((Term)rhs, (LocalVar)var) > 0)) {
            if (this.allowDelay) {
                this.state.addEqn(this.createEqn((Term)meta, rhs));
                return returnType;
            }
            this.reportBadSpine(meta);
            return null;
        }
        Term candidate = rhs.bindTele(inverted.view());
        FindUsage.Accumulator findUsage = FindUsage.anyFree((Term)candidate);
        if (findUsage.termUsage > 0) {
            this.fail(new HoleProblem.BadlyScopedError(meta, rhs, (Seq<LocalVar>)inverted));
            return null;
        }
        if (findUsage.metaUsage > 0) {
            if (this.allowDelay) {
                this.state.addEqn(this.createEqn((Term)meta, rhs));
                return returnType;
            }
            this.fail(new HoleProblem.BadlyScopedError(meta, rhs, (Seq<LocalVar>)inverted));
            return null;
        }
        MetaVar ref = meta.ref();
        if (FindUsage.meta((Term)candidate, (MetaVar)ref) > 0) {
            this.fail(new HoleProblem.RecursionError(meta, candidate));
            return null;
        }
        this.solve(ref, LamTerm.make((int)(spine.size() - ref.ctxSize()), (Term)candidate));
        return returnType;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private Term computeReturnType(@NotNull MetaCall meta, @NotNull Term rhs, @Nullable Term type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=3,365
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void reportBadSpine(@NotNull MetaCall meta) {
        this.fail(new HoleProblem.BadSpineError(meta));
    }

    private void reportIllTyped(@NotNull MetaCall meta, @NotNull Term rhs) {
        this.fail(new HoleProblem.IllTypedError(meta, this.state, rhs));
    }
}

