/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.resolve.context.BindContext;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public interface NameProblem
extends Problem {
    @NotNull
    default public Problem.Stage stage() {
        return Problem.Stage.RESOLVE;
    }

    public record OperatorNameNotFound(@NotNull SourcePos sourcePos, @NotNull String name) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown operator"), Doc.code((String)this.name), Doc.english((String)"used in bind statement")});
        }
    }

    public record UnqualifiedNameNotFoundError(@NotNull Context context, @NotNull String name, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc head = Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((String)this.name), Doc.english((String)"is not defined in the current scope")});
            ImmutableSeq<String> possible = this.didYouMean();
            if (possible.isEmpty()) {
                return head;
            }
            Doc tail = possible.sizeEquals(1) ? Doc.sep((Doc[])new Doc[]{Doc.english((String)"Did you mean:"), Doc.code((String)((String)possible.getFirst()))}) : Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Did you mean:"), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)possible.view().map(Doc::code)))});
            return Doc.vcat((Doc[])new Doc[]{head, tail});
        }

        @NotNull
        public ImmutableSeq<String> didYouMean() {
            Context ctx = this.context;
            while (ctx instanceof BindContext) {
                BindContext bindCtx = (BindContext)ctx;
                ctx = bindCtx.parent();
            }
            MutableList possible = MutableList.create();
            if (ctx instanceof ModuleContext) {
                ModuleContext moduleContext = (ModuleContext)ctx;
                moduleContext.modules().forEach((modName, mod) -> {
                    if (mod.symbols().contains(this.name)) {
                        possible.append((Object)modName.resolve(this.name).toString());
                    }
                });
            }
            return possible.toImmutableSeq();
        }
    }

    public record QualifiedNameNotFoundError(@NotNull ModuleName modName, @NotNull String name, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The qualified name"), Doc.code((String)this.modName.resolve(this.name).toString()), Doc.english((String)"is not defined in the current scope")});
        }
    }

    public record ShadowingWarn(@NotNull String name, @NotNull SourcePos sourcePos) implements Warn
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((String)this.name), Doc.english((String)"shadows a previous local definition from outer scope")});
        }
    }

    public record ModShadowingWarn(@NotNull ModuleName modName, @NotNull SourcePos sourcePos) implements Warn
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((String)this.modName.toString()), Doc.english((String)"shadows a previous definition from outer scope")});
        }
    }

    public record ModNotFoundError(@NotNull ModulePath path, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((String)this.path.toString()), Doc.english((String)"is not found")});
        }
    }

    public record ModNameNotFoundError(@NotNull ModuleName modName, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((String)this.modName.toString()), Doc.english((String)"is not defined in the current scope")});
        }
    }

    public record DuplicateNameError(@NotNull String name, @NotNull AnyVar ref, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.plain((String)this.name), Doc.parened((Doc)Doc.code((Doc)BasePrettier.varDoc((AnyVar)this.ref))), Doc.english((String)"is already defined elsewhere")});
        }
    }

    public record ClashModNameError(@NotNull ModulePath modulePath, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The inner module"), Doc.code((String)this.modulePath.toString()), Doc.english((String)"clashes with a file level module"), Doc.code((String)(this.modulePath.module().joinToString((CharSequence)"/") + ".aya"))});
        }
    }

    public record DuplicateModNameError(@NotNull ModuleName modName, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The module name"), Doc.code((String)this.modName.toString()), Doc.english((String)"is already defined elsewhere")});
        }
    }

    public record DuplicateExportError(@NotNull String name, @NotNull SourcePos sourcePos) implements NameProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((String)this.name), Doc.english((String)"being exported clashes with another exported definition with the same name")});
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record AmbiguousNameWarn(@NotNull String name, @NotNull SourcePos sourcePos) implements Warn
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"The name"), Doc.code((String)this.name), Doc.english((String)"introduces ambiguity and can only be accessed through a qualified name")})});
        }
    }

    public record AmbiguousNameError(@NotNull String name, @NotNull ImmutableSeq<ModuleName> disambiguation, @NotNull SourcePos sourcePos) implements Error
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.sep((Doc[])new Doc[]{Doc.english((String)"The unqualified name"), Doc.code((String)this.name), Doc.english((String)"is ambiguous")}), Doc.english((String)"Did you mean:"), Doc.nest((int)2, (Doc)Doc.vcat((SeqLike)this.didYouMean().map(Doc::code)))});
        }

        @NotNull
        public ImmutableSeq<String> didYouMean() {
            return this.disambiguation.view().map(mod -> mod.resolve(this.name).toString()).toImmutableSeq();
        }
    }

    public static interface Warn
    extends NameProblem {
        @NotNull
        default public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public static interface Error
    extends NameProblem {
        @NotNull
        default public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }
}

