/*
 * Decompiled with CFR 0.152.
 */
package org.aya.terck;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.SeqView;
import kala.collection.Set;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.ImmutableSet;
import kala.collection.mutable.MutableList;
import kala.value.MutableValue;
import org.aya.normalize.Normalizer;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.def.ConDefLike;
import org.aya.syntax.core.def.FnDef;
import org.aya.syntax.core.def.TyckAnyDef;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.core.pat.Pat;
import org.aya.syntax.core.term.AppTerm;
import org.aya.syntax.core.term.FreeTerm;
import org.aya.syntax.core.term.ProjTerm;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.Callable;
import org.aya.syntax.core.term.call.ConCall;
import org.aya.syntax.core.term.call.ConCallLike;
import org.aya.syntax.core.term.repr.IntegerTerm;
import org.aya.syntax.core.term.xtt.PAppTerm;
import org.aya.syntax.ref.LocalVar;
import org.aya.tyck.TyckState;
import org.aya.tyck.tycker.Stateful;
import org.aya.util.terck.CallGraph;
import org.aya.util.terck.CallMatrix;
import org.aya.util.terck.Relation;
import org.jetbrains.annotations.NotNull;

public record CallResolver(@NotNull TyckState state, @NotNull FnDef caller, @NotNull Set<TyckDef> targets, @NotNull MutableValue<Term.Matching> currentClause, @NotNull CallGraph<Callable.Tele, TyckDef> graph) implements Stateful,
Consumer<Term.Matching>
{
    public CallResolver(@NotNull TyckState state, @NotNull FnDef caller, @NotNull Set<TyckDef> targets, @NotNull MutableValue<Term.Matching> currentClause, @NotNull CallGraph<Callable.Tele, TyckDef> graph) {
        assert (caller.body().isRight());
    }

    public CallResolver(@NotNull TyckState state, @NotNull FnDef fn, @NotNull Set<TyckDef> targets, @NotNull CallGraph<Callable.Tele, TyckDef> graph) {
        this(state, fn, targets, (MutableValue<Term.Matching>)MutableValue.create(), graph);
    }

    private void resolveCall(@NotNull Callable.Tele callable) {
        AnyDef anyDef = callable.ref();
        if (!(anyDef instanceof TyckAnyDef)) {
            return;
        }
        TyckAnyDef calleeDef = (TyckAnyDef)anyDef;
        TyckDef callee = calleeDef.core();
        if (!this.targets.contains((Object)callee)) {
            return;
        }
        CallMatrix matrix = new CallMatrix((Object)callable, (Object)this.caller, (Object)callee, this.caller.telescope().size(), callee.telescope().size());
        this.fillMatrix((Callable)callable, matrix);
        this.graph.put(matrix);
    }

    private void fillMatrix(@NotNull Callable callable, CallMatrix<?, TyckDef> matrix) {
        Term.Matching currentPatterns = (Term.Matching)this.currentClause.get();
        assert (currentPatterns != null);
        currentPatterns.patterns().forEachIndexed((domParamIx, pat) -> callable.args().forEachIndexed((codParamIx, term) -> {
            Relation relation = this.compare((Term)term, (Pat)pat);
            matrix.set(domParamIx, codParamIx, relation);
        }));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Relation compare(@NotNull Term term, @NotNull Pat pat) {
        Relation relation;
        Pat pat2 = pat;
        Objects.requireNonNull(pat2);
        Pat pat3 = pat2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pat.Con.class, Pat.Bind.class, Pat.ShapedInt.class}, (Object)pat3, n)) {
            case 0: {
                Relation attempt;
                Pat.Con con = (Pat.Con)pat3;
                if (term instanceof ConCallLike) {
                    ConCallLike con2 = (ConCallLike)term;
                    ConDefLike ref = con2.ref();
                    ImmutableSeq conArgs = con2.conArgs();
                    if (!ref.equals((Object)con.ref()) || !conArgs.sizeEquals((Iterable)con.args())) {
                        relation = Relation.unk();
                        return relation;
                    }
                    Relation attempt2 = this.compareConArgs((ImmutableSeq<Term>)conArgs, con);
                    if (attempt2 == Relation.unk()) {
                        attempt2 = this.compareConArgs((ImmutableSeq<Term>)conArgs.map(a -> a.descent(this::whnf)), con);
                    }
                    relation = attempt2;
                    return relation;
                }
                SeqView subCompare = con.args().view().map(sub -> this.compare(term, (Pat)sub));
                Relation relation2 = attempt = subCompare.anyMatch(r -> r != Relation.unk()) ? Relation.lt() : Relation.unk();
                if (attempt != Relation.unk()) {
                    relation = attempt;
                    return relation;
                }
                Term term2 = this.whnf(term);
                Objects.requireNonNull(term2);
                Term term3 = term2;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConCallLike.class, PAppTerm.class}, (Object)term3, n2)) {
                    case 0: {
                        ConCallLike con2 = (ConCallLike)term3;
                        relation = this.compare((Term)con2, (Pat)con);
                        return relation;
                    }
                    case 1: {
                        PAppTerm papp = (PAppTerm)term3;
                        Term head = papp.fun();
                        while (true) {
                            if (!(head instanceof PAppTerm)) {
                                relation = this.compare(head, (Pat)con);
                                return relation;
                            }
                            PAppTerm papp2 = (PAppTerm)head;
                            head = papp2.fun();
                        }
                    }
                }
                relation = attempt;
                return relation;
            }
            case 1: {
                Pat.Bind bind = (Pat.Bind)pat3;
                if (term instanceof FreeTerm) {
                    LocalVar ref;
                    FreeTerm attempt = (FreeTerm)term;
                    try {
                        LocalVar papp;
                        ref = papp = attempt.name();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (ref == bind.bind()) {
                        relation = Relation.eq();
                        return relation;
                    }
                    relation = Relation.unk();
                    return relation;
                }
                Term papp = this.headOf(term);
                if (!(papp instanceof FreeTerm)) {
                    relation = Relation.unk();
                    return relation;
                }
                FreeTerm attempt = (FreeTerm)papp;
                LocalVar localVar = attempt.name();
                LocalVar ref = localVar;
                if (ref == bind.bind()) {
                    relation = Relation.lt();
                    return relation;
                }
                relation = Relation.unk();
                return relation;
            }
            case 2: {
                Pat.ShapedInt intPat = (Pat.ShapedInt)pat3;
                Term term3 = term;
                Objects.requireNonNull(term3);
                Term term5 = term3;
                int n3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegerTerm.class, ConCall.class}, (Object)term5, n3)) {
                    case 0: {
                        IntegerTerm intTerm = (IntegerTerm)term5;
                        relation = Relation.fromCompare((int)Integer.compare(intTerm.repr(), intPat.repr()));
                        return relation;
                    }
                    case 1: {
                        ConCall con = (ConCall)term5;
                        relation = this.compare((Term)con, (Pat)intPat.constructorForm());
                        return relation;
                    }
                }
                relation = this.compare(term, (Pat)intPat.constructorForm());
                return relation;
            }
        }
        relation = Relation.unk();
        return relation;
    }

    private Relation compareConArgs(@NotNull ImmutableSeq<Term> conArgs, @NotNull Pat.Con con) {
        ImmutableSeq subCompare = conArgs.zip((Iterable)con.args(), this::compare);
        return (Relation)subCompare.foldLeft((Object)Relation.eq(), Relation::mul);
    }

    @NotNull
    private Term headOf(@NotNull Term term) {
        Term term2 = term;
        Objects.requireNonNull(term2);
        Term term3 = term2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AppTerm.class, PAppTerm.class, ProjTerm.class}, (Object)term3, n)) {
            case 0 -> {
                AppTerm app = (AppTerm)term3;
                yield this.headOf(app.fun());
            }
            case 1 -> {
                PAppTerm papp = (PAppTerm)term3;
                yield this.headOf(papp.fun());
            }
            case 2 -> {
                ProjTerm proj = (ProjTerm)term3;
                yield this.headOf(proj.of());
            }
            default -> term;
        };
    }

    public void check() {
        ImmutableSeq clauses = (ImmutableSeq)this.caller.body().getRightValue();
        clauses.forEach((Consumer)this);
    }

    @Override
    public void accept(@NotNull Term.Matching matching) {
        this.currentClause.set((Object)matching);
        MutableList vars = (MutableList)Pat.collectVariables((SeqView)matching.patterns().view()).component1();
        this.visitTerm(matching.body().instantiateTeleVar(vars.view()));
        this.currentClause.set(null);
    }

    private void visitTerm(@NotNull Term term) {
        Normalizer normalizer = new Normalizer(this.state);
        normalizer.opaque = ImmutableSet.from((Iterable)this.targets.map(TyckDef::ref));
        if ((term = normalizer.apply(term)) instanceof Callable.Tele) {
            Callable.Tele call = (Callable.Tele)term;
            this.resolveCall(call);
        }
        term.descent((n, child) -> {
            this.visitTerm((Term)child);
            return child;
        });
    }
}

