/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.generic.AyaDocile;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.core.term.Term;
import org.aya.tyck.TyckState;
import org.aya.tyck.error.SourceNodeProblem;
import org.aya.tyck.error.TyckError;
import org.aya.tyck.error.UnifyInfo;
import org.aya.tyck.tycker.Stateful;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public final class BadTypeError
extends Record
implements TyckError,
Stateful,
SourceNodeProblem {
    @NotNull
    private final WithPos<Expr> expr;
    @NotNull
    private final Term actualType;
    @NotNull
    private final Doc action;
    @NotNull
    private final Doc thing;
    @NotNull
    private final AyaDocile desired;
    @NotNull
    private final TyckState state;

    public BadTypeError(@NotNull WithPos<Expr> expr, @NotNull Term actualType, @NotNull Doc action, @NotNull Doc thing, @NotNull AyaDocile desired, @NotNull TyckState state) {
        this.expr = expr;
        this.actualType = actualType;
        this.action = action;
        this.thing = thing;
        this.desired = desired;
        this.state = state;
    }

    @NotNull
    public Doc describe(@NotNull PrettierOptions options) {
        MutableList list = MutableList.of((Object)Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unable to"), this.action, Doc.english((String)"the expression")}), (Object)Doc.par((int)1, (Doc)((Expr)this.expr.data()).toDoc(options)), (Object)Doc.sep((Doc[])new Doc[]{Doc.english((String)"because the type"), this.thing, Doc.english((String)"is not a"), Doc.cat((Doc[])new Doc[]{this.desired.toDoc(options), Doc.plain((String)",")}), Doc.english((String)"but instead:")}));
        UnifyInfo.exprInfo(this.actualType, options, this, (MutableList<Doc>)list);
        return Doc.vcat((SeqLike)list);
    }

    @NotNull
    public Doc hint(@NotNull PrettierOptions options) {
        return Doc.empty();
    }

    @NotNull
    public static BadTypeError appOnNonPi(@NotNull TyckState state, @NotNull WithPos<Expr> expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.plain((String)"apply"), Doc.english((String)"of what you applied"), prettierOptions -> Doc.english((String)"Pi/Path type"), state);
    }

    @NotNull
    public static BadTypeError absOnNonPi(@NotNull TyckState state, @NotNull WithPos<Expr> expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.plain((String)"accept"), Doc.english((String)"we expect"), prettierOptions -> Doc.english((String)"Pi/Path type"), state);
    }

    @NotNull
    public static BadTypeError sigmaAcc(@NotNull TyckState state, @NotNull WithPos<Expr> expr, int ix, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.english((String)"project the"), Doc.ordinal((int)ix), Doc.english((String)"element of")}), Doc.english((String)"of what you projected on"), prettierOptions -> Doc.english((String)"Sigma type"), state);
    }

    @NotNull
    public static BadTypeError sigmaCon(@NotNull TyckState state, @NotNull WithPos<Expr> expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.plain((String)"construct")}), Doc.english((String)"you checked it against"), prettierOptions -> Doc.english((String)"Sigma type"), state);
    }

    @NotNull
    public static BadTypeError structAcc(@NotNull TyckState state, @NotNull WithPos<Expr> expr, @NotNull String fieldName, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.english((String)"access field"), Doc.code((String)fieldName), Doc.plain((String)"of")}), Doc.english((String)"of what you accessed"), prettierOptions -> Doc.english((String)"struct type"), state);
    }

    @NotNull
    public static BadTypeError structCon(@NotNull TyckState state, @NotNull WithPos<Expr> expr, @NotNull Term actualType) {
        return new BadTypeError(expr, actualType, Doc.sep((Doc[])new Doc[]{Doc.plain((String)"construct")}), Doc.english((String)"you gave"), prettierOptions -> Doc.english((String)"struct type"), state);
    }

    @NotNull
    public static BadTypeError doNotLike(@NotNull TyckState state, @NotNull WithPos<Expr> expr, @NotNull Term actual, @NotNull AyaDocile need) {
        return new BadTypeError(expr, actual, Doc.plain((String)"accept"), Doc.plain((String)"provided"), need, state);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BadTypeError.class, "expr;actualType;action;thing;desired;state", "expr", "actualType", "action", "thing", "desired", "state"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BadTypeError.class, "expr;actualType;action;thing;desired;state", "expr", "actualType", "action", "thing", "desired", "state"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BadTypeError.class, "expr;actualType;action;thing;desired;state", "expr", "actualType", "action", "thing", "desired", "state"}, this, o);
    }

    @NotNull
    public WithPos<Expr> expr() {
        return this.expr;
    }

    @NotNull
    public Term actualType() {
        return this.actualType;
    }

    @NotNull
    public Doc action() {
        return this.action;
    }

    @NotNull
    public Doc thing() {
        return this.thing;
    }

    @NotNull
    public AyaDocile desired() {
        return this.desired;
    }

    @Override
    @NotNull
    public TyckState state() {
        return this.state;
    }
}

