/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.UnaryOperator;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.mutable.MutableList;
import kala.value.MutableValue;
import kala.value.primitive.MutableBooleanValue;
import org.aya.generic.AyaDocile;
import org.aya.generic.Renamer;
import org.aya.prettier.AyaPrettierOptions;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.core.pat.Pat;
import org.aya.syntax.core.term.ErrorTerm;
import org.aya.syntax.core.term.MetaPatTerm;
import org.aya.syntax.core.term.Param;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.ref.LocalCtx;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.telescope.Signature;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.Jdg;
import org.aya.tyck.TyckState;
import org.aya.tyck.ctx.LocalLet;
import org.aya.tyck.error.PatternProblem;
import org.aya.tyck.pat.PatClassifier;
import org.aya.tyck.pat.PatternTycker;
import org.aya.tyck.tycker.Problematic;
import org.aya.tyck.tycker.Stateful;
import org.aya.util.Arg;
import org.aya.util.Pair;
import org.aya.util.error.Panic;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.aya.util.prettier.PrettierOptions;
import org.aya.util.reporter.Reporter;
import org.aya.util.tyck.pat.PatClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ClauseTycker(@NotNull ExprTycker exprTycker) implements Problematic,
Stateful
{
    @NotNull
    public ImmutableSeq<LhsResult> checkAllLhs(@Nullable ImmutableIntSeq indices, @NotNull Signature signature, @NotNull SeqView<Pattern.Clause> clauses, boolean isFn) {
        return clauses.map(c -> this.checkLhs(signature, indices, (Pattern.Clause)c, isFn)).toImmutableSeq();
    }

    @NotNull
    public TyckResult checkAllRhs(@NotNull ImmutableSeq<LocalVar> vars, @NotNull ImmutableSeq<LhsResult> lhsResults) {
        boolean lhsError = lhsResults.anyMatch(LhsResult::hasError);
        ImmutableSeq rhsResult = lhsResults.map(x -> this.checkRhs(vars, (LhsResult)x));
        this.exprTycker.solveMetas();
        rhsResult = rhsResult.map(preclause -> new Pat.Preclause(preclause.sourcePos(), preclause.pats().map(p -> p.descent(UnaryOperator.identity(), this.exprTycker::zonk)), preclause.bindCount(), preclause.expr() == null ? null : preclause.expr().descent((sourcePos, t) -> this.exprTycker.zonk((Term)t))));
        return new TyckResult((ImmutableSeq<Pat.Preclause<Term>>)rhsResult, (ImmutableSeq<Term.Matching>)rhsResult.flatMap(Pat.Preclause::lift), lhsError);
    }

    @Override
    @NotNull
    public Reporter reporter() {
        return this.exprTycker.reporter;
    }

    @Override
    @NotNull
    public TyckState state() {
        return this.exprTycker.state;
    }

    @NotNull
    private PatternTycker newPatternTycker(@Nullable ImmutableIntSeq indices, @NotNull SeqView<Param> telescope) {
        telescope = indices != null ? telescope.mapIndexed((idx, p) -> indices.contains(idx) ? p.explicitize() : p.implicitize()) : telescope;
        return new PatternTycker(this.exprTycker, (SeqView<Param>)telescope, new LocalLet(), indices == null, new Renamer());
    }

    @NotNull
    public LhsResult checkLhs(@NotNull Signature signature, @Nullable ImmutableIntSeq indices, @NotNull Pattern.Clause clause, boolean isFn) {
        PatternTycker tycker = this.newPatternTycker(indices, (SeqView<Param>)signature.rawParams().view());
        return this.exprTycker.subscoped(() -> {
            if (isFn && !clause.patterns.anyMatch(p -> ClauseTycker.hasAbsurdity((Pattern)((WithPos)p.term()).data())) && clause.expr.isEmpty()) {
                clause.hasError = true;
                this.exprTycker.fail(new PatternProblem.InvalidEmptyBody(clause));
            }
            PatternTycker.TyckResult patResult = tycker.tyck((SeqView<Arg<WithPos<Pattern>>>)clause.patterns.view(), null, (WithPos<Expr>)((WithPos)clause.expr.getOrNull()));
            LocalCtx ctx = this.exprTycker.localCtx();
            clause.hasError |= patResult.hasError();
            patResult = ClauseTycker.inline(patResult, ctx);
            Term resultTerm = TermInline.apply(signature.result().instantiateTele(patResult.paramSubstObj()));
            clause.patterns.view().map(it -> (Pattern)((WithPos)it.term()).data()).forEach(TermInPatInline::apply);
            ctx = ctx.map(TermInline::apply);
            Pair patWithTypeBound = Pat.collectVariables((SeqView)patResult.wellTyped().view());
            ImmutableSeq allBinds = ((MutableList)patWithTypeBound.component1()).toImmutableSeq();
            Pat.Preclause newClause = new Pat.Preclause(clause.sourcePos, (ImmutableSeq)patWithTypeBound.component2(), allBinds.size(), patResult.newBody());
            return new LhsResult(ctx, resultTerm, (ImmutableSeq<LocalVar>)allBinds, patResult.wellTyped(), patResult.paramSubst(), patResult.asSubst(), (Pat.Preclause<Expr>)newClause, patResult.hasError());
        });
    }

    @NotNull
    private Pat.Preclause<Term> checkRhs(@NotNull ImmutableSeq<LocalVar> teleBinds, @NotNull LhsResult result) {
        return this.exprTycker.subscoped(() -> {
            ErrorTerm wellBody;
            Pat.Preclause<Expr> clause = result.clause;
            WithPos bodyExpr = clause.expr();
            int bindCount = 0;
            if (bodyExpr == null) {
                wellBody = null;
            } else if (result.hasError) {
                wellBody = new ErrorTerm((AyaDocile)result.clause.expr().data());
            } else {
                this.exprTycker.setLocalCtx(result.localCtx);
                result.addLocalLet(teleBinds, this.exprTycker);
                wellBody = this.exprTycker.inherit((WithPos<Expr>)bodyExpr, result.type).wellTyped();
                MutableList patBindTele = (MutableList)Pat.collectVariables((SeqView)result.clause.pats().view()).component1();
                bindCount = patBindTele.size();
                wellBody = wellBody.bindTele(patBindTele.view());
            }
            return new Pat.Preclause(clause.sourcePos(), clause.pats(), bindCount, wellBody == null ? null : WithPos.dummy((Object)wellBody));
        });
    }

    private static boolean hasAbsurdity(@NotNull Pattern term) {
        return ClauseTycker.hasAbsurdity(term, MutableBooleanValue.create());
    }

    private static boolean hasAbsurdity(@NotNull Pattern term, @NotNull MutableBooleanValue b) {
        if (term == Pattern.Absurd.INSTANCE) {
            b.set(true);
        } else {
            term.forEach((sourcePos, p) -> b.set(b.get() || ClauseTycker.hasAbsurdity(p, b)));
        }
        return b.get();
    }

    @NotNull
    private static Jdg inlineTerm(@NotNull Jdg r) {
        return r.map(TermInline::apply);
    }

    @NotNull
    private static PatternTycker.TyckResult inline(@NotNull PatternTycker.TyckResult result, @NotNull LocalCtx ctx) {
        ImmutableSeq wellTyped = result.wellTyped().map(x -> TermInline.apply(x.inline((arg_0, arg_1) -> ((LocalCtx)ctx).put(arg_0, arg_1))));
        ImmutableSeq paramSubst = result.paramSubst().map(ClauseTycker::inlineTerm);
        result.asSubst().subst().replaceAll((localVar, t) -> ClauseTycker.inlineTerm(t));
        return new PatternTycker.TyckResult((ImmutableSeq<Pat>)wellTyped, (ImmutableSeq<Jdg>)paramSubst, result.asSubst(), result.newBody(), result.hasError());
    }

    public record TyckResult(@NotNull ImmutableSeq<Pat.Preclause<Term>> clauses, @NotNull ImmutableSeq<Term.Matching> wellTyped, boolean hasLhsError) {
    }

    public record LhsResult(@NotNull LocalCtx localCtx, @NotNull Term type, @NotNull ImmutableSeq<LocalVar> allBinds, @NotNull ImmutableSeq<Pat> freePats, @NotNull ImmutableSeq<Jdg> paramSubst, @NotNull LocalLet asSubst, @NotNull Pat.Preclause<Expr> clause, boolean hasError) {
        @Contract(mutates="param2")
        public void addLocalLet(@NotNull ImmutableSeq<LocalVar> teleBinds, @NotNull ExprTycker exprTycker) {
            teleBinds.forEachWith(this.paramSubst, (arg_0, arg_1) -> ((LocalLet)exprTycker.localLet()).put(arg_0, arg_1));
            exprTycker.setLocalLet(new LocalLet(exprTycker.localLet(), this.asSubst.subst()));
        }
    }

    private static final class TermInline {
        private TermInline() {
        }

        @NotNull
        public static Term apply(@NotNull Term term) {
            if (term instanceof MetaPatTerm) {
                MetaPatTerm metaPat = (MetaPatTerm)term;
                boolean isEmpty = metaPat.meta().solution().isEmpty();
                if (isEmpty) {
                    throw new Panic("Unable to inline " + String.valueOf(metaPat.toDoc((PrettierOptions)AyaPrettierOptions.debug())));
                }
                return metaPat.inline(TermInline::apply);
            }
            return term.descent(TermInline::apply);
        }

        @NotNull
        public static Pat apply(@NotNull Pat pat) {
            return pat.descent(TermInline::apply, TermInline::apply);
        }
    }

    private static final class TermInPatInline {
        private TermInPatInline() {
        }

        public static void apply(@NotNull Pattern pat) {
            MutableValue typeRef;
            Pattern pattern = pat;
            Objects.requireNonNull(pattern);
            Pattern pattern2 = pattern;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Bind.class, Pattern.As.class}, (Object)pattern2, n)) {
                case 0: {
                    Pattern.Bind bind = (Pattern.Bind)pattern2;
                    MutableValue mutableValue = bind.type();
                    break;
                }
                case 1: {
                    Pattern.As as = (Pattern.As)pattern2;
                    MutableValue mutableValue = as.type();
                    break;
                }
                default: {
                    MutableValue mutableValue = typeRef = null;
                }
            }
            if (typeRef != null) {
                typeRef.update(it -> it == null ? null : TermInline.apply(it));
            }
            pat.forEach((sourcePos, p) -> TermInPatInline.apply(p));
        }
    }

    public record Worker(@NotNull ClauseTycker parent, @NotNull ImmutableSeq<LocalVar> vars, @NotNull Signature signature, @NotNull ImmutableSeq<Pattern.Clause> clauses, @NotNull ImmutableSeq<LocalVar> elims, boolean isFn) {
        @NotNull
        public TyckResult check(@NotNull SourcePos overallPos) {
            ImmutableSeq<LhsResult> lhsResult = this.parent.checkAllLhs(this.computeIndices(), this.signature, (SeqView<Pattern.Clause>)this.clauses.view(), this.isFn);
            if (lhsResult.noneMatch(r -> r.hasError)) {
                ImmutableSeq<PatClass<ImmutableSeq<Term>>> classes = PatClassifier.classify(lhsResult.view().map(LhsResult::clause), (SeqView<Param>)this.signature.param().view().map(WithPos::data), this.parent.exprTycker, overallPos);
                if (this.clauses.isNotEmpty()) {
                    int[] nArray = PatClassifier.firstMatchDomination(this.clauses, this.parent.reporter(), classes);
                }
            }
            return this.parent.checkAllRhs(this.vars, lhsResult);
        }

        @Nullable
        private ImmutableIntSeq computeIndices() {
            return this.elims.isEmpty() ? null : (ImmutableIntSeq)this.elims.mapToInt(ImmutableIntSeq.factory(), arg_0 -> this.vars.indexOf(arg_0));
        }

        @NotNull
        public TyckResult checkNoClassify() {
            return this.parent.checkAllRhs(this.vars, this.parent.checkAllLhs(this.computeIndices(), this.signature, (SeqView<Pattern.Clause>)this.clauses.view(), this.isFn));
        }
    }
}

