/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableArray;
import kala.collection.immutable.ImmutableSeq;
import kala.function.CheckedBiFunction;
import org.aya.generic.stmt.Shaped;
import org.aya.syntax.compile.JitCon;
import org.aya.syntax.compile.JitData;
import org.aya.syntax.compile.JitFn;
import org.aya.syntax.compile.JitPrim;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.concrete.stmt.decl.DataDecl;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.concrete.stmt.decl.FnDecl;
import org.aya.syntax.concrete.stmt.decl.PrimDecl;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.def.ConDef;
import org.aya.syntax.core.def.ConDefLike;
import org.aya.syntax.core.def.DataDef;
import org.aya.syntax.core.def.DataDefLike;
import org.aya.syntax.core.def.FnDef;
import org.aya.syntax.core.def.FnDefLike;
import org.aya.syntax.core.def.PrimDef;
import org.aya.syntax.core.def.PrimDefLike;
import org.aya.syntax.core.repr.AyaShape;
import org.aya.syntax.core.repr.ShapeRecognition;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.ConCall;
import org.aya.syntax.core.term.call.DataCall;
import org.aya.syntax.core.term.call.FnCall;
import org.aya.syntax.core.term.call.PrimCall;
import org.aya.syntax.core.term.call.RuleReducer;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.telescope.AbstractTele;
import org.aya.tyck.Jdg;
import org.aya.tyck.TyckState;
import org.aya.util.error.Panic;
import org.jetbrains.annotations.NotNull;

public interface AppTycker {
    @NotNull
    public static <Ex extends Exception> Jdg checkCompiledApplication(@NotNull AbstractTele def, CheckAppData<Ex> input) throws Ex {
        AbstractTele abstractTele = def;
        Objects.requireNonNull(abstractTele);
        AbstractTele abstractTele2 = abstractTele;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitFn.class, JitData.class, JitPrim.class, JitCon.class}, (Object)abstractTele2, n)) {
            case 0 -> {
                JitFn fn = (JitFn)abstractTele2;
                int shape = fn.metadata().shape();
                Shaped.Applicable operator = shape != -1 ? AyaShape.ofFn((FnDefLike)fn, (AyaShape)AyaShape.values()[shape]) : null;
                yield AppTycker.checkFnCall(input.makeArgs, input.lift, (FnDefLike)fn, (Shaped.Applicable<FnDefLike>)operator);
            }
            case 1 -> {
                JitData data = (JitData)abstractTele2;
                yield AppTycker.checkDataCall(input.makeArgs, input.lift, (DataDefLike)data);
            }
            case 2 -> {
                JitPrim prim = (JitPrim)abstractTele2;
                yield AppTycker.checkPrimCall(input.state, input.makeArgs, input.lift, (PrimDefLike)prim);
            }
            case 3 -> {
                JitCon con = (JitCon)abstractTele2;
                yield AppTycker.checkConCall(input.state, input.makeArgs, input.lift, (ConDefLike)con);
            }
            default -> throw new Panic(def.getClass().getCanonicalName());
        };
    }

    @NotNull
    public static <Ex extends Exception> Jdg checkDefApplication(@NotNull DefVar<?, ?> defVar, @NotNull CheckAppData<Ex> input) throws Ex {
        Decl decl = defVar.concrete;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FnDecl.class, DataDecl.class, PrimDecl.class, DataCon.class}, (Object)decl2, n)) {
            case 0 -> {
                FnDef.Delegate fnDef = new FnDef.Delegate(defVar);
                Shaped.Applicable op = (Shaped.Applicable)input.state.shapeFactory().find((AnyDef)fnDef).map(recog -> AyaShape.ofFn((FnDefLike)fnDef, (AyaShape)recog.shape())).getOrNull();
                yield AppTycker.checkFnCall(input.makeArgs, input.lift, (FnDefLike)fnDef, (Shaped.Applicable<FnDefLike>)op);
            }
            case 1 -> AppTycker.checkDataCall(input.makeArgs, input.lift, (DataDefLike)new DataDef.Delegate(defVar));
            case 2 -> AppTycker.checkPrimCall(input.state, input.makeArgs, input.lift, (PrimDefLike)new PrimDef.Delegate(defVar));
            case 3 -> AppTycker.checkConCall(input.state, input.makeArgs, input.lift, (ConDefLike)new ConDef.Delegate(defVar));
            default -> (Jdg)Panic.unreachable();
        };
    }

    private static <Ex extends Exception> Jdg checkConCall(@NotNull TyckState state, @NotNull Factory<Ex> makeArgs, int lift, ConDefLike conVar) throws Ex {
        DataDefLike dataVar = conVar.dataRef();
        AbstractTele fullSignature = conVar.signature().lift(lift);
        return (Jdg)makeArgs.applyChecked(fullSignature, args -> {
            ImmutableArray realArgs = ImmutableArray.from((Object[])args);
            ImmutableSeq ownerArgs = realArgs.take(conVar.ownerTeleSize());
            ImmutableSeq conArgs = realArgs.drop(conVar.ownerTeleSize());
            DataCall type = (DataCall)fullSignature.result((Seq)realArgs);
            Shaped.Applicable shape = (Shaped.Applicable)state.shapeFactory().find((AnyDef)dataVar).mapNotNull(recog -> AyaShape.ofCon((ConDefLike)conVar, (ShapeRecognition)recog, (DataCall)type)).getOrNull();
            if (shape != null) {
                return new Jdg.Default((Term)new RuleReducer.Con(shape, 0, ownerArgs, conArgs), (Term)type);
            }
            ConCall wellTyped = new ConCall(conVar, ownerArgs, 0, conArgs);
            return new Jdg.Default((Term)wellTyped, (Term)type);
        });
    }

    private static <Ex extends Exception> Jdg checkPrimCall(@NotNull TyckState state, @NotNull Factory<Ex> makeArgs, int lift, PrimDefLike primVar) throws Ex {
        AbstractTele signature = primVar.signature().lift(lift);
        return (Jdg)makeArgs.applyChecked(signature, args -> new Jdg.Default(state.primFactory().unfold(new PrimCall(primVar, 0, (ImmutableSeq)ImmutableArray.from((Object[])args)), state), signature.result(args)));
    }

    private static <Ex extends Exception> Jdg checkDataCall(@NotNull Factory<Ex> makeArgs, int lift, DataDefLike data) throws Ex {
        AbstractTele signature = data.signature().lift(lift);
        return (Jdg)makeArgs.applyChecked(signature, args -> new Jdg.Default((Term)new DataCall(data, 0, (ImmutableSeq)ImmutableArray.from((Object[])args)), signature.result(args)));
    }

    @NotNull
    private static <Ex extends Exception> Jdg checkFnCall(@NotNull Factory<Ex> makeArgs, int lift, FnDefLike fnDef, Shaped.Applicable<FnDefLike> operator) throws Ex {
        AbstractTele signature = fnDef.signature().lift(lift);
        return (Jdg)makeArgs.applyChecked(signature, args -> {
            ImmutableArray argsSeq = ImmutableArray.from((Object[])args);
            Term result = signature.result(args);
            if (operator != null) {
                return new Jdg.Default((Term)new RuleReducer.Fn(operator, 0, (ImmutableSeq)argsSeq), result);
            }
            FnCall fnCall = new FnCall(fnDef, 0, (ImmutableSeq)argsSeq);
            return new Jdg.Default((Term)fnCall, result);
        });
    }

    public record CheckAppData<Ex extends Exception>(@NotNull TyckState state, int lift, @NotNull Factory<Ex> makeArgs) {
    }

    @FunctionalInterface
    public static interface Factory<Ex extends Exception>
    extends CheckedBiFunction<AbstractTele, Function<Term[], Jdg>, Jdg, Ex> {
    }
}

