/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.ResolvingStmt;
import org.aya.resolve.module.ModuleLoader;
import org.aya.resolve.salt.Desalt;
import org.aya.resolve.salt.DesugarMisc;
import org.aya.resolve.visitor.StmtBinder;
import org.aya.resolve.visitor.StmtPreResolver;
import org.aya.resolve.visitor.StmtResolver;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.util.binop.OpDecl;
import org.aya.util.position.PosedUnaryOperator;
import org.jetbrains.annotations.NotNull;

public record StmtResolvers(@NotNull ModuleLoader loader, @NotNull ResolveInfo info) {
    @NotNull
    private ImmutableSeq<ResolvingStmt> fillContext(@NotNull ImmutableSeq<Stmt> stmts) {
        return new StmtPreResolver(this.loader, this.info).resolveStmt(stmts, this.info.thisModule());
    }

    private void resolveStmts(@NotNull ImmutableSeq<ResolvingStmt> stmts) {
        StmtResolver.resolveStmt(stmts, this.info);
    }

    private void resolveBind(@NotNull ImmutableSeq<ResolvingStmt> stmts) {
        StmtBinder binder = new StmtBinder(this.info);
        binder.resolveBind((SeqLike<ResolvingStmt>)stmts);
        this.info.opRename().forEach((var, rename) -> binder.bind(rename.bindCtx(), rename.bind(), (OpDecl)var));
    }

    public void desugar(@NotNull ImmutableSeq<Stmt> stmts) {
        Desalt salt = new Desalt(this.info);
        stmts.forEach(stmt -> stmt.descentInPlace((PosedUnaryOperator)salt, (PosedUnaryOperator)new DesugarMisc.Pat(this.info)));
    }

    public void resolve(@NotNull ImmutableSeq<Stmt> stmts) {
        ImmutableSeq<ResolvingStmt> resolving = this.fillContext(stmts);
        this.resolveStmts(resolving);
        this.resolveBind(resolving);
        this.info.opSet().reportIfCyclic();
    }
}

