/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.generic.InterruptException;
import org.aya.resolve.context.BindContext;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.GenerateKind;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.tyck.tycker.Problematic;
import org.aya.util.position.SourcePos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Context
extends Problematic {
    @Nullable
    public Context parent();

    @Override
    @NotNull
    public Reporter reporter();

    @NotNull
    public Path underlyingFile();

    @Nullable
    default public <T> T iterate(@NotNull @NotNull Function<@NotNull Context, @Nullable T> f) {
        for (Context p = this; p != null; p = p.parent()) {
            T result = f.apply(p);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    default public ModulePath modulePath() {
        Context p = this.parent();
        if (!1.$assertionsDisabled && p == null) {
            throw new AssertionError();
        }
        return p.modulePath();
    }

    @Contract(value="_ -> fail")
    @NotNull
    default public <T> T reportAndThrow(@NotNull Problem problem) {
        this.fail(problem);
        throw new ResolvingInterruptedException();
    }

    @Contract(value="_ -> fail")
    @NotNull
    default public <T> T reportAllAndThrow(@NotNull SeqLike<Problem> problems) {
        this.reportAll(problems);
        throw new ResolvingInterruptedException();
    }

    default public void reportAll(@NotNull SeqLike<Problem> problems) {
        problems.forEach(this::fail);
    }

    @NotNull
    default public AnyVar get(@NotNull QualifiedID name) {
        ModuleName moduleName = name.component();
        Objects.requireNonNull(moduleName);
        ModuleName moduleName2 = moduleName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleName.ThisRef.class, ModuleName.Qualified.class}, (ModuleName)moduleName2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getUnqualified(name.name(), name.sourcePos());
            case 1 -> {
                ModuleName.Qualified qualified = (ModuleName.Qualified)moduleName2;
                yield this.getQualified(qualified, name.name(), name.sourcePos());
            }
        };
    }

    @Nullable
    default public AnyVar getMaybe(@NotNull QualifiedID name) {
        ModuleName moduleName = name.component();
        Objects.requireNonNull(moduleName);
        ModuleName moduleName2 = moduleName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleName.ThisRef.class, ModuleName.Qualified.class}, (ModuleName)moduleName2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getUnqualifiedMaybe(name.name(), name.sourcePos());
            case 1 -> {
                ModuleName.Qualified qualified = (ModuleName.Qualified)moduleName2;
                yield this.getQualifiedMaybe(qualified, name.name(), name.sourcePos());
            }
        };
    }

    default public MutableList<LocalVar> collect(@NotNull MutableList<LocalVar> container) {
        return container;
    }

    @Nullable
    public AnyVar getUnqualifiedLocalMaybe(@NotNull String var1, @NotNull SourcePos var2);

    @Nullable
    default public AnyVar getUnqualifiedMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        return this.iterate(c -> c.getUnqualifiedLocalMaybe(name, sourcePos));
    }

    @NotNull
    default public AnyVar getUnqualified(@NotNull String name, @NotNull SourcePos sourcePos) {
        AnyVar result = this.getUnqualifiedMaybe(name, sourcePos);
        if (result == null) {
            this.reportAndThrow(new NameProblem.UnqualifiedNameNotFoundError(this, name, sourcePos));
        }
        return result;
    }

    @Nullable
    public AnyVar getQualifiedLocalMaybe(@NotNull ModuleName.Qualified var1, @NotNull String var2, @NotNull SourcePos var3);

    @Nullable
    default public AnyVar getQualifiedMaybe(@NotNull ModuleName.Qualified modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        return this.iterate(c -> c.getQualifiedLocalMaybe(modName, name, sourcePos));
    }

    @NotNull
    default public AnyVar getQualified(@NotNull ModuleName.Qualified modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        AnyVar result = this.getQualifiedMaybe(modName, name, sourcePos);
        if (result == null) {
            this.reportAndThrow(new NameProblem.QualifiedNameNotFoundError((ModuleName)modName, name, sourcePos));
        }
        return result;
    }

    @Nullable
    public ModuleExport getModuleLocalMaybe(@NotNull ModuleName.Qualified var1);

    @Nullable
    default public ModuleExport getModuleMaybe(@NotNull ModuleName.Qualified modName) {
        return this.iterate(c -> c.getModuleLocalMaybe(modName));
    }

    @NotNull
    default public Context bind(@NotNull LocalVar ref, @NotNull Predicate<@Nullable AnyVar> toWarn) {
        return this.bind(ref.name(), ref, toWarn);
    }

    @NotNull
    default public Context bind(@NotNull LocalVar ref) {
        return this.bind(ref, var -> var instanceof LocalVar);
    }

    @NotNull
    default public Context bind(@NotNull String name, @NotNull LocalVar ref, @NotNull Predicate<@Nullable AnyVar> toWarn) {
        if (ref == LocalVar.IGNORED) {
            return this;
        }
        AnyVar exists = this.getUnqualifiedMaybe(name, ref.definition());
        if (toWarn.test(exists) && ref.generateKind() != GenerateKind.Basic.Anonymous) {
            this.fail(new NameProblem.ShadowingWarn(name, ref.definition()));
        }
        return new BindContext(this, name, ref);
    }

    @ApiStatus.NonExtendable
    @NotNull
    default public PhysicalModuleContext derive(@NotNull String extraName) {
        return this.derive(extraName, this.reporter());
    }

    @NotNull
    default public PhysicalModuleContext derive(@NotNull String extraName, @NotNull Reporter reporter) {
        return this.derive(new ModulePath(ImmutableSeq.of((Object)extraName)), reporter);
    }

    @ApiStatus.NonExtendable
    @NotNull
    default public PhysicalModuleContext derive(@NotNull ModulePath extraName) {
        return this.derive(extraName, this.reporter());
    }

    @NotNull
    default public PhysicalModuleContext derive(@NotNull ModulePath extraName, @NotNull Reporter reporter) {
        return new PhysicalModuleContext(reporter, this, this.modulePath().derive(extraName));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ResolvingInterruptedException
    extends InterruptException {
        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Resolving;
        }
    }
}

