/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.nio.file.Path;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableMap;
import org.aya.resolve.context.Candidate;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.ModuleSymbol;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.error.NameProblem;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.UseHide;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.GenerateKind;
import org.aya.syntax.ref.LocalVar;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ModuleContext
extends Context
permits NoExportContext, PhysicalModuleContext {
    @Override
    @NotNull
    public Context parent();

    @Override
    @NotNull
    default public Reporter reporter() {
        return this.parent().reporter();
    }

    @Override
    @NotNull
    default public Path underlyingFile() {
        return this.parent().underlyingFile();
    }

    @NotNull
    public ModuleSymbol<AnyVar> symbols();

    @NotNull
    public MutableMap<ModuleName.Qualified, ModuleExport> modules();

    @NotNull
    public ModuleExport exports();

    @Override
    @Nullable
    default public ModuleExport getModuleLocalMaybe(@NotNull ModuleName.Qualified modName) {
        return (ModuleExport)this.modules().getOrNull((Object)modName);
    }

    @Override
    @Nullable
    default public AnyVar getUnqualifiedLocalMaybe(@NotNull String name, @NotNull SourcePos sourcePos) {
        Candidate<AnyVar> symbol = this.symbols().get(name);
        if (symbol.isEmpty()) {
            return null;
        }
        if (symbol.isAmbiguous()) {
            this.reportAndThrow(new NameProblem.AmbiguousNameError(name, symbol.from(), sourcePos));
        }
        return symbol.get();
    }

    @Override
    @Nullable
    default public AnyVar getQualifiedLocalMaybe(@NotNull ModuleName.Qualified modName, @NotNull String name, @NotNull SourcePos sourcePos) {
        ModuleExport mod = this.getModuleLocalMaybe(modName);
        if (mod == null) {
            return null;
        }
        AnyDefVar symbol = (AnyDefVar)mod.symbols().getOrNull((Object)name);
        if (symbol == null) {
            this.reportAndThrow(new NameProblem.QualifiedNameNotFoundError((ModuleName)modName, name, sourcePos));
        }
        return symbol;
    }

    default public void importModuleContext(@NotNull ModuleName.Qualified modName, @NotNull ModuleContext module, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        ModuleExport export = module.exports();
        this.importModule(modName, export, accessibility, sourcePos);
        export.modules().forEach((qname, innerMod) -> this.importModule(modName.concat((ModuleName)qname), (ModuleExport)innerMod, accessibility, sourcePos));
    }

    default public void importModule(@NotNull ModuleName.Qualified modName, @NotNull ModuleExport moduleExport, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        ModuleExport exists = (ModuleExport)this.modules().getOrNull((Object)modName);
        if (exists != null) {
            if (exists == moduleExport) {
                return;
            }
            this.reportAndThrow(new NameProblem.DuplicateModNameError((ModuleName)modName, sourcePos));
        } else if (this.getModuleMaybe(modName) != null) {
            this.fail(new NameProblem.ModShadowingWarn((ModuleName)modName, sourcePos));
        }
        this.modules().put((Object)modName, (Object)moduleExport);
    }

    default public void openModule(@NotNull ModuleName.Qualified modName, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos, @NotNull UseHide useHide) {
        this.openModule(modName, accessibility, (ImmutableSeq<QualifiedID>)useHide.list().map(UseHide.Name::id), (ImmutableSeq<WithPos<UseHide.Rename>>)useHide.renaming(), sourcePos, useHide.strategy());
    }

    default public void openModule(@NotNull ModuleName.Qualified modName, @NotNull Stmt.Accessibility accessibility, @NotNull ImmutableSeq<QualifiedID> filter, @NotNull ImmutableSeq<WithPos<UseHide.Rename>> rename, @NotNull SourcePos sourcePos, UseHide.Strategy strategy) {
        ModuleExport modExport = this.getModuleMaybe(modName);
        if (modExport == null) {
            this.reportAndThrow(new NameProblem.ModNameNotFoundError((ModuleName)modName, sourcePos));
        }
        ModuleExport.ExportResult filterRes = modExport.filter(filter, strategy);
        SeqView<Problem> filterProblem = filterRes.problems((ModuleName)modName);
        if (filterRes.anyError()) {
            this.reportAllAndThrow((SeqLike<Problem>)filterProblem);
        }
        ModuleExport.ExportResult mapRes = filterRes.result().map((Seq<WithPos<UseHide.Rename>>)rename);
        SeqView<Problem> mapProblem = mapRes.problems((ModuleName)modName);
        if (mapRes.anyError()) {
            this.reportAllAndThrow((SeqLike<Problem>)mapProblem);
        }
        this.reportAll((SeqLike<Problem>)filterProblem.concat(mapProblem));
        ModuleExport renamed = mapRes.result();
        renamed.symbols().forEach((name, ref) -> this.importSymbol((AnyVar)ref, (ModuleName)modName, (String)name, accessibility, sourcePos));
        renamed.modules().forEach((qname, mod) -> this.importModule((ModuleName.Qualified)qname, (ModuleExport)mod, accessibility, sourcePos));
    }

    default public void importSymbol(@NotNull AnyVar ref, @NotNull ModuleName fromModule, @NotNull String name, @NotNull Stmt.Accessibility acc, @NotNull SourcePos sourcePos) {
        ModuleSymbol<AnyVar> symbols = this.symbols();
        Candidate<AnyVar> candidates = symbols.get(name);
        if (candidates.isEmpty()) {
            LocalVar local;
            if (!(this.getUnqualifiedMaybe(name, sourcePos) == null || ref instanceof LocalVar && (local = (LocalVar)ref).generateKind() == GenerateKind.Basic.Anonymous)) {
                this.fail(new NameProblem.ShadowingWarn(name, sourcePos));
            }
        } else if (candidates.from().contains((Object)fromModule)) {
            this.reportAndThrow(new NameProblem.DuplicateNameError(name, ref, sourcePos));
        } else if (candidates.isAmbiguous() || candidates.get() != ref) {
            this.fail(new NameProblem.AmbiguousNameWarn(name, sourcePos));
        }
        symbols.add(name, ref, fromModule);
        if (ref instanceof AnyDefVar) {
            boolean success;
            AnyDefVar defVar = (AnyDefVar)ref;
            if (acc == Stmt.Accessibility.Public && !(success = this.exportSymbol(name, defVar))) {
                this.reportAndThrow(new NameProblem.DuplicateExportError(name, sourcePos));
            }
        }
    }

    default public boolean exportSymbol(@NotNull String name, @NotNull AnyDefVar ref) {
        return true;
    }

    default public void defineSymbol(@NotNull AnyVar ref, @NotNull Stmt.Accessibility accessibility, @NotNull SourcePos sourcePos) {
        this.importSymbol(ref, (ModuleName)ModuleName.This, ref.name(), accessibility, sourcePos);
    }
}

