/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.context;

import java.util.function.Consumer;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.control.Option;
import org.aya.resolve.error.NameProblem;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.UseHide;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ModuleExport(@NotNull MutableMap<String, AnyDefVar> symbols, @NotNull MutableMap<ModuleName.Qualified, ModuleExport> modules) {
    public ModuleExport() {
        this((MutableMap<String, AnyDefVar>)MutableMap.create(), (MutableMap<ModuleName.Qualified, ModuleExport>)MutableMap.create());
    }

    public ModuleExport(@NotNull ModuleExport that) {
        this((MutableMap<String, AnyDefVar>)MutableMap.from(that.symbols), (MutableMap<ModuleName.Qualified, ModuleExport>)MutableMap.from(that.modules));
    }

    @Contract(pure=true)
    @NotNull
    ExportResult filter(@NotNull ImmutableSeq<QualifiedID> names, UseHide.Strategy strategy) {
        ModuleExport newModule;
        MutableList badNames = MutableList.create();
        switch (strategy) {
            case Using: {
                newModule = new ModuleExport();
                for (QualifiedID name : names) {
                    ExportUnit unit = this.get(name.component(), name.name());
                    if (unit == null) {
                        badNames.append((Object)name);
                        continue;
                    }
                    unit.forEach(x -> {
                        if (name.component() == ModuleName.This) {
                            newModule.export(name.name(), (AnyDefVar)x);
                        }
                    }, x -> newModule.export(name.component().resolve(name.name()), (ModuleExport)x));
                }
                break;
            }
            case Hiding: {
                newModule = new ModuleExport(this);
                names.forEach(qname -> {
                    ExportUnit oldUnit = newModule.remove(qname.component(), qname.name());
                    if (oldUnit == null) {
                        badNames.append(qname);
                    }
                });
                break;
            }
            default: {
                throw new AssertionError((Object)"I mean, this case is impossible.");
            }
        }
        return new ExportResult(badNames.isNotEmpty() ? this : newModule, (ImmutableSeq<QualifiedID>)badNames.toSeq(), (ImmutableSeq<WithPos<String>>)ImmutableSeq.empty());
    }

    @Contract(pure=true)
    @NotNull
    ExportResult map(@NotNull Seq<WithPos<UseHide.Rename>> mapper) {
        ModuleExport newExport = new ModuleExport(this);
        MutableList badNames = MutableList.create();
        MutableList shadowNames = MutableList.create();
        for (WithPos pair : mapper) {
            SourcePos pos = pair.sourcePos();
            ModuleName fromModule = ((UseHide.Rename)pair.data()).name().component();
            String fromName = ((UseHide.Rename)pair.data()).name().name();
            String to = ((UseHide.Rename)pair.data()).to();
            if (fromModule == ModuleName.This && fromName.equals(to)) continue;
            ExportUnit thing = newExport.remove(fromModule, fromName);
            if (thing != null) {
                ExportUnit dest = newExport.get((ModuleName)ModuleName.This, to);
                if (dest != null) {
                    boolean isShadow;
                    boolean bl = isShadow = thing.symbol != null && dest.symbol != null || thing.module != null && dest.module != null;
                    if (isShadow) {
                        shadowNames.append((Object)new WithPos(pos, (Object)to));
                    }
                }
                thing.forEach(x -> newExport.export(to, (AnyDefVar)x), x -> newExport.export(ModuleName.of((String)to, (String[])new String[0]), (ModuleExport)x));
                continue;
            }
            badNames.append((Object)((UseHide.Rename)pair.data()).name());
        }
        boolean hasError = badNames.isNotEmpty();
        return new ExportResult(hasError ? this : newExport, (ImmutableSeq<QualifiedID>)badNames.toSeq(), (ImmutableSeq<WithPos<String>>)shadowNames.toSeq());
    }

    public boolean export(@NotNull String name, @NotNull AnyDefVar ref) {
        Option exists = this.symbols.put((Object)name, (Object)ref);
        return exists.isEmpty();
    }

    public boolean export(@NotNull ModuleName.Qualified componentName, @NotNull ModuleExport module) {
        return this.modules.put((Object)componentName, (Object)module).isEmpty();
    }

    @Nullable
    private ExportUnit get(@NotNull ModuleName component, @NotNull String name) {
        AnyDefVar symbol = component == ModuleName.This ? (AnyDefVar)this.symbols.getOrNull((Object)name) : null;
        ModuleExport module = (ModuleExport)this.modules.getOrNull((Object)component.resolve(name));
        if (symbol == null && module == null) {
            return null;
        }
        return new ExportUnit(symbol, module);
    }

    @Nullable
    private ExportUnit remove(@NotNull ModuleName component, @NotNull String name) {
        AnyDefVar symbol = component == ModuleName.This ? (AnyDefVar)this.symbols.remove((Object)name).getOrNull() : null;
        ModuleExport module = (ModuleExport)this.modules.remove((Object)component.resolve(name)).getOrNull();
        if (symbol == null && module == null) {
            return null;
        }
        return new ExportUnit(symbol, module);
    }

    private record ExportUnit(@Nullable AnyDefVar symbol, @Nullable ModuleExport module) {
        public ExportUnit(@Nullable AnyDefVar symbol, @Nullable ModuleExport module) {
            assert (symbol != null || module != null) : "Sanity check";
        }

        public void forEach(Consumer<AnyDefVar> symbolConsumer, Consumer<ModuleExport> moduleConsumer) {
            if (this.symbol != null) {
                symbolConsumer.accept(this.symbol);
            }
            if (this.module != null) {
                moduleConsumer.accept(this.module);
            }
        }
    }

    record ExportResult(@NotNull ModuleExport result, @NotNull ImmutableSeq<QualifiedID> invalidNames, @NotNull ImmutableSeq<WithPos<String>> shadowNames) {
        public boolean anyError() {
            return this.invalidNames().isNotEmpty();
        }

        public boolean anyWarn() {
            return this.shadowNames().isNotEmpty();
        }

        public SeqView<Problem> problems(@NotNull ModuleName modName) {
            SeqView invalidNameProblems = this.invalidNames().view().map(name -> new NameProblem.QualifiedNameNotFoundError(modName.concat(name.component()), name.name(), name.sourcePos()));
            SeqView shadowNameProblems = this.shadowNames().view().map(name -> new NameProblem.ShadowingWarn((String)name.data(), name.sourcePos()));
            return shadowNameProblems.concat((SeqLike)invalidNameProblems);
        }
    }
}

