/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.module;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kala.collection.immutable.ImmutableSeq;
import org.aya.primitive.PrimFactory;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.context.EmptyContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.AyaFiles;
import org.aya.syntax.GenericAyaFile;
import org.aya.syntax.GenericAyaParser;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.position.SourceFileLocator;
import org.aya.util.reporter.Reporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FileModuleLoader(@NotNull SourceFileLocator locator, @NotNull Path basePath, @NotNull Reporter reporter, @NotNull GenericAyaParser parser, @NotNull GenericAyaFile.Factory fileManager, @NotNull PrimFactory primFactory) implements ModuleLoader
{
    public FileModuleLoader(@NotNull SourceFileLocator locator, @NotNull Path basePath, @NotNull Reporter reporter, @NotNull GenericAyaParser parser, @NotNull GenericAyaFile.Factory fileManager) {
        this(locator, basePath, reporter, parser, fileManager, new PrimFactory());
    }

    @Override
    @Nullable
    public ResolveInfo load(@NotNull ModulePath path, @NotNull ModuleLoader recurseLoader) {
        Path sourcePath = AyaFiles.resolveAyaSourceFile((Path)this.basePath, (ImmutableSeq)path.module());
        try {
            ImmutableSeq program = this.fileManager.createAyaFile(this.locator, sourcePath).parseMe(this.parser);
            PhysicalModuleContext context = new EmptyContext(this.reporter, sourcePath).derive(path);
            return this.tyckModule(this.resolveModule(this.primFactory, context, (ImmutableSeq<Stmt>)program, recurseLoader), null);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean existsFileLevelModule(@NotNull ModulePath path) {
        try {
            Path sourcePath = AyaFiles.resolveAyaSourceFile((Path)this.basePath, (ImmutableSeq)path.module());
            return Files.exists(sourcePath, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }
}

