/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableLinkedHashMap;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableStack;
import kala.control.Either;
import kala.control.Option;
import kala.value.MutableValue;
import org.aya.generic.stmt.TyckOrder;
import org.aya.generic.stmt.TyckUnit;
import org.aya.resolve.context.Context;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.error.GeneralizedNotAvailableError;
import org.aya.resolve.visitor.PatternResolver;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.concrete.stmt.Generalize;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.GeneralizedVar;
import org.aya.syntax.ref.LocalVar;
import org.aya.tyck.error.ClassError;
import org.aya.util.Panic;
import org.aya.util.position.PosedUnaryOperator;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record ExprResolver(@NotNull Context ctx, boolean allowGeneralizing, @NotNull MutableMap<GeneralizedVar, Expr.Param> allowedGeneralizes, @NotNull MutableList<TyckOrder> reference, @NotNull MutableStack<Where> where) implements PosedUnaryOperator<Expr>
{
    public ExprResolver(@NotNull Context ctx, boolean allowGeneralizing) {
        this(ctx, allowGeneralizing, (MutableMap<GeneralizedVar, Expr.Param>)MutableLinkedHashMap.of(), (MutableList<TyckOrder>)MutableList.create(), (MutableStack<Where>)MutableStack.create());
    }

    @Contract(pure=true)
    public static LiterateResolved resolveLax(@NotNull ModuleContext context, @NotNull WithPos<Expr> expr) {
        ExprResolver resolver = new ExprResolver(context, true);
        resolver.enter(Where.FnBody);
        WithPos inner = expr.descent((PosedUnaryOperator)resolver);
        ImmutableSeq view = resolver.allowedGeneralizes().valuesView().toSeq();
        return new LiterateResolved((ImmutableSeq<Expr.Param>)view, (WithPos<Expr>)inner);
    }

    public void resetRefs() {
        this.reference.clear();
    }

    public void enter(Where loc) {
        this.where.push((Object)loc);
    }

    public void exit() {
        this.where.pop();
    }

    @NotNull
    public ExprResolver enter(Context ctx) {
        return ctx == this.ctx() ? this : new ExprResolver(ctx, this.allowGeneralizing, this.allowedGeneralizes, this.reference, this.where);
    }

    @NotNull
    public ExprResolver deriveRestrictive() {
        return new ExprResolver(this.ctx, false, this.allowedGeneralizes, this.reference, this.where);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Expr pre(@NotNull Expr expr) {
        Expr expr2;
        Expr expr3 = expr;
        Objects.requireNonNull(expr3);
        Expr expr4 = expr3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Proj.class, Expr.Hole.class}, (Expr)expr4, n)) {
            case 0: {
                Expr.Hole theCore;
                Expr.Hole ix;
                Expr.Hole tup;
                Expr.Hole hole;
                Expr.Proj proj = (Expr.Proj)expr4;
                try {
                    tup = hole = proj.tup();
                    ix = hole = proj.ix();
                    hole = proj.resolvedVar();
                    theCore = hole = proj.theCoreType();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (ix.isLeft()) {
                    expr2 = expr;
                    return expr2;
                }
                QualifiedID projName = (QualifiedID)ix.getRightValue();
                AnyVar resolvedIx = this.ctx.getMaybe(projName);
                if (resolvedIx == null) {
                    this.ctx.reportAndThrow(new ClassError.UnknownMember(projName.sourcePos(), projName.join()));
                }
                expr2 = new Expr.Proj((WithPos)tup, (Either)ix, resolvedIx, (MutableValue)theCore);
                return expr2;
            }
            case 1: {
                WithPos local;
                WithPos core;
                WithPos fill;
                boolean expl;
                Expr.Hole hole = (Expr.Hole)expr4;
                {
                    WithPos withPos;
                    boolean bl;
                    boolean bl2 = bl = hole.explicit();
                    expl = bl;
                    fill = withPos = hole.filling();
                    core = withPos = hole.solution();
                    local = withPos = hole.accessibleLocal();
                }
                assert (local.isEmpty());
                expr2 = new Expr.Hole(expl, fill, (MutableValue)core, this.ctx.collect((MutableList<LocalVar>)MutableList.create()).toSeq());
                return expr2;
            }
        }
        expr2 = expr;
        return expr2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Expr apply(@NotNull SourcePos pos, @NotNull Expr expr) {
        Expr expr2;
        Expr expr3 = this.pre(expr);
        Objects.requireNonNull(expr3);
        Expr expr32 = expr3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Expr.Do.class, Expr.ClauseLam.class, Expr.DepType.class, Expr.Array.class, Expr.Unresolved.class, Expr.Let.class, Expr.LetOpen.class, Expr.Match.class, Expr.Lambda.class, Expr.class}, (Expr)expr32, n)) {
            case 0: {
                Expr.Do doExpr = (Expr.Do)expr32;
                expr2 = doExpr.update(this.apply(SourcePos.NONE, doExpr.bindName()), this.bind((ImmutableSeq<Expr.DoBind>)doExpr.binds(), (MutableValue<Context>)MutableValue.create((Object)this.ctx)));
                return expr2;
            }
            case 1: {
                Expr.ClauseLam lam = (Expr.ClauseLam)expr32;
                expr2 = lam.update(this.clause((ImmutableSeq<LocalVar>)ImmutableSeq.empty(), lam.clause()));
                return expr2;
            }
            case 2: {
                Expr.DepType depType = (Expr.DepType)expr32;
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                Expr.Param param2 = this.bind(depType.param(), (MutableValue<Context>)mCtx);
                expr2 = depType.update(param2, depType.last().descent((PosedUnaryOperator)this.enter((Context)mCtx.get())));
                return expr2;
            }
            case 3: {
                Expr.Array array = (Expr.Array)expr32;
                expr2 = array.update(array.arrayBlock().map(left -> {
                    MutableValue mCtx = MutableValue.create((Object)this.ctx);
                    ImmutableSeq<Expr.DoBind> binds = this.bind((ImmutableSeq<Expr.DoBind>)left.binds(), (MutableValue<Context>)mCtx);
                    WithPos generator = left.generator().descent((PosedUnaryOperator)this.enter((Context)mCtx.get()));
                    return left.update(generator, binds, left.names().fmap(arg_0 -> ((ExprResolver)this).forceApply(arg_0)));
                }, right -> right.descent((PosedUnaryOperator)this)));
                return expr2;
            }
            case 4: {
                AnyVar anyVar;
                Expr.Unresolved unresolved = (Expr.Unresolved)expr32;
                try {
                    AnyVar resolved;
                    QualifiedID qualifiedID;
                    QualifiedID name = qualifiedID = unresolved.name();
                    anyVar = resolved = this.resolve(name);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Objects.requireNonNull(anyVar);
                AnyVar anyVar2 = anyVar;
                int n2 = 0;
                AnyVar finalVar = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralizedVar.class, DefVar.class, AnyVar.class}, (AnyVar)anyVar2, n2)) {
                    case 0 -> {
                        GeneralizedVar generalized = (GeneralizedVar)anyVar2;
                        if (this.allowGeneralizing) {
                            Generalize owner = generalized.owner;
                            if (!$assertionsDisabled && owner == null) {
                                throw new AssertionError((Object)"Sanity check");
                            }
                            Expr.Param param = owner.toExpr(false, generalized.toLocal());
                            this.allowedGeneralizes.put((Object)generalized, (Object)param);
                            this.addReference((TyckUnit)owner);
                            yield param.ref();
                        }
                        yield (AnyVar)this.ctx.reportAndThrow(new GeneralizedNotAvailableError(pos, (AnyVar)generalized));
                    }
                    case 1 -> {
                        DefVar defVar = (DefVar)anyVar2;
                        this.addReference(defVar);
                        yield defVar;
                    }
                    default -> {
                        AnyVar var;
                        yield var = anyVar2;
                    }
                };
                expr2 = new Expr.Ref(finalVar);
                return expr2;
            }
            case 5: {
                Expr.Let let = (Expr.Let)expr32;
                Expr.LetBind letBind = let.bind();
                MutableValue mCtx = MutableValue.create((Object)this.ctx);
                ImmutableSeq telescope = letBind.telescope().map(param -> this.bind((Expr.Param)param, (MutableValue<Context>)mCtx));
                ExprResolver resolver = this.enter((Context)mCtx.get());
                WithPos result = letBind.result().descent((PosedUnaryOperator)resolver);
                WithPos definedAs = letBind.definedAs().descent((PosedUnaryOperator)resolver);
                WithPos newBody = let.body().descent((PosedUnaryOperator)this.enter(this.ctx.bind(letBind.bindName())));
                expr2 = let.update(letBind.update(telescope, result, definedAs), newBody);
                return expr2;
            }
            case 6: {
                Expr.LetOpen letOpen = (Expr.LetOpen)expr32;
                NoExportContext context = new NoExportContext(this.ctx);
                context.openModule(letOpen.componentName(), Stmt.Accessibility.Private, letOpen.sourcePos(), letOpen.useHide());
                expr2 = letOpen.update(letOpen.body().descent((PosedUnaryOperator)this.enter(context)));
                return expr2;
            }
            case 7: {
                Expr.Match match = (Expr.Match)expr32;
                ImmutableSeq discriminant = match.discriminant().map(d -> d.descent((PosedUnaryOperator)this));
                Context returnsCtx = this.ctx;
                for (Expr.Match.Discriminant discr : match.discriminant()) {
                    if (discr.asBinding() == null) continue;
                    returnsCtx = returnsCtx.bind(discr.asBinding());
                }
                WithPos returns = match.returns() != null ? match.returns().descent((PosedUnaryOperator)this.enter(returnsCtx)) : null;
                this.enter(Where.FnPattern);
                ImmutableSeq clauses = match.clauses().map(x -> this.clause((ImmutableSeq<LocalVar>)ImmutableSeq.empty(), (Pattern.Clause)x));
                this.exit();
                expr2 = match.update(discriminant, clauses, returns);
                return expr2;
            }
            case 8: {
                expr2 = (Expr)Panic.unreachable();
                return expr2;
            }
        }
        Expr newExpr = expr32;
        expr2 = newExpr.descent((PosedUnaryOperator)this);
        return expr2;
    }

    private void addReference(@NotNull TyckUnit unit) {
        if (this.where.isEmpty()) {
            throw new Panic("where am I?");
        }
        switch (((Where)((Object)this.where.peek())).ordinal()) {
            case 3: {
                this.reference.append((Object)new TyckOrder.Body(unit));
                if (!(unit instanceof DataCon)) break;
                DataCon con = (DataCon)unit;
                this.reference.append((Object)new TyckOrder.Body((TyckUnit)con.dataRef.concrete));
                break;
            }
            default: {
                this.reference.append((Object)new TyckOrder.Head(unit));
            }
        }
    }

    private void addReference(@NotNull DefVar<?, ?> defVar) {
        this.addReference((TyckUnit)defVar.concrete);
    }

    @NotNull
    public Pattern.Clause clause(@NotNull ImmutableSeq<LocalVar> telescope, @NotNull Pattern.Clause clause) {
        MutableValue mCtx = MutableValue.create((Object)this.ctx);
        this.enter(Where.FnPattern);
        ImmutableSeq pats = clause.patterns.map(pa -> pa.descent(pat -> this.resolvePattern((WithPos<Pattern>)pat, telescope, (MutableValue<Context>)mCtx)));
        this.exit();
        this.enter(Where.FnBody);
        Option body = clause.expr.map(x -> x.descent((PosedUnaryOperator)this.enter((Context)mCtx.get())));
        this.exit();
        return clause.update(pats, body);
    }

    @NotNull
    public WithPos<Pattern> resolvePattern(@NotNull WithPos<Pattern> pattern, @NotNull ImmutableSeq<LocalVar> telescope, MutableValue<Context> ctx) {
        PatternResolver resolver = new PatternResolver((Context)ctx.get(), telescope, this::addReference);
        WithPos result = pattern.descent((PosedUnaryOperator)resolver);
        ctx.set((Object)resolver.context());
        return result;
    }

    @Contract(mutates="param2")
    @NotNull
    public Expr.Param bind(@NotNull Expr.Param param, @NotNull MutableValue<Context> ctx) {
        Expr.Param p = param.descent((PosedUnaryOperator)this.enter((Context)ctx.get()));
        ctx.set((Object)((Context)ctx.get()).bind(param.ref()));
        return p;
    }

    @NotNull
    public ImmutableSeq<Expr.DoBind> bind(@NotNull ImmutableSeq<Expr.DoBind> binds, @NotNull MutableValue<Context> ctx) {
        return binds.map(bind -> {
            Expr.DoBind b = bind.descent((PosedUnaryOperator)this.enter((Context)ctx.get()));
            ctx.set((Object)((Context)ctx.get()).bind(bind.var()));
            return b;
        });
    }

    @NotNull
    public AnyVar resolve(@NotNull QualifiedID name) {
        GeneralizedVar gvar;
        Expr.Param gened;
        AnyVar result = this.ctx.get(name);
        if (result instanceof GeneralizedVar && (gened = (Expr.Param)this.allowedGeneralizes.getOrNull((Object)(gvar = (GeneralizedVar)result))) != null) {
            return gened.ref();
        }
        return result;
    }

    @NotNull
    public ExprResolver member(@NotNull TyckUnit decl, Where initial) {
        ExprResolver resolver = new ExprResolver(this.ctx, false, this.allowedGeneralizes, (MutableList<TyckOrder>)MutableList.of((Object)new TyckOrder.Head(decl)), (MutableStack<Where>)MutableStack.create());
        resolver.enter(initial);
        return resolver;
    }

    public static enum Where {
        Head,
        ConPattern,
        FnSimple,
        FnPattern,
        FnBody;

    }

    public record LiterateResolved(ImmutableSeq<Expr.Param> params, WithPos<Expr> expr) {
        @NotNull
        public LiterateResolved descent(@NotNull PosedUnaryOperator<Expr> desalt) {
            return new LiterateResolved((ImmutableSeq<Expr.Param>)this.params.map(p -> p.descent(desalt)), (WithPos<Expr>)this.expr.descent(desalt));
        }
    }

    public record Options(boolean allowIntroduceGeneralized) {
    }
}

