/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.immutable.ImmutableSeq;
import org.aya.generic.stmt.TyckUnit;
import org.aya.resolve.context.Context;
import org.aya.resolve.error.NameProblem;
import org.aya.syntax.compile.JitCon;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.QualifiedID;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.core.def.ConDefLike;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.CompiledVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.LocalVar;
import org.aya.util.Panic;
import org.aya.util.position.PosedUnaryOperator;
import org.aya.util.position.SourcePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternResolver
implements PosedUnaryOperator<Pattern> {
    @NotNull
    private Context context;
    @NotNull
    private final ImmutableSeq<LocalVar> mercy;
    @NotNull
    private final Consumer<TyckUnit> parentAdd;

    public PatternResolver(@NotNull Context context, @NotNull ImmutableSeq<LocalVar> mercy, @NotNull Consumer<TyckUnit> parentAdd) {
        this.context = context;
        this.mercy = mercy;
        this.parentAdd = parentAdd;
    }

    @NotNull
    public Context context() {
        return this.context;
    }

    @NotNull
    public Pattern apply(@NotNull SourcePos pos, @NotNull Pattern pat) {
        return this.post(pos, pat.descent((PosedUnaryOperator)this));
    }

    @NotNull
    public Pattern post(@NotNull SourcePos pos, @NotNull Pattern pat) {
        Pattern pattern = pat;
        Objects.requireNonNull(pattern);
        Pattern pattern2 = pattern;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Bind.class, Pattern.QualifiedRef.class, Pattern.As.class}, (Pattern)pattern2, n)) {
            case 0 -> {
                Pattern.Bind bind = (Pattern.Bind)pattern2;
                AnyDefVar conMaybe = this.context.iterate(ctx -> PatternResolver.isCon(ctx.getUnqualifiedLocalMaybe(bind.bind().name(), pos)));
                if (conMaybe != null) {
                    this.addReference(conMaybe);
                    yield new Pattern.Con(pos, ConDefLike.from((AnyDefVar)conMaybe));
                }
                this.context = this.context.bind(bind.bind(), this::toWarn);
                yield bind;
            }
            case 1 -> {
                Pattern.QualifiedRef qref = (Pattern.QualifiedRef)pattern2;
                QualifiedID qid = qref.qualifiedID();
                ModuleName var9_10 = qid.component();
                if (!(var9_10 instanceof ModuleName.Qualified)) {
                    throw new Panic("QualifiedRef#qualifiedID should be qualified");
                }
                ModuleName.Qualified mod = (ModuleName.Qualified)var9_10;
                AnyDefVar conMaybe = this.context.iterate(ctx -> PatternResolver.isCon(ctx.getQualifiedLocalMaybe(mod, qid.name(), pos)));
                if (conMaybe != null) {
                    this.addReference(conMaybe);
                    yield new Pattern.Con(pos, ConDefLike.from((AnyDefVar)conMaybe));
                }
                yield (Pattern)this.context.reportAndThrow(new NameProblem.QualifiedNameNotFoundError(qid.component(), qid.name(), pos));
            }
            case 2 -> {
                Pattern.As as = (Pattern.As)pattern2;
                this.context = this.context.bind(as.as(), this::toWarn);
                yield as;
            }
            default -> pat;
        };
    }

    private boolean toWarn(@Nullable AnyVar var) {
        return var instanceof LocalVar && !this.mercy.contains((Object)var);
    }

    private void addReference(@NotNull AnyDefVar defVar) {
        if (defVar instanceof DefVar) {
            DefVar fr = (DefVar)defVar;
            this.parentAdd.accept((TyckUnit)fr.concrete);
        }
    }

    @Nullable
    private static AnyDefVar isCon(@Nullable AnyVar myMaybe) {
        DefVar defVar;
        AnyVar anyVar = myMaybe;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefVar.class, CompiledVar.class}, (AnyVar)anyVar, n)) {
                case 0: {
                    DefVar def = (DefVar)anyVar;
                    if (!(def.concrete instanceof DataCon)) {
                        n = 1;
                        continue block4;
                    }
                    defVar = def;
                    break block4;
                }
                case 1: {
                    CompiledVar var = (CompiledVar)anyVar;
                    if (!(var.core() instanceof JitCon)) {
                        n = 2;
                        continue block4;
                    }
                    defVar = var;
                    break block4;
                }
                default: {
                    defVar = null;
                    break block4;
                }
            }
            break;
        }
        return defVar;
    }
}

