/*
 * Decompiled with CFR 0.152.
 */
package org.aya.resolve.visitor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Option;
import org.aya.generic.Suppress;
import org.aya.primitive.PrimFactory;
import org.aya.resolve.ResolveInfo;
import org.aya.resolve.ResolvingStmt;
import org.aya.resolve.context.ModuleContext;
import org.aya.resolve.context.ModuleExport;
import org.aya.resolve.context.NoExportContext;
import org.aya.resolve.context.PhysicalModuleContext;
import org.aya.resolve.context.ReporterContext;
import org.aya.resolve.error.NameProblem;
import org.aya.resolve.error.PrimResolveError;
import org.aya.resolve.module.ModuleLoader;
import org.aya.syntax.concrete.stmt.BindBlock;
import org.aya.syntax.concrete.stmt.Command;
import org.aya.syntax.concrete.stmt.Generalize;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.Stmt;
import org.aya.syntax.concrete.stmt.UseHide;
import org.aya.syntax.concrete.stmt.decl.ClassDecl;
import org.aya.syntax.concrete.stmt.decl.DataDecl;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.concrete.stmt.decl.FnDecl;
import org.aya.syntax.concrete.stmt.decl.PragmaInfo;
import org.aya.syntax.concrete.stmt.decl.PrimDecl;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.def.PrimDef;
import org.aya.syntax.ref.AnyDefVar;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.GeneralizedVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.syntax.ref.QPath;
import org.aya.util.Panic;
import org.aya.util.binop.Assoc;
import org.aya.util.binop.OpDecl;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.aya.util.reporter.Reporter;
import org.aya.util.reporter.SuppressingReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record StmtPreResolver(@NotNull ModuleLoader loader, @NotNull ResolveInfo resolveInfo) {
    public ImmutableSeq<ResolvingStmt> resolveStmt(@NotNull ImmutableSeq<Stmt> stmts, ModuleContext context) {
        return stmts.mapNotNull(stmt -> this.resolveStmt((Stmt)stmt, context));
    }

    @Nullable
    public ResolvingStmt resolveStmt(@NotNull Stmt stmt, @NotNull ModuleContext context) {
        Stmt stmt2 = stmt;
        Objects.requireNonNull(stmt2);
        Stmt stmt3 = stmt2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Decl.class, Command.Module.class, Command.Import.class, Command.Open.class, Generalize.class}, (Stmt)stmt3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Decl decl = (Decl)stmt3;
                yield this.resolveDecl(decl, context);
            }
            case 1 -> {
                Command.Module mod = (Command.Module)stmt3;
                ModulePath wholeModeName = context.modulePath().derive(mod.name());
                if (this.loader.existsFileLevelModule(wholeModeName)) {
                    context.reportAndThrow(new NameProblem.ClashModNameError(wholeModeName, mod.sourcePos()));
                }
                PhysicalModuleContext newCtx = context.derive(mod.name());
                ImmutableSeq<ResolvingStmt> children = this.resolveStmt((ImmutableSeq<Stmt>)mod.contents(), (ModuleContext)newCtx);
                context.importModuleContext(ModuleName.This.resolve(mod.name()), newCtx, mod.accessibility(), mod.sourcePos());
                yield new ResolvingStmt.ModStmt(children);
            }
            case 2 -> {
                Command.Import cmd = (Command.Import)stmt3;
                ModulePath modulePath = cmd.path();
                ResolveInfo success = this.loader.load(modulePath);
                if (success == null) {
                    context.reportAndThrow(new NameProblem.ModNotFoundError(modulePath, cmd.sourcePos()));
                }
                ModuleContext mod = success.thisModule();
                WithPos as = cmd.asName();
                ModuleName.Qualified importedName = as != null ? ModuleName.This.resolve((String)as.data()) : modulePath.asName();
                context.importModuleContext(importedName, mod, cmd.accessibility(), cmd.sourcePos());
                ResolveInfo.ImportInfo importInfo = new ResolveInfo.ImportInfo(success, cmd.accessibility() == Stmt.Accessibility.Public);
                this.resolveInfo.imports().put((Object)importedName, (Object)importInfo);
                yield null;
            }
            case 3 -> {
                Command.Open cmd = (Command.Open)stmt3;
                ModuleName.Qualified mod = cmd.path();
                Stmt.Accessibility acc = cmd.accessibility();
                UseHide useHide = cmd.useHide();
                ModuleContext ctx = cmd.openExample() ? StmtPreResolver.exampleContext(context) : context;
                ctx.openModule(mod, acc, cmd.sourcePos(), useHide);
                this.resolveInfo.imports().getOption((Object)mod).ifDefined(modResolveInfo -> {
                    if (acc == Stmt.Accessibility.Public) {
                        this.resolveInfo.reExports().put((Object)mod, (Object)useHide);
                    }
                    this.resolveInfo.open(modResolveInfo.resolveInfo(), cmd.sourcePos(), acc);
                });
                if (useHide.strategy() == UseHide.Strategy.Using) {
                    useHide.list().forEach(use -> {
                        if (use.asAssoc() == Assoc.Unspecified) {
                            return;
                        }
                        if (use.id().component() != ModuleName.This) {
                            return;
                        }
                        AnyDefVar symbol = (AnyDefVar)((ModuleExport)ctx.modules().get((Object)mod)).symbols().get((Object)use.id().name());
                        String asName = (String)use.asName().getOrDefault((Object)use.id().name());
                        ResolveInfo.RenamedOpDecl renamedOpDecl = new ResolveInfo.RenamedOpDecl(new OpDecl.OpInfo(asName, use.asAssoc()));
                        BindBlock bind = use.asBind();
                        this.resolveInfo.renameOp(ctx, AnyDef.fromVar((AnyDefVar)symbol), renamedOpDecl, bind, true);
                    });
                }
                yield null;
            }
            case 4 -> {
                Generalize variables = (Generalize)stmt3;
                for (GeneralizedVar variable : variables.variables) {
                    context.defineSymbol((AnyVar)variable, Stmt.Accessibility.Private, variable.sourcePos);
                }
                yield new ResolvingStmt.GenStmt(variables, context);
            }
        };
    }

    @NotNull
    private ResolvingStmt resolveDecl(@NotNull Decl predecl, @NotNull ModuleContext context) {
        Decl decl = predecl;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataDecl.class, ClassDecl.class, FnDecl.class, PrimDecl.class}, (Decl)decl2, n)) {
            case 0 -> {
                DataDecl decl = (DataDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl, context);
                PhysicalModuleContext innerCtx = this.resolveChildren(decl, ctx, d -> d.body.clauses.view(), (con, mCtx) -> {
                    this.setupModule((ModuleContext)mCtx, (DefVar<?, ?>)con.ref);
                    mCtx.defineSymbol((AnyVar)con.ref(), Stmt.Accessibility.Public, con.sourcePos());
                });
                yield new ResolvingStmt.TopDecl((Decl)decl, innerCtx);
            }
            case 1 -> {
                ClassDecl decl = (ClassDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl, context);
                PhysicalModuleContext innerCtx = this.resolveChildren(decl, ctx, d -> d.members.view(), (mem, mCtx) -> {
                    this.setupModule((ModuleContext)mCtx, (DefVar<?, ?>)mem.ref);
                    mCtx.defineSymbol((AnyVar)mem.ref(), Stmt.Accessibility.Public, mem.ref().concrete.sourcePos());
                });
                yield new ResolvingStmt.TopDecl((Decl)decl, innerCtx);
            }
            case 2 -> {
                FnDecl decl = (FnDecl)decl2;
                ModuleContext ctx = this.resolveTopLevelDecl(decl, context);
                ReporterContext hijackedCtx = new ReporterContext(ctx, StmtPreResolver.suppress(context.reporter(), (Decl)decl));
                yield new ResolvingStmt.TopDecl((Decl)decl, hijackedCtx);
            }
            case 3 -> {
                Option<ImmutableSeq<PrimDef.ID>> lack;
                PrimDecl decl = (PrimDecl)decl2;
                PrimFactory factory = this.resolveInfo.primFactory();
                String name = decl.ref.name();
                SourcePos sourcePos = decl.sourcePos();
                PrimDef.ID primID = PrimDef.ID.find((String)name);
                if (primID == null) {
                    context.reportAndThrow(new PrimResolveError.UnknownPrim(sourcePos, name));
                }
                if ((lack = factory.checkDependency(primID)).isNotEmpty() && ((ImmutableSeq)lack.get()).isNotEmpty()) {
                    context.reportAndThrow(new PrimResolveError.Dependency(name, (ImmutableSeq<PrimDef.ID>)((ImmutableSeq)lack.get()), sourcePos));
                } else if (factory.isForbiddenRedefinition(primID, false)) {
                    context.reportAndThrow(new PrimResolveError.Redefinition(name, sourcePos));
                }
                factory.factory(primID, (DefVar<PrimDef, PrimDecl>)decl.ref);
                ModuleContext resolvedCtx = this.resolveTopLevelDecl(decl, context);
                yield new ResolvingStmt.TopDecl((Decl)decl, resolvedCtx);
            }
            default -> (ResolvingStmt)Panic.unreachable();
        };
    }

    private static Reporter suppress(@NotNull Reporter reporter, @NotNull Decl decl) {
        PragmaInfo.SuppressWarn suppressInfo = decl.pragmaInfo.suppressWarn;
        if (suppressInfo == null) {
            return reporter;
        }
        ImmutableSeq suppresses = suppressInfo.args();
        if (suppresses.isEmpty()) {
            return reporter;
        }
        SuppressingReporter r = new SuppressingReporter(reporter);
        suppresses.forEach(suppress -> {
            switch ((Suppress)suppress.data()) {
                case LocalShadow: {
                    r.suppress(NameProblem.ShadowingWarn.class);
                }
            }
        });
        return r;
    }

    private <D extends Decl, Child> PhysicalModuleContext resolveChildren(@NotNull D decl, @NotNull ModuleContext context, @NotNull Function<D, SeqView<Child>> childrenGet, @NotNull BiConsumer<Child, ModuleContext> childResolver) {
        PhysicalModuleContext innerCtx = context.derive(decl.ref().name(), StmtPreResolver.suppress(context.reporter(), decl));
        childrenGet.apply(decl).forEach(child -> childResolver.accept(child, innerCtx));
        String module = decl.ref().name();
        context.importModule(ModuleName.This.resolve(module), innerCtx.exports, decl.accessibility(), decl.sourcePos());
        return innerCtx;
    }

    @NotNull
    public static NoExportContext exampleContext(@NotNull ModuleContext context) {
        NoExportContext noExportContext;
        if (context instanceof PhysicalModuleContext) {
            PhysicalModuleContext physical = (PhysicalModuleContext)context;
            noExportContext = physical.exampleContext();
        } else {
            noExportContext = (NoExportContext)Panic.unreachable();
        }
        return noExportContext;
    }

    @NotNull
    private <D extends Decl> ModuleContext resolveTopLevelDecl(@NotNull D decl, @NotNull ModuleContext context) {
        ModuleContext ctx = decl.isExample ? StmtPreResolver.exampleContext(context) : context;
        this.setupModule(ctx, decl.ref());
        ctx.defineSymbol((AnyVar)decl.ref(), decl.accessibility(), decl.sourcePos());
        return ctx;
    }

    private void setupModule(ModuleContext ctx, DefVar<?, ?> ref) {
        ref.module = new QPath(ctx.modulePath(), this.resolveInfo.modulePath().size());
    }
}

