/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.term.call.ClassCall;
import org.aya.tyck.error.SourceNodeProblem;
import org.aya.tyck.error.TyckError;
import org.aya.util.PrettierOptions;
import org.aya.util.position.SourceNode;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.jetbrains.annotations.NotNull;

public interface ClassError
extends TyckError,
SourceNodeProblem {
    @Override
    @NotNull
    default public SourcePos sourcePos() {
        return this.expr().sourcePos();
    }

    public record ProjIxError(@NotNull SourceNode expr, int actual) implements TyckError,
    SourceNodeProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Index can only be 1 or 2, there's no"), Doc.ordinal((int)this.actual), Doc.english((String)"projection")});
        }
    }

    public record InstanceNotFound(@NotNull SourcePos sourcePos, @NotNull ClassCall clazz) implements TyckError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Instances for the class"), BasePrettier.refVar((AnyDef)this.clazz.ref()), Doc.english((String)"not found")});
        }
    }

    public record UnknownMember(@NotNull SourcePos sourcePos, @NotNull String name) implements TyckError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unknown member"), Doc.code((String)this.name), Doc.english((String)"projected")});
        }
    }

    public static final class NotFullyApplied
    extends Record
    implements ClassError {
        @NotNull
        private final WithPos<Expr> expr;

        public NotFullyApplied(@NotNull WithPos<Expr> expr) {
            this.expr = expr;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Unable to new an incomplete class type:"), Doc.code((Doc)((Expr)this.expr.data()).toDoc(options))});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NotFullyApplied.class, "expr", "expr"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NotFullyApplied.class, "expr", "expr"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NotFullyApplied.class, "expr", "expr"}, this, o);
        }

        @NotNull
        public WithPos<Expr> expr() {
            return this.expr;
        }
    }
}

