/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.compile.JitCon;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.def.ConDef;
import org.aya.syntax.core.def.ConDefLike;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.DataCall;
import org.aya.tyck.error.UnifyInfo;
import org.aya.util.PrettierOptions;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.aya.util.reporter.Problem;
import org.aya.util.tyck.pat.PatClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ClausesProblem
extends Problem {
    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    @NotNull
    private static Doc termToHint(@Nullable Term term, @NotNull PrettierOptions options) {
        return term == null ? Doc.empty() : Doc.sep((Doc[])new Doc[]{Doc.english((String)"confluence: this clause is substituted to"), Doc.code((Doc)term.toDoc(options))});
    }

    public record FMDomination(int sub, @NotNull SourcePos sourcePos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.sub), Doc.english((String)"clause is dominated by the other clauses, hence unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }
    }

    public record Domination(int dom, int sub, @NotNull SourcePos sourcePos) implements ClausesProblem,
    Comparable<Domination>
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc subOrdinal = Doc.ordinal((int)this.sub);
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"The"), Doc.ordinal((int)this.dom), Doc.english((String)"clause dominates the"), subOrdinal, Doc.english((String)"clause. The"), subOrdinal, Doc.english((String)"clause will be unreachable")});
        }

        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }

        @Override
        public int compareTo(@NotNull Domination o) {
            int domCmp = Integer.compare(this.dom, o.dom);
            return domCmp != 0 ? domCmp : Integer.compare(this.sub, o.sub);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Domination)) {
                return false;
            }
            Domination that = (Domination)o;
            return this.dom == that.dom && this.sub == that.sub;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.dom, this.sub);
        }
    }

    public record UnsureCase(@NotNull SourcePos sourcePos, @NotNull ConDefLike con, @NotNull DataCall dataCall) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc[] docArray = new Doc[4];
            docArray[0] = Doc.english((String)"I'm unsure if there should be a case for constructor");
            ConDefLike conDefLike = this.con;
            Objects.requireNonNull(conDefLike);
            ConDefLike conDefLike2 = conDefLike;
            int n = 0;
            docArray[1] = Doc.par((int)1, (Doc)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitCon.class, ConDef.Delegate.class}, (ConDefLike)conDefLike2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    JitCon jitCon = (JitCon)conDefLike2;
                    yield BasePrettier.refVar((AnyDef)jitCon);
                }
                case 1 -> {
                    ConDef.Delegate conDef = (ConDef.Delegate)conDefLike2;
                    yield ((ConDef)conDef.core()).toDoc(options);
                }
            }));
            docArray[2] = Doc.english((String)"because I got stuck on the index unification of type");
            docArray[3] = Doc.par((int)1, (Doc)this.dataCall.toDoc(options));
            return Doc.vcat((Doc[])docArray);
        }
    }

    public record MissingCase(@NotNull SourcePos sourcePos, @NotNull ImmutableSeq<? extends PatClass.Seq<Term, ?>> errs) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc cases = Doc.vcat((SeqLike)this.errs.map(err -> BasePrettier.coreArgsDoc((PrettierOptions)options, (SeqView)err.term().view())));
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Unhandled case:"), Doc.nest((int)2, (Doc)cases)});
        }
    }

    public record Confluence(@NotNull SourcePos sourcePos, int i, int j, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info, @NotNull SourcePos iPos, @NotNull SourcePos jPos) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc line = Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"and the"), Doc.ordinal((int)this.j), Doc.english((String)"clauses are not confluent because we failed to unify")});
            return this.info.describeUnify(options, this.comparison, line, Doc.plain((String)"and"));
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            return Seq.of((Object)new WithPos(this.iPos, (Object)ClausesProblem.termToHint(this.comparison.expected(), options)), (Object)new WithPos(this.jPos, (Object)ClausesProblem.termToHint(this.comparison.actual(), options))).view();
        }
    }

    public record Conditions(@NotNull SourcePos sourcePos, @NotNull SourcePos iPos, int i, @NotNull ImmutableSeq<Term> args, @NotNull UnifyInfo info, @NotNull UnifyInfo.Comparison comparison) implements ClausesProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc begin = Doc.sep((Doc[])new Doc[]{Doc.plain((String)"The"), Doc.ordinal((int)this.i), Doc.english((String)"clause matches on a path constructor. We failed to unify")});
            Doc[] docArray = new Doc[5];
            docArray[0] = this.info.describeUnify(options, this.comparison, begin, Doc.plain((String)"with"));
            docArray[1] = Doc.english((String)"for the arguments:");
            docArray[2] = Doc.par((int)1, (Doc)BasePrettier.coreArgsDoc((PrettierOptions)options, (SeqView)this.args.view()));
            docArray[3] = Doc.english((String)"Normalized:");
            docArray[4] = Doc.par((int)1, (Doc)BasePrettier.coreArgsDoc((PrettierOptions)options, (SeqView)this.args.view().map(this.info::fullNormalize)));
            return Doc.vcat((Doc[])docArray);
        }

        @NotNull
        public SeqView<WithPos<Doc>> inlineHints(@NotNull PrettierOptions options) {
            Doc data = ClausesProblem.termToHint(this.comparison.actual(), options);
            return SeqView.of((Object)new WithPos(this.iPos, (Object)data));
        }
    }
}

