/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableMap;
import org.aya.pretty.doc.Doc;
import org.aya.syntax.core.Jdg;
import org.aya.syntax.core.term.ErrorTerm;
import org.aya.syntax.core.term.FreeTerm;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.MetaCall;
import org.aya.syntax.ref.LocalCtx;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.ref.MetaVar;
import org.aya.tyck.TyckState;
import org.aya.tyck.tycker.Stateful;
import org.aya.util.PrettierOptions;
import org.aya.util.position.SourcePos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Goal(@NotNull TyckState state, @NotNull MetaCall hole, @Nullable Jdg filling, @NotNull LocalCtx ctx, @NotNull ImmutableSeq<LocalVar> scope) implements Problem,
Stateful
{
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Doc describe(@NotNull PrettierOptions options) {
        ErrorTerm errorTerm;
        MetaVar meta = this.hole.ref();
        MetaVar.Requirement requirement = meta.req();
        if (requirement instanceof MetaVar.OfType) {
            Term type;
            MetaVar.OfType ofType = (MetaVar.OfType)requirement;
            try {
                Term term;
                type = term = ofType.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            errorTerm = this.freezeHoles(MetaCall.appType((MetaCall)this.hole, (Term)type));
        } else {
            errorTerm = new ErrorTerm(prettierOptions -> Doc.plain((String)"???"));
        }
        ErrorTerm result = errorTerm;
        MutableList lines = MutableList.of((Object)Doc.english((String)"Goal of type"), (Object)Doc.par((int)1, (Doc)result.toDoc(options)), (Object)Doc.par((int)1, (Doc)Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.plain((String)"Normalized:"), this.fullNormalize((Term)result).toDoc(options)}))), (Object)Doc.plain((String)"Context:"), (Object)Doc.vcat((SeqLike)this.hole.args().map(arg -> this.renderScopeVar(options, (Term)arg))));
        MutableMap<MetaVar, Term> metas = this.state.solutions;
        if (metas.containsKey((Object)meta)) {
            lines.insert(0, (Object)Doc.par((int)1, (Doc)((Term)metas.get((Object)meta)).toDoc(options)));
            lines.insert(0, (Object)Doc.plain((String)"Candidate exists:"));
        }
        if (this.filling != null) {
            lines.append((Object)Doc.english((String)"You are trying:"));
            lines.append((Object)Doc.par((int)1, (Doc)this.filling.wellTyped().toDoc(options)));
            lines.append((Object)Doc.english((String)"It has type:"));
            lines.append((Object)Doc.par((int)1, (Doc)this.filling.type().toDoc(options)));
        }
        return Doc.vcatNonEmpty((SeqLike)lines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private Doc renderScopeVar(@NotNull PrettierOptions options, Term arg) {
        LocalVar ref;
        Doc paramDoc = this.freezeHoles(arg).toDoc(options);
        if (!(arg instanceof FreeTerm)) return Doc.par((int)1, (Doc)paramDoc);
        FreeTerm freeTerm = (FreeTerm)arg;
        try {
            LocalVar localVar;
            ref = localVar = freeTerm.name();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (this.ctx.contains((Object)ref)) {
            paramDoc = Doc.sep((Doc[])new Doc[]{paramDoc, Doc.symbol((String)":"), ((Term)this.ctx.get((Object)ref)).toDoc(options)});
        }
        if (this.scope.contains((Object)ref)) return Doc.par((int)1, (Doc)paramDoc);
        paramDoc = Doc.sep((Doc[])new Doc[]{paramDoc, Doc.parened((Doc)Doc.english((String)"not in scope"))});
        return Doc.par((int)1, (Doc)paramDoc);
    }

    @NotNull
    public SourcePos sourcePos() {
        return this.hole.ref().pos();
    }

    @NotNull
    public Problem.Severity level() {
        return Problem.Severity.GOAL;
    }

    @NotNull
    public Problem.Stage stage() {
        return Problem.Stage.TYCK;
    }
}

