/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import kala.collection.SeqLike;
import kala.collection.mutable.MutableList;
import org.aya.prettier.BasePrettier;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Style;
import org.aya.syntax.concrete.Pattern;
import org.aya.syntax.core.def.AnyDef;
import org.aya.syntax.core.term.Param;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.ConCallLike;
import org.aya.syntax.core.term.call.DataCall;
import org.aya.tyck.tycker.Stateful;
import org.aya.util.PrettierOptions;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.aya.util.reporter.Problem;
import org.jetbrains.annotations.NotNull;

public sealed interface PatternProblem
extends Problem {
    @NotNull
    public WithPos<? extends Pattern> pattern();

    @NotNull
    default public SourcePos sourcePos() {
        return this.pattern().sourcePos();
    }

    @NotNull
    default public Problem.Severity level() {
        return Problem.Severity.ERROR;
    }

    public record InvalidEmptyBody(@NotNull Pattern.Clause match) implements Problem
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.match.sourcePos;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.english((String)"This match arm does not contain any absurd pattern but it has an empty body");
        }

        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.ERROR;
        }
    }

    public record BadLitPattern(@NotNull WithPos<Pattern> pattern, @NotNull Term type) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The literal"), Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options)), Doc.english((String)"cannot be encoded as a term of type:"), Doc.par((int)1, (Doc)this.type.toDoc(options))});
        }
    }

    public record TooManyImplicitPattern(@NotNull WithPos<Pattern> pattern, @NotNull Param param) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"There are too many implicit patterns:"), Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options)), Doc.english((String)"should be an explicit pattern matched against"), Doc.par((int)1, (Doc)this.param.toDoc(options))});
        }
    }

    public record UnimportedConName(@NotNull WithPos<Pattern.Bind> pattern) implements PatternProblem
    {
        @Override
        @NotNull
        public Problem.Severity level() {
            return Problem.Severity.WARN;
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"You wrote the following pattern:"), Doc.par((int)1, (Doc)Doc.plain((String)((Pattern.Bind)this.pattern.data()).bind().name())), Doc.english((String)"It sounds like you are trying to match with a constructor that is not in scope, so it will be treated as a variable pattern.")});
        }
    }

    public record ImplicitDisallowed(@NotNull WithPos<Pattern> pattern) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Pattern matching with"), Doc.styled((Style)BasePrettier.KEYWORD, (String)"elim"), Doc.english((String)"is not compatible with implicit patterns.")});
        }
    }

    public record InsufficientPattern(@NotNull WithPos<Pattern> pattern, @NotNull Param param) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"There is no pattern for the parameter"), Doc.par((int)1, (Doc)this.param.toDoc(options))});
        }
    }

    public record TooManyPattern(@NotNull WithPos<Pattern> pattern) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"There is no parameter for the pattern"), Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options)), Doc.english((String)"to match against."), Doc.parened((Doc)Doc.sep((Doc[])new Doc[]{Doc.english((String)"and in case it's a function type, you may want to move its parameters before the"), Doc.code((String)":"), Doc.english((String)"in the signature")}))});
        }
    }

    public record TupleNonSig(@NotNull WithPos<Pattern> pattern, @NotNull Stateful stateful, @NotNull Term type) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc typeDoc = this.type.toDoc(options);
            MutableList lines = MutableList.of((Object)Doc.english((String)"The tuple pattern"), (Object)Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options)), (Object)Doc.english((String)"splits only on sigma types, while the actual type is not:"), (Object)Doc.par((int)1, (Doc)typeDoc));
            Doc normalizedDoc = this.stateful.fullNormalize(this.type).toDoc(options);
            if (!typeDoc.equals((Object)normalizedDoc)) {
                lines.append((Object)Doc.english((String)"Normalized:"));
                lines.append((Object)Doc.par((int)1, (Doc)normalizedDoc));
            }
            return Doc.vcat((SeqLike)lines);
        }
    }

    public record UnknownCon(@NotNull WithPos<Pattern> pattern) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Unknown constructor"), Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options))});
        }
    }

    public record UnavailableCon(@NotNull WithPos<Pattern> pattern, @NotNull DataCall dataCall) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"I'm unsure if there should be a case for"), Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options)), Doc.english((String)"as index unification is blocked for type"), Doc.par((int)1, (Doc)this.dataCall.toDoc(options))});
        }
    }

    public record SplittingOnNonData(@NotNull WithPos<Pattern> pattern, @NotNull Term type) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot split on a non-inductive type"), Doc.par((int)1, (Doc)this.type.toDoc(options)), Doc.english((String)"with a constructor pattern"), Doc.par((int)1, (Doc)((Pattern)this.pattern.data()).toDoc(options))});
        }
    }

    public record PossiblePat(@NotNull WithPos<Pattern> pattern, @NotNull ConCallLike.Head available) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.sep((Doc[])new Doc[]{Doc.english((String)"Absurd pattern does not fit here because"), Doc.code((Doc)BasePrettier.refVar((AnyDef)this.available.ref())), Doc.english((String)"is still available")});
        }
    }

    public record BlockedEval(@NotNull WithPos<Pattern> pattern, @NotNull DataCall dataCall) implements PatternProblem
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Unsure if this pattern is actually impossible, as constructor selection is blocked on:"), Doc.par((int)1, (Doc)this.dataCall.toDoc(options))});
        }
    }
}

