/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.error;

import org.aya.pretty.doc.Doc;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.core.term.SortTerm;
import org.aya.syntax.core.term.Term;
import org.aya.tyck.error.TyckError;
import org.aya.tyck.error.UnifyInfo;
import org.aya.util.PrettierOptions;
import org.aya.util.position.SourcePos;
import org.jetbrains.annotations.NotNull;

public sealed interface UnifyError
extends TyckError {

    public record PiDom(@NotNull Expr expr, @NotNull SourcePos sourcePos, Term result, SortTerm sort) implements UnifyError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            return Doc.vcat((Doc[])new Doc[]{Doc.english((String)"The type"), Doc.par((int)1, (Doc)this.result.toDoc(options)), Doc.english((String)"is in the domain of a function whose type is"), Doc.par((int)1, (Doc)this.sort.toDoc(options))});
        }
    }

    public record ConReturn(@NotNull DataCon con, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info) implements UnifyError
    {
        @NotNull
        public SourcePos sourcePos() {
            return this.con.sourcePos();
        }

        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot make sense of the return type of the constructor"), Doc.par((int)1, (Doc)this.con.toDoc(options)), Doc.english((String)"which eventually returns")});
            return this.info.describeUnify(options, this.comparison, prologue, Doc.english((String)"while it should return"));
        }
    }

    public record Type(@NotNull Expr expr, @NotNull SourcePos sourcePos, @NotNull UnifyInfo.Comparison comparison, @NotNull UnifyInfo info) implements UnifyError
    {
        @NotNull
        public Doc describe(@NotNull PrettierOptions options) {
            Doc prologue = Doc.vcat((Doc[])new Doc[]{Doc.english((String)"Cannot check the expression"), Doc.par((int)1, (Doc)this.expr.toDoc(options)), Doc.english((String)"of type")});
            return this.info.describeUnify(options, this.comparison, prologue, Doc.english((String)"against the type"));
        }
    }
}

