/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.order;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import kala.collection.Set;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSet;
import org.aya.generic.InterruptException;
import org.aya.generic.Modifier;
import org.aya.generic.stmt.TyckOrder;
import org.aya.generic.stmt.TyckUnit;
import org.aya.resolve.ResolveInfo;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.concrete.stmt.decl.FnBody;
import org.aya.syntax.concrete.stmt.decl.FnDecl;
import org.aya.syntax.concrete.stmt.decl.TeleDecl;
import org.aya.syntax.core.def.FnDef;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.core.term.call.Callable;
import org.aya.syntax.ref.DefVar;
import org.aya.terck.BadRecursion;
import org.aya.terck.CallResolver;
import org.aya.tyck.StmtTycker;
import org.aya.tyck.error.TyckOrderError;
import org.aya.tyck.tycker.Problematic;
import org.aya.util.Panic;
import org.aya.util.reporter.CountingReporter;
import org.aya.util.reporter.Reporter;
import org.aya.util.terck.CallGraph;
import org.aya.util.terck.Diagonal;
import org.aya.util.terck.MutableGraph;
import org.aya.util.tyck.SccTycker;
import org.jetbrains.annotations.NotNull;

public final class AyaSccTycker
extends Record
implements SccTycker<TyckOrder, SccTyckingFailed>,
Problematic {
    @NotNull
    private final StmtTycker tycker;
    @NotNull
    private final CountingReporter reporter;
    @NotNull
    private final ResolveInfo resolveInfo;
    @NotNull
    private final @NotNull MutableList<@NotNull TyckDef> wellTyped;

    public AyaSccTycker(@NotNull StmtTycker tycker, @NotNull CountingReporter reporter, @NotNull ResolveInfo resolveInfo, @NotNull @NotNull MutableList<@NotNull TyckDef> wellTyped) {
        this.tycker = tycker;
        this.reporter = reporter;
        this.resolveInfo = resolveInfo;
        this.wellTyped = wellTyped;
    }

    @NotNull
    public static AyaSccTycker create(ResolveInfo info, @NotNull Reporter outReporter) {
        CountingReporter counting = CountingReporter.delegate((Reporter)outReporter);
        StmtTycker stmt = new StmtTycker((Reporter)counting, info.modulePath(), info.shapeFactory(), info.primFactory());
        return new AyaSccTycker(stmt, counting, info, (MutableList<TyckDef>)MutableList.create());
    }

    @NotNull
    public ImmutableSeq<TyckOrder> tyckSCC(@NotNull ImmutableSeq<TyckOrder> scc) throws SccTyckingFailed {
        try {
            if (scc.isEmpty()) {
                return ImmutableSeq.empty();
            }
            if (scc.sizeEquals(1)) {
                this.checkUnit((TyckOrder)scc.getFirst());
            } else {
                this.checkMutual(scc);
            }
            return ImmutableSeq.empty();
        }
        catch (SccTyckingFailed failed) {
            this.reporter.clear();
            return failed.what;
        }
    }

    private void checkMutual(@NotNull ImmutableSeq<TyckOrder> scc) {
        ImmutableSeq heads = scc.filterIsInstance(TyckOrder.Head.class);
        if (heads.sizeGreaterThanOrEquals(2)) {
            this.fail(new TyckOrderError.CircularSignature((ImmutableSeq<TyckUnit>)heads.map(TyckOrder.Head::unit)));
            throw new SccTyckingFailed(scc);
        }
        throw new Panic("This place is in theory unreachable, we need to investigate if it is reached");
    }

    private void check(@NotNull TyckOrder tyckOrder) {
        TyckOrder tyckOrder2 = tyckOrder;
        Objects.requireNonNull(tyckOrder2);
        TyckOrder tyckOrder3 = tyckOrder2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TyckOrder.Head.class, TyckOrder.Body.class}, (TyckOrder)tyckOrder3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                TyckOrder.Head head = (TyckOrder.Head)tyckOrder3;
                this.checkHeader(tyckOrder, head.unit());
                break;
            }
            case 1: {
                TyckOrder.Body body = (TyckOrder.Body)tyckOrder3;
                this.checkBody(tyckOrder, body.unit());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkUnit(@NotNull TyckOrder order) {
        TyckUnit tyckUnit = order.unit();
        if (tyckUnit instanceof FnDecl) {
            FnDecl fn = (FnDecl)tyckUnit;
            if (fn.body instanceof FnBody.ExprBody) {
                if (this.selfReferencing(this.resolveInfo.depGraph(), order)) {
                    this.fail(new BadRecursion(fn.sourcePos(), fn.ref, null));
                    throw new SccTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
                }
                this.check((TyckOrder)new TyckOrder.Body((TyckUnit)fn));
                return;
            }
        }
        this.check(order);
        if (!(order instanceof TyckOrder.Body)) return;
        TyckOrder.Body body = (TyckOrder.Body)order;
        this.terck((ImmutableSeq<TyckOrder.Body>)ImmutableSeq.of((Object)body));
    }

    private void terck(@NotNull ImmutableSeq<TyckOrder.Body> units) {
        ImmutableSeq recDefs = units.view().filter(u -> this.selfReferencing(this.resolveInfo.depGraph(), (TyckOrder)u)).map(TyckOrder::unit).toSeq();
        if (recDefs.isEmpty()) {
            return;
        }
        ImmutableSeq fn = recDefs.view().filterIsInstance(FnDecl.class).filterNot(f -> f.modifiers.contains(Modifier.NonTerminating)).map(f -> (FnDef)f.ref.core).toSeq();
        this.terckRecursiveFn((ImmutableSeq<FnDef>)fn);
    }

    private void terckRecursiveFn(@NotNull ImmutableSeq<FnDef> fn) {
        MutableSet targets = MutableSet.from(fn);
        if (targets.isEmpty()) {
            return;
        }
        CallGraph graph = CallGraph.create();
        fn.forEach(def -> new CallResolver(this.resolveInfo.makeTyckState(), (FnDef)def, (Set<TyckDef>)targets, (CallGraph<Callable.Tele, TyckDef>)graph).check());
        graph.findBadRecursion().view().sorted(Comparator.comparing(a -> AyaSccTycker.domRef(a).concrete.sourcePos())).forEach(f -> {
            DefVar<?, ?> ref = AyaSccTycker.domRef(f);
            TyckDef patt0$temp = ref.core;
            if (patt0$temp instanceof FnDef) {
                FnDef fnDef = (FnDef)patt0$temp;
                fnDef.modifiers().add(Modifier.NonTerminating);
                fnDef.modifiers().add(Modifier.Opaque);
            }
            this.fail(new BadRecursion(ref.concrete.sourcePos(), ref, (Diagonal<? extends Term, TyckDef>)f));
        });
    }

    @NotNull
    private static DefVar<?, ?> domRef(Diagonal<?, TyckDef> f) {
        return ((TyckDef)f.matrix().domain()).ref();
    }

    private void checkHeader(@NotNull TyckOrder order, @NotNull TyckUnit stmt) {
        if (stmt instanceof TeleDecl) {
            TeleDecl decl = (TeleDecl)stmt;
            this.tycker.checkHeader(decl);
        }
        if (this.reporter.anyError()) {
            throw new SccTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
    }

    private void checkBody(@NotNull TyckOrder order, @NotNull TyckUnit stmt) {
        if (stmt instanceof Decl) {
            Decl decl = (Decl)stmt;
            TyckDef def = this.tycker.check(decl);
            if (!decl.isExample && def != null) {
                this.wellTyped.append((Object)def);
                this.tycker.shapeFactory().bonjour(def);
            }
        }
        if (this.reporter.anyError()) {
            throw new SccTyckingFailed((ImmutableSeq<TyckOrder>)ImmutableSeq.of((Object)order));
        }
    }

    private boolean hasSuc(@NotNull MutableGraph<TyckOrder> G, @NotNull MutableSet<TyckUnit> book, @NotNull TyckOrder vertex, @NotNull TyckOrder suc) {
        if (book.contains((Object)vertex.unit())) {
            return false;
        }
        book.add((Object)vertex.unit());
        for (TyckOrder test : G.suc((Object)vertex)) {
            if (test.unit() == suc.unit()) {
                return true;
            }
            if (!this.hasSuc(G, book, test, suc)) continue;
            return true;
        }
        if (vertex instanceof TyckOrder.Head) {
            TyckOrder.Head head = (TyckOrder.Head)vertex;
            return this.hasSuc(G, book, (TyckOrder)head.toBody(), suc);
        }
        return false;
    }

    private boolean selfReferencing(@NotNull MutableGraph<TyckOrder> graph, @NotNull TyckOrder unit) {
        return this.hasSuc(graph, (MutableSet<TyckUnit>)MutableSet.create(), unit, unit);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AyaSccTycker.class, "tycker;reporter;resolveInfo;wellTyped", "tycker", "reporter", "resolveInfo", "wellTyped"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AyaSccTycker.class, "tycker;reporter;resolveInfo;wellTyped", "tycker", "reporter", "resolveInfo", "wellTyped"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AyaSccTycker.class, "tycker;reporter;resolveInfo;wellTyped", "tycker", "reporter", "resolveInfo", "wellTyped"}, this, o);
    }

    @NotNull
    public StmtTycker tycker() {
        return this.tycker;
    }

    @NotNull
    public CountingReporter reporter() {
        return this.reporter;
    }

    @NotNull
    public ResolveInfo resolveInfo() {
        return this.resolveInfo;
    }

    @NotNull
    public @NotNull MutableList<@NotNull TyckDef> wellTyped() {
        return this.wellTyped;
    }

    public static class SccTyckingFailed
    extends InterruptException {
        @NotNull
        public final ImmutableSeq<TyckOrder> what;

        public SccTyckingFailed(@NotNull ImmutableSeq<TyckOrder> what) {
            this.what = what;
        }

        public InterruptException.InterruptStage stage() {
            return InterruptException.InterruptStage.Tycking;
        }
    }
}

