/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.pat.iter;

import java.util.Iterator;
import java.util.Objects;
import org.aya.tyck.pat.iter.Pusheenable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PusheenIterator<T, R>
implements Pusheenable<T, Pusheenable<T, R>> {
    protected final Iterator<T> iter;
    @Nullable
    protected T peek;
    @NotNull
    protected final Pusheenable<T, R> cat;
    protected boolean fromPusheen = false;

    public PusheenIterator(Iterator<T> iter, @NotNull Pusheenable<T, R> cat) {
        this.iter = iter;
        this.cat = cat;
    }

    @Override
    public boolean hasNext() {
        return this.peek != null || this.iter.hasNext() || this.cat.hasNext();
    }

    @Override
    @NotNull
    public T peek() {
        if (this.peek != null) {
            return this.peek;
        }
        if (this.iter.hasNext()) {
            this.peek = this.postDoPeek(this.iter.next());
            return this.peek;
        }
        T realPeek = this.postDoPeek(Objects.requireNonNull(this.cat).peek());
        this.peek = realPeek;
        this.fromPusheen = true;
        return realPeek;
    }

    @NotNull
    protected T postDoPeek(@NotNull T peeked) {
        return peeked;
    }

    @Override
    public T next() {
        if (this.peek == null) {
            this.peek();
        }
        if (this.fromPusheen) {
            this.cat.next();
        }
        T result = this.peek;
        this.peek = null;
        return result;
    }

    @Override
    @NotNull
    public Pusheenable<T, R> body() {
        return this.cat;
    }

    public boolean isFromPusheen() {
        return this.fromPusheen;
    }
}

