/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.aya.normalize.Finalizer;
import org.aya.normalize.Normalizer;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.literate.CodeOptions;
import org.aya.syntax.ref.MetaVar;
import org.aya.tyck.TyckState;
import org.jetbrains.annotations.NotNull;

public interface Stateful {
    @NotNull
    public TyckState state();

    @NotNull
    default public Term whnf(@NotNull Term term) {
        return new Normalizer(this.state()).apply(term);
    }

    default public void solve(MetaVar meta, Term solution) {
        this.state().solve(meta, solution);
    }

    @NotNull
    default public Term freezeHoles(@NotNull Term term) {
        return new Finalizer.Freeze(this).zonk(term);
    }

    @NotNull
    default public Term fullNormalize(Term result) {
        return new Normalizer(this.state()).normalize(result, CodeOptions.NormalizeMode.FULL);
    }

    default public <R> R withConnection(@NotNull Term lhs, @NotNull Term rhs, @NotNull Supplier<R> action) {
        this.state().connect(lhs, rhs);
        R result = action.get();
        this.state().disconnect(lhs, rhs);
        return result;
    }

    default public boolean withConnection(@NotNull Term lhs, @NotNull Term rhs, @NotNull BooleanSupplier action) {
        this.state().connect(lhs, rhs);
        boolean result = action.getAsBoolean();
        this.state().disconnect(lhs, rhs);
        return result;
    }
}

