/*
 * Decompiled with CFR 0.152.
 */
package org.aya.tyck.tycker;

import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSeq;
import org.aya.normalize.Finalizer;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.core.Jdg;
import org.aya.syntax.core.term.Param;
import org.aya.syntax.core.term.SortTerm;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.ref.LocalCtx;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.telescope.AbstractTele;
import org.aya.syntax.telescope.Signature;
import org.aya.tyck.ExprTycker;
import org.aya.tyck.error.UnifyError;
import org.aya.tyck.tycker.Contextful;
import org.aya.unify.Synthesizer;
import org.aya.util.position.SourcePos;
import org.aya.util.position.WithPos;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface TeleTycker
extends Contextful {
    @NotNull
    public Term checkType(@NotNull WithPos<Expr> var1, boolean var2);

    public void addWithTerm(@NotNull Expr.WithTerm var1, @NotNull SourcePos var2, @NotNull Term var3);

    @Contract(pure=true)
    @NotNull
    default public Signature checkSignature(@NotNull ImmutableSeq<Expr.Param> cTele, @NotNull WithPos<Expr> result) {
        ImmutableSeq locals = cTele.view().map(Expr.Param::ref).toSeq();
        ImmutableSeq<Param> checkedParam = this.checkTele(cTele);
        Term checkedResult = this.checkType(result, true).bindTele(locals.view());
        return new Signature(new AbstractTele.Locns(checkedParam, checkedResult), cTele.map(Expr.Param::sourcePos));
    }

    @NotNull
    default public ImmutableSeq<Param> checkTele(@NotNull ImmutableSeq<Expr.Param> cTele) {
        MutableSeq<Param> tele = this.checkTeleFree(cTele);
        ImmutableSeq locals = cTele.map(Expr.Param::ref);
        AbstractTele.bindTele((Seq)locals, tele);
        return tele.toSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public MutableSeq<Param> checkTeleFree(ImmutableSeq<Expr.Param> cTele) {
        return MutableSeq.from((Iterable)cTele.view().map(p -> {
            Term pTy = this.checkType((WithPos<Expr>)p.typeExpr(), false);
            this.addWithTerm((Expr.WithTerm)p, p.sourcePos(), pTy);
            this.localCtx().put((Object)p.ref(), (Object)pTy);
            return new Param(p.ref().name(), pTy, p.explicit());
        }));
    }

    @Contract(mutates="param3")
    public static void loadTele(@NotNull SeqView<LocalVar> binds, @NotNull Signature signature, @NotNull ExprTycker tycker) {
        if (!1.$assertionsDisabled && !binds.sizeEquals(signature.telescope().telescopeSize())) {
            throw new AssertionError();
        }
        MutableList tele = MutableList.create();
        binds.forEachWith((Iterable)signature.params(), (ref, param) -> {
            tycker.localCtx().put(ref, (Object)param.type().instTeleVar(tele.view()));
            tele.append(ref);
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record Con(@NotNull ExprTycker tycker, @NotNull SortTerm dataResult) implements Impl
    {
        @Override
        @NotNull
        public Term checkType(@NotNull WithPos<Expr> typeExpr, boolean isResult) {
            Term result = this.tycker.ty(typeExpr);
            if (!new Synthesizer(this.tycker).inheritPiDom(result, this.dataResult)) {
                this.tycker.fail(new UnifyError.PiDom((Expr)typeExpr.data(), typeExpr.sourcePos(), result, this.dataResult));
            }
            return result;
        }

        @Override
        public void addWithTerm(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull Expr.WithTerm with, @NotNull SourcePos pos, @NotNull Term type) {
            this.tycker.addWithTerm(with, pos, type);
        }
    }

    public static final class InlineCode
    implements Impl {
        @NotNull
        private final ExprTycker tycker;
        public Jdg result;

        public InlineCode(@NotNull ExprTycker tycker) {
            this.tycker = tycker;
        }

        @NotNull
        public Jdg checkInlineCode(@NotNull ImmutableSeq<Expr.Param> params, @NotNull WithPos<Expr> expr) {
            this.checkSignature(params, expr);
            this.tycker.solveMetas();
            Finalizer.Zonk<ExprTycker> zonker = new Finalizer.Zonk<ExprTycker>(this.tycker);
            return this.result.map(zonker::zonk);
        }

        @Override
        @NotNull
        public Term checkType(@NotNull WithPos<Expr> typeExpr, boolean isResult) {
            Jdg jdg;
            if (!isResult) {
                return this.tycker.ty(typeExpr);
            }
            this.result = jdg = this.tycker.synthesize(typeExpr);
            return jdg.wellTyped();
        }

        @Override
        public void addWithTerm(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull Expr.WithTerm with, @NotNull SourcePos pos, @NotNull Term type) {
            this.tycker.addWithTerm(with, pos, type);
        }

        @Override
        @NotNull
        public ExprTycker tycker() {
            return this.tycker;
        }
    }

    public record Default(@NotNull ExprTycker tycker) implements Impl
    {
        @Override
        @NotNull
        public Term checkType(@NotNull WithPos<Expr> typeExpr, boolean isResult) {
            return this.tycker.ty(typeExpr);
        }

        @Override
        public void addWithTerm(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull Expr.WithTerm with, @NotNull SourcePos pos, @NotNull Term type) {
            this.tycker.addWithTerm(with, pos, type);
        }
    }

    public static sealed interface Impl
    extends TeleTycker
    permits Default, InlineCode, Con {
        @NotNull
        public ExprTycker tycker();

        @Override
        @NotNull
        default public LocalCtx localCtx() {
            return this.tycker().localCtx();
        }

        @Override
        @NotNull
        default public LocalCtx setLocalCtx(@NotNull LocalCtx ctx) {
            return this.tycker().setLocalCtx(ctx);
        }
    }
}

