/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide.action;

import java.util.function.Function;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.ide.Resolver;
import org.aya.ide.action.GotoDefinition;
import org.aya.ide.util.XY;
import org.aya.ref.AnyVar;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;

public interface FindReferences {
    @NotNull
    public static SeqView<SourcePos> findRefs(@NotNull LibrarySource source, @NotNull SeqView<LibraryOwner> libraries, XY xy) {
        SeqView<WithPos<AnyVar>> vars = Resolver.resolveVar(source, xy);
        return FindReferences.findRefs((SeqView<AnyVar>)vars.map(WithPos::data), libraries);
    }

    @NotNull
    public static SeqView<SourcePos> findRefs(@NotNull SeqView<AnyVar> vars, @NotNull SeqView<LibraryOwner> libraries) {
        return vars.flatMap(var -> {
            Resolver.UsageResolver resolver = new Resolver.UsageResolver((AnyVar)var);
            return libraries.flatMap(lib -> FindReferences.resolve(resolver, lib));
        });
    }

    @NotNull
    public static SeqView<SourcePos> findOccurrences(@NotNull LibrarySource source, @NotNull SeqView<LibraryOwner> libraries, XY xy) {
        SeqView defs = GotoDefinition.findDefs(source, libraries, xy).map(WithPos::data);
        SeqView<SourcePos> refs = FindReferences.findRefs(source, libraries, xy);
        return defs.concat(refs);
    }

    @NotNull
    private static SeqView<SourcePos> resolve(@NotNull Resolver.UsageResolver resolver, @NotNull LibraryOwner owner) {
        return owner.librarySources().map(src -> (ImmutableSeq)src.program().get()).filterNotNull().flatMap(prog -> prog.view().flatMap((Function)((Object)resolver))).concat((SeqLike)owner.libraryDeps().flatMap(dep -> FindReferences.resolve(resolver, dep)));
    }
}

