/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide.action;

import java.util.function.BiFunction;
import org.aya.cli.library.source.LibrarySource;
import org.aya.concrete.Expr;
import org.aya.core.def.PrimDef;
import org.aya.core.term.Term;
import org.aya.generic.util.NormalizeMode;
import org.aya.ide.syntax.SyntaxNodeAction;
import org.aya.ide.util.XY;
import org.aya.tyck.Result;
import org.aya.tyck.tycker.TyckState;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComputeTerm
implements SyntaxNodeAction.Cursor {
    @Nullable
    public WithPos<Term> result = null;
    @NotNull
    private final LibrarySource source;
    @NotNull
    private final Kind kind;
    @NotNull
    private final PrimDef.Factory primFactory;
    @NotNull
    private final XY location;

    @Override
    @NotNull
    public XY location() {
        return this.location;
    }

    public ComputeTerm(@NotNull LibrarySource source, @NotNull Kind kind, @NotNull PrimDef.Factory primFactory, @NotNull XY location) {
        this.source = source;
        this.kind = kind;
        this.primFactory = primFactory;
        this.location = location;
    }

    @NotNull
    public Expr pre(@NotNull Expr expr) {
        Expr.WithTerm withTerm;
        Result core;
        if (expr instanceof Expr.WithTerm && (core = (withTerm = (Expr.WithTerm)expr).core()) != null) {
            this.result = new WithPos(withTerm.sourcePos(), (Object)this.kind.map.apply(this.primFactory, core));
        }
        return SyntaxNodeAction.Cursor.super.pre(expr);
    }

    public record Kind(@NotNull BiFunction<PrimDef.Factory, Result, Term> map) {
        @NotNull
        public static Kind type() {
            return new Kind((fac, term) -> term.type());
        }

        @NotNull
        public static Kind id() {
            return new Kind((fac, term) -> term.wellTyped());
        }

        @NotNull
        public static Kind nf() {
            return new Kind((fac, term) -> term.wellTyped().normalize(new TyckState(fac), NormalizeMode.NF));
        }

        @NotNull
        public static Kind whnf() {
            return new Kind((fac, term) -> term.wellTyped().normalize(new TyckState(fac), NormalizeMode.WHNF));
        }
    }
}

