/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide.action;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Consumer;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.source.LibrarySource;
import org.aya.concrete.Pattern;
import org.aya.core.term.Term;
import org.aya.ide.syntax.SyntaxNodeAction;
import org.aya.ide.util.XYXY;
import org.aya.pretty.doc.Doc;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;

public final class InlayHints
extends Record
implements SyntaxNodeAction.Ranged {
    @NotNull
    private final PrettierOptions options;
    @NotNull
    private final XYXY location;
    @NotNull
    private final MutableList<Hint> hints;

    public InlayHints(@NotNull PrettierOptions options, @NotNull XYXY location, @NotNull MutableList<Hint> hints) {
        this.options = options;
        this.location = location;
        this.hints = hints;
    }

    @NotNull
    public static ImmutableSeq<Hint> invoke(@NotNull PrettierOptions options, @NotNull LibrarySource source, @NotNull XYXY range) {
        ImmutableSeq program = (ImmutableSeq)source.program().get();
        if (program == null) {
            return ImmutableSeq.empty();
        }
        InlayHints maker = new InlayHints(options, range, (MutableList<Hint>)MutableList.create());
        program.forEach((Consumer)((Object)maker));
        return maker.hints.toImmutableSeq();
    }

    @NotNull
    public Pattern pre(@NotNull Pattern pattern) {
        Pattern.Bind bind;
        Object object;
        if (pattern instanceof Pattern.Bind && (object = (bind = (Pattern.Bind)pattern).type().get()) instanceof Term) {
            Term term = (Term)object;
            Doc type = Doc.sep((Doc[])new Doc[]{Doc.symbol((String)":"), term.toDoc(this.options)});
            this.hints.append((Object)new Hint(bind.sourcePos(), type, true));
        }
        return SyntaxNodeAction.Ranged.super.pre(pattern);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{InlayHints.class, "options;location;hints", "options", "location", "hints"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InlayHints.class, "options;location;hints", "options", "location", "hints"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InlayHints.class, "options;location;hints", "options", "location", "hints"}, this, o);
    }

    @NotNull
    public PrettierOptions options() {
        return this.options;
    }

    @Override
    @NotNull
    public XYXY location() {
        return this.location;
    }

    @NotNull
    public MutableList<Hint> hints() {
        return this.hints;
    }

    public record Hint(@NotNull SourcePos sourcePos, @NotNull Doc doc, boolean isType) {
    }
}

