/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide.action;

import java.util.function.Consumer;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.cli.literate.HighlightInfo;
import org.aya.cli.literate.SyntaxHighlight;
import org.aya.concrete.stmt.Stmt;
import org.aya.concrete.stmt.decl.Decl;
import org.aya.ide.Resolver;
import org.aya.ide.action.ComputeSignature;
import org.aya.ide.syntax.SyntaxDeclAction;
import org.aya.pretty.doc.Doc;
import org.aya.ref.DefVar;
import org.aya.util.error.SourcePos;
import org.aya.util.prettier.PrettierOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ProjectSymbol(@NotNull PrettierOptions options, @NotNull MutableList<Symbol> symbols) implements SyntaxDeclAction
{
    @NotNull
    public static ImmutableSeq<Symbol> invoke(@NotNull PrettierOptions options, @NotNull LibrarySource source) {
        ProjectSymbol symbol = new ProjectSymbol(options, (MutableList<Symbol>)MutableList.create());
        symbol.collectSource(source);
        return symbol.symbols.toImmutableSeq();
    }

    @NotNull
    public static ImmutableSeq<Symbol> invoke(@NotNull PrettierOptions options, @NotNull SeqView<LibraryOwner> libraries) {
        ProjectSymbol symbol = new ProjectSymbol(options, (MutableList<Symbol>)MutableList.create());
        libraries.forEach(symbol::collectLib);
        return symbol.symbols.toImmutableSeq();
    }

    private void collectLib(@NotNull LibraryOwner owner) {
        owner.librarySources().forEach(this::collectSource);
        owner.libraryDeps().forEach(this::collectLib);
    }

    private void collectSource(@NotNull LibrarySource src) {
        ImmutableSeq program = (ImmutableSeq)src.program().get();
        if (program != null) {
            program.forEach((Consumer)((Object)this));
        }
    }

    @Override
    public void accept(@NotNull Stmt stmt) {
        if (stmt instanceof Decl) {
            Decl decl = (Decl)stmt;
            ProjectSymbol children = new ProjectSymbol(this.options, (MutableList<Symbol>)MutableList.create());
            Resolver.withChildren(decl).filter(dv -> dv.concrete != decl && dv.concrete != null).forEach(dv -> children.collect((DefVar<?, ?>)dv, null));
            this.collect(decl.ref(), children);
        }
        SyntaxDeclAction.super.accept(stmt);
    }

    private void collect(@NotNull DefVar<?, ?> dv, @Nullable ProjectSymbol children) {
        SourcePos nameLoc = dv.concrete.sourcePos();
        SourcePos entireLoc = dv.concrete.entireSourcePos();
        Symbol symbol = new Symbol(dv.name(), ComputeSignature.computeSignature(this.options, dv, true), SyntaxHighlight.kindOf(dv), nameLoc, entireLoc, (ImmutableSeq<Symbol>)(children == null ? ImmutableSeq.empty() : children.symbols.toImmutableSeq()));
        this.symbols.append((Object)symbol);
    }

    public record Symbol(@NotNull String name, @NotNull Doc description, @NotNull HighlightInfo.DefKind kind, @NotNull SourcePos nameLocation, @NotNull SourcePos entireLocation, @NotNull ImmutableSeq<Symbol> children) {
    }
}

