/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.value.LazyValue;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.ide.util.ModuleVar;
import org.aya.ide.util.XY;
import org.aya.syntax.concrete.stmt.ModuleName;
import org.aya.syntax.concrete.stmt.StmtVisitor;
import org.aya.syntax.concrete.stmt.decl.DataCon;
import org.aya.syntax.concrete.stmt.decl.DataDecl;
import org.aya.syntax.concrete.stmt.decl.Decl;
import org.aya.syntax.core.def.DataDef;
import org.aya.syntax.core.def.TyckDef;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.syntax.ref.GeneralizedVar;
import org.aya.syntax.ref.LocalVar;
import org.aya.syntax.ref.ModulePath;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Resolver {
    @NotNull
    public static @NotNull Option<@NotNull TyckDef> resolveDef(@NotNull LibraryOwner owner, @NotNull ModulePath module, @NotNull String name) {
        Option<LibrarySource> mod = Resolver.resolveModule(owner, module);
        return mod.mapNotNull(m -> (ImmutableSeq)m.tycked().get()).map(defs -> defs.flatMap(Resolver::withChildren)).flatMap(defs -> defs.find(def -> def.ref().name().equals(name)));
    }

    @NotNull
    public static @NotNull SeqView<WithPos<@NotNull AnyVar>> resolveVar(@NotNull LibrarySource source, XY xy) {
        ImmutableSeq program = (ImmutableSeq)source.program().get();
        if (program == null) {
            return SeqView.empty();
        }
        MutableList collect = MutableList.create();
        program.view().forEach((Consumer)((Object)new XYResolver(xy, (MutableList<WithPos<AnyVar>>)collect)));
        return collect.view().mapNotNull(pos -> {
            AnyVar selector0$temp = (AnyVar)pos.data();
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefVar.class, LocalVar.class, ModuleVar.class, GeneralizedVar.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    DefVar defVar = (DefVar)selector0$temp;
                    yield new WithPos(pos.sourcePos(), (Object)defVar);
                }
                case 1 -> {
                    LocalVar localVar = (LocalVar)selector0$temp;
                    yield new WithPos(pos.sourcePos(), (Object)localVar);
                }
                case 2 -> {
                    ModuleVar moduleVar = (ModuleVar)selector0$temp;
                    yield new WithPos(pos.sourcePos(), (Object)moduleVar);
                }
                case 3 -> {
                    GeneralizedVar gVar = (GeneralizedVar)selector0$temp;
                    yield new WithPos(pos.sourcePos(), (Object)gVar);
                }
                default -> null;
            };
        });
    }

    @NotNull
    private static SeqView<TyckDef> withChildren(@NotNull TyckDef def) {
        TyckDef tyckDef = def;
        Objects.requireNonNull(tyckDef);
        TyckDef tyckDef2 = tyckDef;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataDef.class}, (Object)tyckDef2, n)) {
            case 0 -> {
                DataDef data = (DataDef)tyckDef2;
                yield SeqView.of((Object)data).appendedAll((Iterable)data.body);
            }
            default -> SeqView.of((Object)def);
        };
    }

    @NotNull
    public static SeqView<DefVar<?, ?>> withChildren(@NotNull Decl def) {
        Decl decl = def;
        Objects.requireNonNull(decl);
        Decl decl2 = decl;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataDecl.class}, (Object)decl2, n)) {
            case 0 -> {
                DataDecl data = (DataDecl)decl2;
                yield SeqView.of((Object)data.ref).appendedAll((Iterable)data.body.map(DataCon::ref));
            }
            default -> SeqView.of((Object)def.ref());
        };
    }

    @NotNull
    public static Option<LibrarySource> resolveModule(@NotNull LibraryOwner owner, @NotNull ModulePath module) {
        if (module.isEmpty()) {
            return Option.none();
        }
        LibrarySource mod = owner.findModule(module);
        return mod != null ? Option.some((Object)mod) : Resolver.resolveModule(owner, module.dropLast(1));
    }

    @NotNull
    public static Option<LibrarySource> resolveModule(@NotNull SeqView<LibraryOwner> owners, @NotNull ModulePath module) {
        for (LibraryOwner owner : owners) {
            Option<LibrarySource> found = Resolver.resolveModule(owner, module);
            if (!found.isDefined()) continue;
            return found;
        }
        return Option.none();
    }

    public record XYResolver(XY xy, MutableList<WithPos<AnyVar>> collect) implements StmtVisitor
    {
        public void visitVar(@NotNull SourcePos pos, @NotNull AnyVar var, @NotNull LazyValue<@Nullable Term> type) {
            if (this.xy.inside(pos)) {
                this.collect.append((Object)new WithPos(pos, (Object)var));
            }
        }

        public void visitVarDecl(@NotNull SourcePos pos, @NotNull AnyVar var, @NotNull LazyValue<@Nullable Term> type) {
            LocalVar v;
            if (var instanceof LocalVar && (v = (LocalVar)var).isGenerated()) {
                return;
            }
            super.visitVarDecl(pos, var, type);
        }

        public void visitModuleRef(@NotNull SourcePos pos, @NotNull ModuleName path) {
            this.visitVarRef(pos, new ModuleVar(path), noType);
        }

        public void visitModuleDecl(@NotNull SourcePos pos, @NotNull ModuleName path) {
            this.visitVarDecl(pos, new ModuleVar(path), (LazyValue<Term>)noType);
        }
    }

    public record UsageResolver(@NotNull AnyVar target, @NotNull MutableList<SourcePos> collect) implements StmtVisitor
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitVarRef(@NotNull SourcePos pos, @NotNull AnyVar var, @NotNull LazyValue<@Nullable Term> type) {
            if (this.target != var) {
                if (!(var instanceof DefVar)) return;
                DefVar def = (DefVar)var;
                AnyVar anyVar = this.target;
                if (!(anyVar instanceof DefVar)) return;
                DefVar targetDef = (DefVar)anyVar;
                if (!Objects.equals(def.module, targetDef.module)) return;
                if (!def.name().equals(targetDef.name())) return;
            }
            boolean bl = true;
            boolean usage = bl;
            if (!usage) return;
            this.collect.append((Object)pos);
        }
    }
}

