/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide.action;

import java.util.function.BiFunction;
import org.aya.cli.library.source.LibrarySource;
import org.aya.ide.syntax.SyntaxNodeAction;
import org.aya.ide.util.XY;
import org.aya.normalize.Normalizer;
import org.aya.syntax.concrete.Expr;
import org.aya.syntax.core.term.Term;
import org.aya.syntax.literate.CodeOptions;
import org.aya.tyck.TyckState;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComputeType
implements SyntaxNodeAction.Cursor {
    @Nullable
    public WithPos<Term> result = null;
    @NotNull
    private final LibrarySource source;
    @NotNull
    private final Kind kind;
    @NotNull
    private final Normalizer normalizer;
    @NotNull
    private final XY location;

    @Override
    @NotNull
    public XY location() {
        return this.location;
    }

    public ComputeType(@NotNull LibrarySource source, @NotNull Kind kind, @NotNull TyckState state, @NotNull XY location) {
        this.source = source;
        this.kind = kind;
        this.normalizer = new Normalizer(state);
        this.location = location;
    }

    public void visit(@NotNull SourcePos pos, @NotNull Expr expr) {
        expr.forEach((subPos, subExpr) -> {
            Expr.WithTerm withTerm;
            Term core;
            if (expr instanceof Expr.WithTerm && (core = (withTerm = (Expr.WithTerm)expr).coreType()) != null) {
                this.result = new WithPos(pos, (Object)this.kind.map.apply(this.normalizer, core));
            }
            this.visit((SourcePos)subPos, (Expr)subExpr);
        });
    }

    public record Kind(@NotNull BiFunction<Normalizer, Term, Term> map) {
        @NotNull
        public static Kind type() {
            return new Kind((normalizer, term) -> term);
        }

        @NotNull
        public static Kind nf() {
            return new Kind((fac, term) -> fac.normalize(term, CodeOptions.NormalizeMode.FULL));
        }

        @NotNull
        public static Kind whnf() {
            return new Kind((fac, term) -> fac.normalize(term, CodeOptions.NormalizeMode.HEAD));
        }
    }
}

