/*
 * Decompiled with CFR 0.152.
 */
package org.aya.ide.action;

import java.util.function.Consumer;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.cli.library.source.LibraryOwner;
import org.aya.cli.library.source.LibrarySource;
import org.aya.ide.Resolver;
import org.aya.ide.action.GotoDefinition;
import org.aya.ide.util.XY;
import org.aya.syntax.ref.AnyVar;
import org.aya.syntax.ref.DefVar;
import org.aya.util.error.SourcePos;
import org.aya.util.error.WithPos;
import org.jetbrains.annotations.NotNull;

public interface FindReferences {
    @NotNull
    public static SeqView<SourcePos> findRefs(@NotNull LibrarySource source, @NotNull SeqView<LibraryOwner> libraries, XY xy) {
        SeqView<WithPos<AnyVar>> vars = Resolver.resolveVar(source, xy);
        return FindReferences.findRefs((SeqView<AnyVar>)vars.map(WithPos::data), libraries);
    }

    @NotNull
    public static SeqView<SourcePos> findRefs(@NotNull SeqView<AnyVar> vars, @NotNull SeqView<LibraryOwner> libraries) {
        return vars.flatMap(var -> {
            Resolver.UsageResolver resolver = new Resolver.UsageResolver((AnyVar)var, (MutableList<SourcePos>)MutableList.create());
            return libraries.flatMap(lib -> FindReferences.resolve(resolver, lib));
        });
    }

    @NotNull
    public static SeqView<SourcePos> findRefsOutsideDefs(@NotNull LibrarySource source, @NotNull SeqView<LibraryOwner> libraries, XY xy) {
        SeqView<WithPos<AnyVar>> vars = Resolver.resolveVar(source, xy);
        return FindReferences.findRefsOutsideDefs((SeqView<AnyVar>)vars.map(WithPos::data), libraries);
    }

    @NotNull
    public static SeqView<SourcePos> findRefsOutsideDefs(@NotNull SeqView<AnyVar> vars, @NotNull SeqView<LibraryOwner> libraries) {
        SeqView defPos = vars.filterIsInstance(DefVar.class).map(def -> def.concrete.entireSourcePos());
        return FindReferences.findRefs(vars, libraries).filter(ref -> defPos.noneMatch(pos -> pos.containsIndex(ref)));
    }

    @NotNull
    public static SeqView<SourcePos> findOccurrences(@NotNull LibrarySource source, @NotNull SeqView<LibraryOwner> libraries, XY xy) {
        SeqView defs = GotoDefinition.findDefs(source, libraries, xy).map(WithPos::data);
        SeqView<SourcePos> refs = FindReferences.findRefs(source, libraries, xy);
        return defs.concat(refs);
    }

    @NotNull
    private static SeqView<SourcePos> resolve(@NotNull Resolver.UsageResolver resolver, @NotNull LibraryOwner owner) {
        owner.librarySources().map(src -> (ImmutableSeq)src.program().get()).filterNotNull().forEach(prog -> prog.forEach((Consumer)((Object)resolver)));
        return resolver.collect().view().concat((SeqLike)owner.libraryDeps().flatMap(dep -> FindReferences.resolve(resolver, dep)));
    }
}

