/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.doc;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.DynamicSeq;
import org.aya.pretty.backend.html.DocHtmlPrinter;
import org.aya.pretty.backend.latex.DocTeXPrinter;
import org.aya.pretty.backend.string.LinkId;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.style.DebugStylist;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Doc
extends Docile {
    @NotNull
    public static final Doc ONE_WS;
    @NotNull
    public static final Doc ALT_WS;
    @NotNull
    public static final Doc COMMA;

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public boolean isEmpty() {
        return this instanceof Empty;
    }

    @Override
    @NotNull
    default public Doc toDoc() {
        return this;
    }

    @NotNull
    default public SeqLike<Doc> asSeq() {
        return Seq.of((Object)this);
    }

    @NotNull
    default public String renderToString(@NotNull StringPrinterConfig config) {
        StringPrinter printer = new StringPrinter();
        return (String)this.render(printer, config);
    }

    @NotNull
    default public String renderToHtml() {
        return this.renderToHtml(true);
    }

    @NotNull
    default public String renderToHtml(boolean withHeader) {
        DocHtmlPrinter printer = new DocHtmlPrinter();
        return this.render(printer, new DocHtmlPrinter.Config(withHeader));
    }

    @NotNull
    default public String renderToTeX() {
        DocTeXPrinter printer = new DocTeXPrinter();
        return this.render(printer, new DocTeXPrinter.Config());
    }

    @NotNull
    default public <Out, Config extends PrinterConfig> Out render(@NotNull Printer<Out, Config> printer, @NotNull Config config) {
        return printer.render(config, this);
    }

    @NotNull
    default public String renderWithPageWidth(int pageWidth, boolean unicode) {
        StringPrinterConfig config = new StringPrinterConfig(DebugStylist.INSTANCE, pageWidth, unicode);
        return this.renderToString(config);
    }

    @NotNull
    default public String debugRender() {
        return this.renderWithPageWidth(-1, false);
    }

    @NotNull
    default public String commonRender() {
        return this.renderWithPageWidth(80, true);
    }

    @NotNull
    public static Doc linkDef(@NotNull Doc doc, int hashCode) {
        return new HyperLinked(doc, new LinkId("#" + hashCode), String.valueOf(hashCode));
    }

    @NotNull
    public static Doc linkRef(@NotNull Doc doc, int hashCode) {
        return new HyperLinked(doc, new LinkId("#" + hashCode), null);
    }

    @NotNull
    public static Doc hyperLink(@NotNull Doc doc, @NotNull LinkId link) {
        return new HyperLinked(doc, link, null);
    }

    @NotNull
    public static Doc hyperLink(@NotNull String plain, @NotNull LinkId link) {
        return Doc.hyperLink(Doc.plain(plain), link);
    }

    @NotNull
    public static Doc styled(@NotNull Style style, @NotNull Doc doc) {
        return new Styled((Seq<Style>)Seq.of((Object)style), doc);
    }

    @NotNull
    public static Doc styled(@NotNull Style style, @NotNull String plain) {
        return new Styled((Seq<Style>)Seq.of((Object)style), Doc.plain(plain));
    }

    @NotNull
    public static Doc styled(@NotNull Styles builder, @NotNull Doc doc) {
        return new Styled((Seq<Style>)builder.styles, doc);
    }

    @NotNull
    public static Doc styled(@NotNull Styles builder, @NotNull String plain) {
        return new Styled((Seq<Style>)builder.styles, Doc.plain(plain));
    }

    @NotNull
    public static Doc licit(boolean explicit, Doc doc) {
        return Doc.wrap(explicit ? "(" : "{", explicit ? ")" : "}", doc);
    }

    @NotNull
    public static Doc wrap(String leftSymbol, String rightSymbol, Doc doc) {
        return Doc.cat(Doc.symbol(leftSymbol), doc, Doc.symbol(rightSymbol));
    }

    @NotNull
    public static Doc bracedUnless(Doc doc, boolean falsification) {
        return falsification ? doc : Doc.braced(doc);
    }

    @NotNull
    public static Doc braced(Doc doc) {
        return Doc.wrap("{", "}", doc);
    }

    @NotNull
    public static Doc angled(Doc doc) {
        return Doc.wrap("<", ">", doc);
    }

    @NotNull
    public static Doc parened(Doc doc) {
        return Doc.wrap("(", ")", doc);
    }

    @NotNull
    public static Doc emptyIf(boolean cond, Supplier<@NotNull Doc> otherwise) {
        return cond ? Doc.empty() : otherwise.get();
    }

    @NotNull
    public static Doc empty() {
        return Empty.INSTANCE;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc flatAlt(@NotNull Doc defaultDoc, @NotNull Doc preferWhenFlattened) {
        return new FlatAlt(defaultDoc, preferWhenFlattened);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc column(@NotNull IntFunction<Doc> docBuilder) {
        return new Column(docBuilder);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc nesting(@NotNull IntFunction<Doc> docBuilder) {
        return new Nesting(docBuilder);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc pageWidth(@NotNull IntFunction<Doc> docBuilder) {
        return new PageWidth(docBuilder);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc nest(int indent, @NotNull Doc doc) {
        return indent == 0 ? doc : new Nest(indent, doc);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc align(@NotNull Doc doc) {
        return Doc.column(k -> Doc.nesting(i -> Doc.nest(k - i, doc)));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc hang(int deltaNest, @NotNull Doc doc) {
        return Doc.align(Doc.nest(deltaNest, doc));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc par(int indent, @NotNull Doc doc) {
        return Doc.nest(indent, Doc.cat(Doc.plain(" ".repeat(indent)), doc));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Doc cblock(@NotNull Doc prefix, int indent, @NotNull Doc block) {
        if (block.isEmpty()) {
            return prefix;
        }
        return Doc.vcat(Doc.sep(prefix, Doc.symbol("{")), Doc.nest(indent, Doc.vcat(block)), Doc.symbol("}"));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc ordinal(int n) {
        int m = n % 100;
        if (m >= 4 && m <= 20) {
            return Doc.plain(n + "th");
        }
        return Doc.plain(n + (switch (n % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        }));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc plain(String text) {
        return new PlainText(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc english(String text) {
        if (!text.contains(" ")) {
            return Doc.plain(text);
        }
        return Doc.sep((SeqLike<Doc>)Seq.from((Object[])text.split(" ", -1)).view().map(Doc::plain));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc symbol(String text) {
        if (!1.$assertionsDisabled && text.contains("\n")) {
            throw new AssertionError();
        }
        return new SpecialSymbol(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc cat(@NotNull SeqLike<Doc> docs) {
        return Doc.simpleCat(docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc cat(Doc ... docs) {
        return Doc.cat((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcat(Doc ... docs) {
        return Doc.join(Doc.line(), docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcat(@NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        return Doc.join(Doc.line(), docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcatNonEmpty(Doc ... docs) {
        return Doc.vcatNonEmpty((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcatNonEmpty(@NotNull SeqLike<Doc> docs) {
        return Doc.vcat((SeqLike<Doc>)docs.view().filter(Doc::isNotEmpty));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc stickySep(@NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        return Doc.join(ONE_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc stickySep(Doc ... docs) {
        return Doc.join(ONE_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sep(Doc ... docs) {
        return Doc.join(ALT_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sep(@NotNull SeqLike<Doc> docs) {
        return Doc.join(ALT_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sepNonEmpty(Doc ... docs) {
        return Doc.sepNonEmpty((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sepNonEmpty(@NotNull SeqLike<Doc> docs) {
        return Doc.sep((SeqLike<Doc>)docs.view().filter(Doc::isNotEmpty));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc commaList(@NotNull SeqLike<Doc> docs) {
        return Doc.join(COMMA, docs);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc join(@NotNull Doc delim, Doc ... docs) {
        return Doc.join(delim, (SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc join(@NotNull Doc delim, @NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        ImmutableSeq cache = docs.toImmutableSeq();
        if (cache.isEmpty()) {
            return Doc.empty();
        }
        Doc first = (Doc)cache.first();
        if (cache.sizeEquals(1)) {
            return first;
        }
        return Doc.simpleCat((SeqLike<Doc>)((SeqLike)cache.view().drop(1).foldLeft((Object)DynamicSeq.of((Object)first), (l, r) -> {
            l.append((Object)delim);
            l.append(r);
            return l;
        })));
    }

    @Contract(value="-> new")
    @NotNull
    public static Doc line() {
        return Line.INSTANCE;
    }

    @NotNull
    private static Doc simpleCat(@NotNull @NotNull SeqLike<@NotNull Doc> xs) {
        return new Cat((ImmutableSeq<Doc>)xs.view().flatMap(Doc::asSeq).toImmutableArray());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ONE_WS = Doc.plain(" ");
        ALT_WS = Doc.flatAlt(ONE_WS, Doc.line());
        COMMA = Doc.cat(Doc.plain(","), ALT_WS);
    }

    public record Empty() implements Doc
    {
        @NotNull
        static final Empty INSTANCE = new Empty();

        @Override
        @NotNull
        public SeqLike<Doc> asSeq() {
            return Seq.empty();
        }
    }

    public record HyperLinked(@NotNull Doc doc, @NotNull LinkId link, @Nullable String id) implements Doc
    {
        @Override
        public String toString() {
            return this.doc.toString();
        }
    }

    public record Styled(@NotNull Seq<Style> styles, @NotNull Doc doc) implements Doc
    {
    }

    public record FlatAlt(@NotNull Doc defaultDoc, @NotNull Doc preferWhenFlatten) implements Doc
    {
    }

    public record Column(@NotNull IntFunction<Doc> docBuilder) implements Doc
    {
    }

    public record Nesting(@NotNull IntFunction<Doc> docBuilder) implements Doc
    {
    }

    public record PageWidth(@NotNull IntFunction<Doc> docBuilder) implements Doc
    {
    }

    public record Nest(int indent, @NotNull Doc doc) implements Doc
    {
    }

    public record PlainText(@NotNull String text) implements Doc
    {
    }

    public record SpecialSymbol(@NotNull String text) implements Doc
    {
    }

    public record Line() implements Doc
    {
        @NotNull
        public static final Line INSTANCE = new Line();
    }

    public record Cat(@NotNull ImmutableSeq<Doc> inner) implements Doc
    {
        @Override
        @NotNull
        public SeqLike<Doc> asSeq() {
            return this.inner.view().flatMap(Doc::asSeq);
        }
    }

    public record Union(@NotNull Doc shorterOne, @NotNull Doc longerOne) implements Doc
    {
    }
}

