/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.doc;

import java.io.Serializable;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.printer.ColorScheme;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Style
extends Serializable {
    default public Styles and() {
        return new Styles(this);
    }

    @NotNull
    public static Style italic() {
        return Attr.Italic;
    }

    @NotNull
    public static Style bold() {
        return Attr.Bold;
    }

    @NotNull
    public static Style strike() {
        return Attr.Strike;
    }

    @NotNull
    public static Style code() {
        return Attr.Code;
    }

    @NotNull
    public static Style underline() {
        return Attr.Underline;
    }

    @NotNull
    public static Style color(@NotNull String colorName) {
        return new ColorName(colorName, false);
    }

    @NotNull
    public static Style colorBg(@NotNull String colorName) {
        return new ColorName(colorName, true);
    }

    @NotNull
    public static Style color(int color) {
        return new ColorHex(color, false);
    }

    @NotNull
    public static Style color(float r, float g, float b) {
        return new ColorHex(ColorScheme.colorOf(r, g, b), false);
    }

    @NotNull
    public static Style colorBg(int color) {
        return new ColorHex(color, true);
    }

    @NotNull
    public static Style preset(@NotNull String styleName) {
        return new Preset(styleName);
    }

    public static enum Attr implements Style
    {
        Code,
        Italic,
        Bold,
        Strike,
        Underline;

    }

    public record ColorName(@NotNull String colorName, boolean background) implements Style
    {
    }

    public record ColorHex(int color, boolean background) implements Style
    {
    }

    public record Preset(@NotNull String styleName) implements Style
    {
    }

    public static interface CustomStyle
    extends Style {
    }
}

