/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.latex;

import kala.collection.Map;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.latex.TeXStylist;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;

public class DocTeXPrinter
extends StringPrinter<Config> {
    @NotNull
    private static final Map<String, String> commandMapping = Map.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)"Pi", (Object)"\\Pi"), Tuple.of((Object)"Sig", (Object)"\\Sigma"), Tuple.of((Object)"\\", (Object)"\\lambda"), Tuple.of((Object)"\\/", (Object)"\\lor"), Tuple.of((Object)"/\\", (Object)"\\land"), Tuple.of((Object)"|", (Object)"\\mid"), Tuple.of((Object)"=>", (Object)"\\Rightarrow"), Tuple.of((Object)"->", (Object)"\\to"), Tuple.of((Object)"_|_", (Object)"\\bot"), Tuple.of((Object)"~", (Object)"\\neg"), Tuple.of((Object)"**", (Object)"\\times"), Tuple.of((Object)":", (Object)":"), Tuple.of((Object)".", (Object)"."), Tuple.of((Object)"(", (Object)"("), Tuple.of((Object)")", (Object)")"), Tuple.of((Object)"{", (Object)"\\{"), Tuple.of((Object)"}", (Object)"\\}")});

    @Override
    protected void renderHeader(@NotNull Cursor cursor) {
        cursor.invisibleContent("\\noindent");
    }

    @Override
    protected void renderPlainText(@NotNull Cursor cursor, @NotNull String content) {
        super.renderPlainText(cursor, content.replace("\\", "").replace("_", "\\_"));
    }

    @Override
    protected void renderSpecialSymbol(@NotNull Cursor cursor, @NotNull String text) {
        for (String k : commandMapping.keysView()) {
            if (!text.equals(k)) continue;
            cursor.invisibleContent("$");
            cursor.visibleContent((CharSequence)commandMapping.get((Object)k));
            cursor.invisibleContent("$");
            return;
        }
        System.err.println("Warn: unknown symbol " + text);
        this.renderPlainText(cursor, text);
    }

    @Override
    @NotNull
    public String makeIndent(int indent) {
        if (indent == 0) {
            return "";
        }
        return "\\hspace*{" + (double)indent * 0.5 + "em}";
    }

    @Override
    protected void renderHardLineBreak(@NotNull Cursor cursor) {
        cursor.lineBreakWith("\\\\\n");
    }

    public static class Config
    extends StringPrinterConfig {
        public Config() {
            this(AyaColorScheme.INTELLIJ, AyaStyleFamily.DEFAULT);
        }

        public Config(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
            super(new TeXStylist(colorScheme, styleFamily), -1, false);
        }
    }
}

