/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string;

import org.jetbrains.annotations.NotNull;

public class Cursor {
    private int cursor;
    private int nestLevel;
    private int lineStartCursor;
    private final StringBuilder builder = new StringBuilder();
    private final CursorAPI api;

    public Cursor(CursorAPI api) {
        this.api = api;
    }

    @NotNull
    public CharSequence result() {
        return this.builder;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    public void content(@NotNull CharSequence content, boolean visible) {
        if (visible) {
            this.visibleContent(content);
        } else {
            this.invisibleContent(content);
        }
    }

    public void invisibleContent(@NotNull CharSequence content) {
        this.checkLineStart();
        this.builder.append(content);
    }

    public void visibleContent(@NotNull CharSequence content) {
        this.invisibleContent(content);
        this.moveForward(content.length());
    }

    private void checkLineStart() {
        if (this.isAtLineStart()) {
            this.builder.append(this.api.makeIndent(this.nestLevel));
            this.moveForward(this.nestLevel);
        }
    }

    public void lineBreakWith(@NotNull CharSequence lineBreak) {
        this.visibleContent(lineBreak);
        this.moveToNewLine();
    }

    public boolean isAtLineStart() {
        return this.cursor == this.lineStartCursor;
    }

    public void moveToNewLine() {
        this.lineStartCursor = 0;
        this.cursor = 0;
    }

    public void moveForward(int count) {
        this.cursor += Math.max(0, count);
    }

    public void nested(int nest, @NotNull Runnable r) {
        this.nestLevel += nest;
        r.run();
        this.nestLevel -= nest;
    }

    @FunctionalInterface
    public static interface CursorAPI {
        @NotNull
        public String makeIndent(int var1);
    }
}

