/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.latex;

import java.util.EnumSet;
import kala.collection.Map;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.latex.TeXStylist;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.jetbrains.annotations.NotNull;

public class DocTeXPrinter
extends StringPrinter<Config> {
    @NotNull
    private static final Map<String, String> commandMapping = Map.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)"Sig", (Object)"\\Sigma"), Tuple.of((Object)"\\", (Object)"\\backslash"), Tuple.of((Object)"\\/", (Object)"\\lor"), Tuple.of((Object)"/\\", (Object)"\\land"), Tuple.of((Object)"|", (Object)"\\mid"), Tuple.of((Object)"=>", (Object)"\\Rightarrow"), Tuple.of((Object)"->", (Object)"\\to"), Tuple.of((Object)"_|_", (Object)"\\bot"), Tuple.of((Object)"forall", (Object)"\\forall"), Tuple.of((Object)"\u03a3", (Object)"\\Sigma"), Tuple.of((Object)"\u2228", (Object)"\\lor"), Tuple.of((Object)"\u2227", (Object)"\\land"), Tuple.of((Object)"\u21d2", (Object)"\\Rightarrow"), Tuple.of((Object)"\u2192", (Object)"\\to"), Tuple.of((Object)"\u22a5", (Object)"\\bot"), Tuple.of((Object)"\u2200", (Object)"\\forall"), Tuple.of((Object)"_", (Object)"\\_"), Tuple.of((Object)"~", (Object)"\\neg"), Tuple.of((Object)"**", (Object)"\\times"), DocTeXPrinter.id("(|"), DocTeXPrinter.id("|)"), Tuple.of((Object)"\u2987", (Object)"(|"), Tuple.of((Object)"\u2988", (Object)"|)"), DocTeXPrinter.id("[|"), DocTeXPrinter.id("|]"), Tuple.of((Object)"\u27e6", (Object)"[|"), Tuple.of((Object)"\u27e7", (Object)"|]"), Tuple.of((Object)"{|", (Object)"\\{|"), Tuple.of((Object)"|}", (Object)"|\\}"), Tuple.of((Object)"\u2983", (Object)"\\{|"), Tuple.of((Object)"\u2984", (Object)"|\\}"), DocTeXPrinter.id(":"), DocTeXPrinter.id("."), DocTeXPrinter.id(":="), DocTeXPrinter.id("("), DocTeXPrinter.id(")"), Tuple.of((Object)"{", (Object)"\\{"), Tuple.of((Object)"}", (Object)"\\}")});

    @Override
    protected void renderHeader(@NotNull Cursor cursor) {
        if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.HeaderCode, false).booleanValue()) {
            this.renderStyleCommand(cursor);
        }
    }

    protected void renderStyleCommand(@NotNull Cursor cursor) {
        if (!((Config)this.config).separateStyle()) {
            return;
        }
        if (!((Config)this.config).opt(StringPrinterConfig.StyleOptions.StyleCode, false).booleanValue()) {
            return;
        }
        String colors = TeXStylist.colorsToTex(((TeXStylist)((Config)this.config).getStylist()).colorScheme);
        cursor.invisibleContent(colors + "\n");
        ((TeXStylist)((Config)this.config).getStylist()).styleFamily.definedStyles().forEach((name, style) -> {
            String cmdName = TeXStylist.styleKeyToTex(name);
            String cmd = TeXStylist.stylesToTexCmd(style, "#1");
            String line = "\\newcommand\\%s[1]{%s}".formatted(cmdName, cmd);
            cursor.invisibleContent(line + "\n");
        });
    }

    @Override
    @NotNull
    protected StringStylist prepareStylist() {
        return ((Config)this.config).separateStyle() ? new TeXStylist.ClassedPreset((ClosingStylist)((Config)this.config).getStylist()) : super.prepareStylist();
    }

    @Override
    @NotNull
    protected String escapePlainText(@NotNull String content, EnumSet<StringPrinter.Outer> outer) {
        if (outer.contains((Object)StringPrinter.Outer.Code)) {
            return content;
        }
        if (outer.contains((Object)StringPrinter.Outer.Math)) {
            return content;
        }
        return content.replace("\\", "").replace("_", "\\textunderscore{}").replace("  ", this.makeIndent(2)).replace(" ", this.makeIndent(1));
    }

    @NotNull
    private static Tuple2<String, String> id(@NotNull String name) {
        return Tuple.of((Object)name, (Object)name);
    }

    @Override
    protected void renderSpecialSymbol(@NotNull Cursor cursor, @NotNull String text, EnumSet<StringPrinter.Outer> outer) {
        for (String k : commandMapping.keysView()) {
            if (!text.equals(k)) continue;
            if (!((Config)this.config).katex()) {
                cursor.invisibleContent("\\(");
            }
            cursor.visibleContent((CharSequence)commandMapping.get((Object)k));
            if (!((Config)this.config).katex()) {
                cursor.invisibleContent("\\)");
            }
            return;
        }
        if (!text.chars().allMatch(Character::isLetter)) {
            System.err.println("Warn: unknown symbol " + text);
        }
        this.renderPlainText(cursor, text, outer);
    }

    @Override
    @NotNull
    protected String makeIndent(int indent) {
        if (indent == 0) {
            return "";
        }
        return "\\hspace{" + (double)indent * 0.5 + "em}";
    }

    @Override
    protected void renderHardLineBreak(@NotNull Cursor cursor, EnumSet<StringPrinter.Outer> outer) {
        if (outer.contains((Object)StringPrinter.Outer.List)) {
            cursor.lineBreakWith("\n");
        } else {
            cursor.lineBreakWith("~\\\\\n");
        }
    }

    @Override
    protected void renderInlineCode(@NotNull Cursor cursor,  @NotNull Doc.InlineCode code, EnumSet<StringPrinter.Outer> outer) {
        this.formatInline(cursor, code.code(), "\\texttt{", "}", outer);
    }

    @Override
    protected void renderCodeBlock(@NotNull Cursor cursor,  @NotNull Doc.CodeBlock code, EnumSet<StringPrinter.Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        if (code.language().isAya()) {
            this.renderDoc(cursor, code.code(), outer);
        } else {
            this.formatBlock(cursor, code.code(), "\\begin{minted}[%s]".formatted(code.language().displayName().toLowerCase()), "\\end{minted}", EnumSet.of(StringPrinter.Outer.Code));
        }
    }

    @Override
    protected void renderInlineMath(@NotNull Cursor cursor,  @NotNull Doc.InlineMath code, EnumSet<StringPrinter.Outer> outer) {
        this.formatInline(cursor, code.formula(), "$", "$", EnumSet.of(StringPrinter.Outer.Math));
    }

    @Override
    protected void renderMathBlock(@NotNull Cursor cursor,  @NotNull Doc.MathBlock block, EnumSet<StringPrinter.Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        this.formatBlock(cursor, block.formula(), "\\[", "\\]", EnumSet.of(StringPrinter.Outer.Math));
    }

    @Override
    protected void renderList(@NotNull Cursor cursor,  @NotNull Doc.List list, EnumSet<StringPrinter.Outer> outer) {
        String env = list.isOrdered() ? "enumerate" : "itemize";
        this.separateBlockIfNeeded(cursor, outer);
        this.formatBlock(cursor, "\\begin{" + env + "}", "\\end{" + env + "}", outer, () -> this.formatList(cursor, list, idx -> "\\item", outer));
    }

    public static class Config
    extends StringPrinterConfig<TeXStylist> {
        public Config() {
            this(TeXStylist.DEFAULT);
        }

        public boolean katex() {
            return ((TeXStylist)this.getStylist()).isKaTeX;
        }

        public boolean separateStyle() {
            return this.opt(StringPrinterConfig.StyleOptions.SeparateStyle, false) != false && !this.katex();
        }

        public Config(@NotNull TeXStylist stylist) {
            super(stylist);
        }
    }
}

