/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.collection.Map;
import kala.collection.SeqLike;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.jetbrains.annotations.NotNull;

public class StringPrinter<Config extends StringPrinterConfig<?>>
implements Printer<String, Config> {
    @NotNull
    public static final EnumSet<Outer> FREE = EnumSet.noneOf(Outer.class);
    protected Config config;
    @NotNull
    private static final Map<String, String> unicodeMapping = Map.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)"Sig", (Object)"\u03a3"), Tuple.of((Object)"/\\", (Object)"\u2227"), Tuple.of((Object)"\\/", (Object)"\u2228"), Tuple.of((Object)"=>", (Object)"\u21d2"), Tuple.of((Object)"ulift", (Object)"\u2191"), Tuple.of((Object)"forall", (Object)"\u2200"), Tuple.of((Object)"->", (Object)"\u2192"), Tuple.of((Object)"_|_", (Object)"\u22a5"), Tuple.of((Object)"top", (Object)"\u22a4"), Tuple.of((Object)"(|", (Object)"\u2987"), Tuple.of((Object)"|)", (Object)"\u2988"), Tuple.of((Object)"{|", (Object)"\u2983"), Tuple.of((Object)"|}", (Object)"\u2984"), Tuple.of((Object)"[|", (Object)"\u27e6"), Tuple.of((Object)"|]", (Object)"\u27e7")});

    @NotNull
    protected String makeIndent(int indent) {
        return " ".repeat(indent);
    }

    @Override
    @NotNull
    public String render(@NotNull Config config, @NotNull Doc doc) {
        this.config = config;
        Cursor cursor = new Cursor(this);
        this.renderHeader(cursor);
        this.renderDoc(cursor, doc, FREE);
        this.renderFooter(cursor);
        return cursor.result().toString();
    }

    private int lineRemaining(@NotNull Cursor cursor) {
        int pw = ((PrinterConfig.Basic)this.config).getPageWidth();
        return pw == -1 ? pw : pw - cursor.getCursor();
    }

    protected int predictWidth(@NotNull Cursor cursor, @NotNull Doc doc) {
        Doc doc2 = doc;
        Objects.requireNonNull(doc2);
        Doc doc3 = doc2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Doc.Empty.class, Doc.PlainText.class, Doc.EscapedText.class, Doc.SpecialSymbol.class, Doc.HyperLinked.class, Doc.Image.class, Doc.Styled.class, Doc.Tooltip.class, Doc.Line.class, Doc.FlatAlt.class, Doc.Cat.class, Doc.Nest.class, Doc.Union.class, Doc.Column.class, Doc.Nesting.class, Doc.PageWidth.class, Doc.CodeBlock.class, Doc.InlineCode.class, Doc.InlineMath.class, Doc.MathBlock.class, Doc.List.class}, (Object)doc3, n)) {
            default -> throw new RuntimeException(null, null);
            case 0 -> {
                Doc.Empty d = (Doc.Empty)doc3;
                yield 0;
            }
            case 1 -> {
                String var7_6;
                String text = var7_6 = StringPrinter.$proxy$text((Doc.PlainText)doc3);
                yield text.length();
            }
            case 2 -> {
                String var8_9;
                String text = var8_9 = StringPrinter.$proxy$text((Doc.EscapedText)doc3);
                yield text.length();
            }
            case 3 -> {
                String var9_11;
                String text = var9_11 = StringPrinter.$proxy$text((Doc.SpecialSymbol)doc3);
                yield text.length();
            }
            case 4 -> {
                Doc.HyperLinked text = (Doc.HyperLinked)doc3;
                yield this.predictWidth(cursor, text.doc());
            }
            case 5 -> {
                Doc.Image i = (Doc.Image)doc3;
                yield this.predictWidth(cursor, i.alt());
            }
            case 6 -> {
                Doc.Styled styled = (Doc.Styled)doc3;
                yield this.predictWidth(cursor, styled.doc());
            }
            case 7 -> {
                Doc.Tooltip tooltip = (Doc.Tooltip)doc3;
                yield this.predictWidth(cursor, tooltip.doc());
            }
            case 8 -> {
                Doc.Line d = (Doc.Line)doc3;
                yield 0;
            }
            case 9 -> {
                Doc.FlatAlt alt = (Doc.FlatAlt)doc3;
                yield this.predictWidth(cursor, alt.defaultDoc());
            }
            case 10 -> {
                Doc.Cat cat = (Doc.Cat)doc3;
                yield (Integer)cat.inner().view().map(inner -> this.predictWidth(cursor, (Doc)inner)).reduce(Integer::sum);
            }
            case 11 -> {
                Doc.Nest nest = (Doc.Nest)doc3;
                yield this.predictWidth(cursor, nest.doc()) + nest.indent();
            }
            case 12 -> {
                Doc.Union union = (Doc.Union)doc3;
                yield this.predictWidth(cursor, union.longerOne());
            }
            case 13 -> {
                Doc.Column column = (Doc.Column)doc3;
                yield this.predictWidth(cursor, column.docBuilder().apply(cursor.getCursor()));
            }
            case 14 -> {
                Doc.Nesting nesting = (Doc.Nesting)doc3;
                yield this.predictWidth(cursor, nesting.docBuilder().apply(cursor.getNestLevel()));
            }
            case 15 -> {
                Doc.PageWidth pageWidth = (Doc.PageWidth)doc3;
                yield this.predictWidth(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()));
            }
            case 16 -> {
                Doc.CodeBlock codeBlock = (Doc.CodeBlock)doc3;
                yield this.predictWidth(cursor, codeBlock.code());
            }
            case 17 -> {
                Doc.InlineCode inlineCode = (Doc.InlineCode)doc3;
                yield this.predictWidth(cursor, inlineCode.code());
            }
            case 18 -> {
                Doc.InlineMath inlineMath = (Doc.InlineMath)doc3;
                yield this.predictWidth(cursor, inlineMath.formula());
            }
            case 19 -> {
                Doc.MathBlock mathBlock = (Doc.MathBlock)doc3;
                yield this.predictWidth(cursor, mathBlock.formula());
            }
            case 20 -> {
                Doc.List list = (Doc.List)doc3;
                yield (Integer)list.items().view().map(x -> this.predictWidth(cursor, (Doc)x)).reduce(Integer::sum);
            }
        };
    }

    @NotNull
    protected Doc fitsBetter(@NotNull Cursor cursor, @NotNull Doc a, @NotNull Doc b) {
        if (cursor.isAtLineStart()) {
            return a;
        }
        int lineRem = this.lineRemaining(cursor);
        return lineRem == -1 || this.predictWidth(cursor, a) <= lineRem ? a : b;
    }

    protected void renderHeader(@NotNull Cursor cursor) {
    }

    protected void renderFooter(@NotNull Cursor cursor) {
    }

    protected void renderDoc(@NotNull Cursor cursor, @NotNull Doc doc, EnumSet<Outer> outer) {
        Doc doc2 = doc;
        Objects.requireNonNull(doc2);
        Doc doc3 = doc2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Doc.PlainText.class, Doc.EscapedText.class, Doc.SpecialSymbol.class, Doc.HyperLinked.class, Doc.Image.class, Doc.Styled.class, Doc.Line.class, Doc.FlatAlt.class, Doc.Cat.class, Doc.Nest.class, Doc.Union.class, Doc.Column.class, Doc.Nesting.class, Doc.PageWidth.class, Doc.CodeBlock.class, Doc.InlineCode.class, Doc.List.class, Doc.InlineMath.class, Doc.MathBlock.class, Doc.Tooltip.class, Doc.Empty.class}, (Object)doc3, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                String string;
                String text = string = StringPrinter.$proxy$text((Doc.PlainText)doc3);
                this.renderPlainText(cursor, text, outer);
                break;
            }
            case 1: {
                String string;
                String text = string = StringPrinter.$proxy$text((Doc.EscapedText)doc3);
                cursor.visibleContent(text);
                break;
            }
            case 2: {
                String string;
                String symbol = string = StringPrinter.$proxy$text((Doc.SpecialSymbol)doc3);
                this.renderSpecialSymbol(cursor, symbol, outer);
                break;
            }
            case 3: {
                Doc.HyperLinked text = (Doc.HyperLinked)doc3;
                this.renderHyperLinked(cursor, text, outer);
                break;
            }
            case 4: {
                Doc.Image image = (Doc.Image)doc3;
                this.renderImage(cursor, image, outer);
                break;
            }
            case 5: {
                Doc.Styled styled = (Doc.Styled)doc3;
                this.renderStyled(cursor, styled, outer);
                break;
            }
            case 6: {
                Doc.Line d = (Doc.Line)doc3;
                this.renderHardLineBreak(cursor, outer);
                break;
            }
            case 7: {
                Doc.FlatAlt alt = (Doc.FlatAlt)doc3;
                this.renderFlatAlt(cursor, alt, outer);
                break;
            }
            case 8: {
                Doc.Cat cat = (Doc.Cat)doc3;
                cat.inner().forEach(inner -> this.renderDoc(cursor, (Doc)inner, outer));
                break;
            }
            case 9: {
                Doc.Nest nest = (Doc.Nest)doc3;
                this.renderNest(cursor, nest, outer);
                break;
            }
            case 10: {
                Doc.Union union = (Doc.Union)doc3;
                this.renderUnionDoc(cursor, union, outer);
                break;
            }
            case 11: {
                Doc.Column column = (Doc.Column)doc3;
                this.renderDoc(cursor, column.docBuilder().apply(cursor.getCursor()), outer);
                break;
            }
            case 12: {
                Doc.Nesting nesting = (Doc.Nesting)doc3;
                this.renderDoc(cursor, nesting.docBuilder().apply(cursor.getNestLevel()), outer);
                break;
            }
            case 13: {
                Doc.PageWidth pageWidth = (Doc.PageWidth)doc3;
                this.renderDoc(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()), outer);
                break;
            }
            case 14: {
                Doc.CodeBlock codeBlock = (Doc.CodeBlock)doc3;
                this.renderCodeBlock(cursor, codeBlock, outer);
                break;
            }
            case 15: {
                Doc.InlineCode inlineCode = (Doc.InlineCode)doc3;
                this.renderInlineCode(cursor, inlineCode, outer);
                break;
            }
            case 16: {
                Doc.List list = (Doc.List)doc3;
                this.renderList(cursor, list, outer);
                break;
            }
            case 17: {
                Doc.InlineMath inlineMath = (Doc.InlineMath)doc3;
                this.renderInlineMath(cursor, inlineMath, outer);
                break;
            }
            case 18: {
                Doc.MathBlock mathBlock = (Doc.MathBlock)doc3;
                this.renderMathBlock(cursor, mathBlock, outer);
                break;
            }
            case 19: {
                Doc.Tooltip tooltip = (Doc.Tooltip)doc3;
                this.renderTooltip(cursor, tooltip, outer);
                break;
            }
            case 20: {
                Doc.Empty empty = (Doc.Empty)doc3;
            }
        }
    }

    protected void renderSpecialSymbol(@NotNull Cursor cursor, @NotNull String text, EnumSet<Outer> outer) {
        if (((PrinterConfig.Basic)this.config).opt(StringPrinterConfig.TextOptions.Unicode, false).booleanValue()) {
            for (String k : unicodeMapping.keysView()) {
                if (!text.trim().equals(k)) continue;
                cursor.visibleContent(text.replace(k, (CharSequence)unicodeMapping.get((Object)k)));
                return;
            }
        }
        this.renderPlainText(cursor, text, outer);
    }

    protected void renderNest(@NotNull Cursor cursor, @NotNull Doc.Nest nest, EnumSet<Outer> outer) {
        cursor.nested(nest.indent(), () -> this.renderDoc(cursor, nest.doc(), outer));
    }

    protected void renderUnionDoc(@NotNull Cursor cursor, @NotNull Doc.Union union, EnumSet<Outer> outer) {
        this.renderDoc(cursor, this.fitsBetter(cursor, union.shorterOne(), union.longerOne()), outer);
    }

    protected void renderFlatAlt(@NotNull Cursor cursor, @NotNull Doc.FlatAlt alt, EnumSet<Outer> outer) {
        this.renderDoc(cursor, this.fitsBetter(cursor, alt.defaultDoc(), alt.preferWhenFlatten()), outer);
    }

    protected void renderHyperLinked(@NotNull Cursor cursor, @NotNull Doc.HyperLinked text, EnumSet<Outer> outer) {
        this.renderDoc(cursor, text.doc(), outer);
    }

    protected void renderImage(@NotNull Cursor cursor, @NotNull Doc.Image image, EnumSet<Outer> outer) {
        this.renderDoc(cursor, image.alt(), outer);
    }

    protected void renderStyled(@NotNull Cursor cursor, @NotNull Doc.Styled styled, EnumSet<Outer> outer) {
        StringStylist stylist = this.prepareStylist();
        stylist.format(styled.styles(), cursor, outer, () -> this.renderDoc(cursor, styled.doc(), outer));
    }

    @NotNull
    protected StringStylist prepareStylist() {
        return (StringStylist)((PrinterConfig.Basic)this.config).getStylist();
    }

    protected void renderPlainText(@NotNull Cursor cursor, @NotNull String content, EnumSet<Outer> outer) {
        cursor.visibleContent(this.escapePlainText(content, outer));
    }

    @NotNull
    protected String escapePlainText(@NotNull String content, EnumSet<Outer> outer) {
        return content;
    }

    protected void renderBlockSeparator(@NotNull Cursor cursor, EnumSet<Outer> outer) {
        cursor.lineBreakWith("\n");
    }

    protected void renderHardLineBreak(@NotNull Cursor cursor, EnumSet<Outer> outer) {
        this.renderBlockSeparator(cursor, outer);
    }

    protected void renderTooltip(@NotNull Cursor cursor, @NotNull Doc.Tooltip tooltip, EnumSet<Outer> outer) {
        this.renderDoc(cursor, tooltip.doc(), outer);
    }

    protected void renderCodeBlock(@NotNull Cursor cursor, @NotNull Doc.CodeBlock block, EnumSet<Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        this.formatBlock(cursor, block.code(), "", "", EnumSet.of(Outer.Code));
    }

    protected void renderInlineCode(@NotNull Cursor cursor, @NotNull Doc.InlineCode code, EnumSet<Outer> outer) {
        cursor.visibleContent("`");
        this.renderDoc(cursor, code.code(), EnumSet.of(Outer.Code));
        cursor.visibleContent("`");
    }

    protected void renderMathBlock(@NotNull Cursor cursor, @NotNull Doc.MathBlock block, EnumSet<Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        this.formatBlock(cursor, block.formula(), "", "", EnumSet.of(Outer.Math));
    }

    protected void renderInlineMath(@NotNull Cursor cursor, @NotNull Doc.InlineMath code, EnumSet<Outer> outer) {
        this.renderDoc(cursor, code.formula(), EnumSet.of(Outer.Math));
    }

    protected void renderList(@NotNull Cursor cursor, @NotNull Doc.List list, EnumSet<Outer> outer) {
        this.formatList(cursor, list, outer);
    }

    protected void formatList(@NotNull Cursor cursor, @NotNull Doc.List list, EnumSet<Outer> outer) {
        this.formatList(cursor, list, idx -> list.isOrdered() ? idx + 1 + "." : "-", outer);
    }

    protected void formatList(@NotNull Cursor cursor, @NotNull Doc.List list, @NotNull IntFunction<String> itemBegin, EnumSet<Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        Doc items = Doc.vcat((SeqLike<Doc>)list.items().mapIndexed((idx, item) -> {
            String pre = (String)itemBegin.apply(idx);
            Doc content = Doc.align(item);
            return Doc.stickySep(Doc.escaped(pre), content);
        }));
        this.renderDoc(cursor, items, EnumSet.of(Outer.List));
        if (!outer.contains((Object)Outer.List)) {
            this.separateBlockIfNeeded(cursor, outer);
            this.renderBlockSeparator(cursor, outer);
        }
    }

    protected void separateBlockIfNeeded(@NotNull Cursor cursor, EnumSet<Outer> outer) {
        cursor.whenLineUsed(() -> this.renderBlockSeparator(cursor, outer));
    }

    protected void formatBlock(@NotNull Cursor cursor, @NotNull Doc doc, @NotNull String begin, @NotNull String end, EnumSet<Outer> outer) {
        this.formatBlock(cursor, begin, end, outer, () -> this.renderDoc(cursor, doc, outer));
    }

    protected void formatBlock(@NotNull Cursor cursor, @NotNull String begin, @NotNull String end, EnumSet<Outer> outer, @NotNull Runnable inside) {
        cursor.invisibleContent(begin);
        this.renderBlockSeparator(cursor, outer);
        inside.run();
        this.renderBlockSeparator(cursor, outer);
        cursor.invisibleContent(end);
        this.renderBlockSeparator(cursor, outer);
    }

    protected void formatInline(@NotNull Cursor cursor, @NotNull Doc doc, @NotNull String begin, @NotNull String end, EnumSet<Outer> outer) {
        cursor.invisibleContent(begin);
        this.renderDoc(cursor, doc, outer);
        cursor.invisibleContent(end);
    }

    private static /* synthetic */ String $proxy$text(Doc.PlainText arg0) {
        try {
            return arg0.text();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ String $proxy$text(Doc.EscapedText arg0) {
        try {
            return arg0.text();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ String $proxy$text(Doc.SpecialSymbol arg0) {
        try {
            return arg0.text();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    public static enum Outer {
        Code,
        Math,
        EnclosingTag,
        List;

    }
}

