/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.html;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.doc.Style;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Html5Stylist
extends ClosingStylist {
    @NotNull
    public static final Html5Stylist DEFAULT = new Html5Stylist(AyaColorScheme.EMACS, AyaStyleFamily.DEFAULT);

    public Html5Stylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
        super(colorScheme, styleFamily);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<i>", "</i>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<b>", "</b>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<span style=\"%s\">".formatted(Html5Stylist.styleToCss(line)), "</span>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean background) {
        return new ClosingStylist.StyleToken("<span style=\"%s:%s;\">".formatted(background ? "background-color" : "color", Html5Stylist.cssColor(rgb)), "</span>", false);
    }

    @NotNull
    public static ImmutableSeq<String> styleKeyToCss(@NotNull String className) {
        return ImmutableSeq.from((Object[])className.split("::", -1)).map(Html5Stylist::normalizeCssId);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static String styleToCss(@NotNull Style style) {
        v0 = style;
        Objects.requireNonNull(v0);
        var1_1 = v0;
        var2_3 = 0;
        block11 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.Attr.class, Style.LineThrough.class, Style.ColorHex.class, Style.ColorName.class}, (Object)var1_1, var2_3)) {
            case 0: {
                attr = (Style.Attr)var1_1;
                switch (1.$SwitchMap$org$aya$pretty$doc$Style$Attr[attr.ordinal()]) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case 1: {
                        v1 = "font-style: italic;";
                        break block11;
                    }
                    case 2: 
                }
                v1 = "font-weight: bold;";
                break;
            }
            case 1: {
                var4_5 = (Style.LineThrough)var1_1;
                var8_6 = var4_5.position();
                pos = var8_6;
                var8_6 = var4_5.shape();
                shape = var8_6;
                color = var8_6 = var4_5.color();
                switch (1.$SwitchMap$org$aya$pretty$doc$Style$LineThrough$Position[pos.ordinal()]) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case 1: {
                        v2 = "text-decoration-line: overline;";
                        break;
                    }
                    case 2: {
                        v2 = "text-decoration-line: underline; text-underline-position: under;";
                        break;
                    }
                    case 3: {
                        v2 = "text-decoration-line: line-through;";
                    }
                }
                decoLine = v2;
                switch (1.$SwitchMap$org$aya$pretty$doc$Style$LineThrough$Shape[shape.ordinal()]) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case 1: {
                        v3 = "text-decoration-style: solid;";
                        break;
                    }
                    case 2: {
                        v3 = "text-decoration-style: wavy;";
                    }
                }
                decoStyle = v3;
                var11_13 = color;
                var12_16 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.ColorHex.class, Style.ColorName.class}, (Object)var11_13, var12_16)) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case 0: {
                        var13_18 = (Style.ColorHex)var11_13;
                        rgb = var16_20 = var13_18.color();
                        $ = var16_20 = (int)var13_18.background();
                        v4 = Html5Stylist.cssColor(rgb);
                        break;
                    }
                    case 1: {
                        var16_21 = (Style.ColorName)var11_13;
                        name = var19_26 = var16_21.colorName();
                        $ = var19_27 = var16_21.background();
                        v4 = "var(%s)".formatted(new Object[]{Html5Stylist.cssVar(name)});
                        break;
                    }
                    case -1: {
                        v4 = null;
                    }
                }
                colorRef = v4;
                decoColor = colorRef != null ? "text-decoration-color: %s;".formatted(new Object[]{colorRef}) : "";
                v1 = decoLine + decoStyle + decoColor;
                break;
            }
            case 2: {
                var8_7 = (Style.ColorHex)var1_1;
                rgb = var11_14 = var8_7.color();
                background = var11_14 = (int)var8_7.background();
                if (background == 0) ** GOTO lbl85
                v1 = "background-color: %s".formatted(new Object[]{Html5Stylist.cssColor(rgb)});
                break;
lbl85:
                // 1 sources

                v1 = "color: %s;".formatted(new Object[]{Html5Stylist.cssColor(rgb)});
                break;
            }
            case 3: {
                var11_15 = (Style.ColorName)var1_1;
                name = var14_23 = var11_15.colorName();
                background = var14_24 = var11_15.background();
                if (!background) ** GOTO lbl96
                v1 = "background-color: var(%s);".formatted(new Object[]{Html5Stylist.cssVar(name)});
                break;
lbl96:
                // 1 sources

                v1 = "color: var(%s);".formatted(new Object[]{Html5Stylist.cssVar(name)});
                break;
            }
            default: {
                v1 = null;
            }
        }
        return v1;
        catch (Throwable var1_2) {
            throw new RuntimeException(var1_2.toString(), var1_2);
        }
    }

    @NotNull
    public static String colorsToCss(@NotNull ColorScheme colorScheme) {
        return colorScheme.definedColors().toImmutableSeq().view().map(t -> "%s: %s;".formatted(Html5Stylist.cssVar((String)t.component1()), Html5Stylist.cssColor((Integer)t.component2()))).joinToString((CharSequence)"\n", arg_0 -> Html5Stylist.lambda$colorsToCss$1("  %s", arg_0));
    }

    @NotNull
    public static String cssVar(@NotNull String name) {
        return "--" + Html5Stylist.normalizeCssId(name);
    }

    @NotNull
    public static String cssColor(int rgb) {
        return "#%06x".formatted(rgb);
    }

    @NotNull
    public static String normalizeCssId(@NotNull String selector) {
        selector = selector.replaceAll("::", "-");
        StringBuilder builder = new StringBuilder();
        for (char c : selector.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c >= '\u00a0' || c == '-' || c == '_') {
                builder.append(c);
                continue;
            }
            builder.append(Integer.toHexString(c));
        }
        return builder.toString();
    }

    private static /* synthetic */ CharSequence lambda$colorsToCss$1(String rec$, Object xva$0) {
        return "  %s".formatted(xva$0);
    }

    public static class ClassedPreset
    extends ClosingStylist.Delegate {
        public ClassedPreset(@NotNull ClosingStylist delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        protected ImmutableSeq<ClosingStylist.StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
            String className = (String)Html5Stylist.styleKeyToCss(styleName).getLast();
            return ImmutableSeq.of((Object)new ClosingStylist.StyleToken("<span class=\"%s\">".formatted(className), "</span>", false));
        }
    }
}

