/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.doc;

import java.io.Serializable;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Link
extends Serializable {
    @NotNull
    public static Link page(@NotNull String link) {
        return new DirectLink(link);
    }

    @NotNull
    public static Link cross(@NotNull ImmutableSeq<String> path, @Nullable LocalId location) {
        return new CrossLink(path, location);
    }

    @NotNull
    public static LocalId loc(@NotNull String where) {
        return new LocalId((Either<String, Integer>)Either.left((Object)where));
    }

    @NotNull
    public static LocalId loc(int where) {
        return new LocalId((Either<String, Integer>)Either.right((Object)where));
    }

    public record DirectLink(@NotNull String link) implements Link
    {
    }

    public record CrossLink(@NotNull ImmutableSeq<String> path, @Nullable LocalId location) implements Link
    {
    }

    public record LocalId(@NotNull Either<String, Integer> type) implements Link
    {
    }
}

